/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.FieldPosition;
import java.util.Date;
import javax.servlet.http.Cookie;
import org.apache.catalina.util.DateTool;

public class CookieTools {
    private static final String tspecials = "()<>@,;:\\\"/[]?={} \t";

    public static String getCookieHeaderName(Cookie cookie) {
        int n = cookie.getVersion();
        if (n == 1) {
            return "Set-Cookie2";
        }
        return "Set-Cookie";
    }

    public static String getCookieHeaderValue(Cookie cookie) {
        StringBuffer stringBuffer = new StringBuffer();
        CookieTools.getCookieHeaderValue(cookie, stringBuffer);
        return stringBuffer.toString();
    }

    public static void getCookieHeaderValue(Cookie cookie, StringBuffer stringBuffer) {
        String string;
        int n = cookie.getVersion();
        String string2 = cookie.getName();
        if (string2 == null) {
            string2 = "";
        }
        if ((string = cookie.getValue()) == null) {
            string = "";
        }
        try {
            stringBuffer.append(URLEncoder.encode(string2, "UTF-8"));
            stringBuffer.append("=");
            CookieTools.maybeQuote(n, stringBuffer, URLEncoder.encode(string, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            stringBuffer.append(URLEncoder.encode(string2));
            stringBuffer.append("=");
            CookieTools.maybeQuote(n, stringBuffer, URLEncoder.encode(string));
        }
        if (n == 1) {
            stringBuffer.append(";Version=1");
            if (cookie.getComment() != null) {
                stringBuffer.append(";Comment=");
                try {
                    CookieTools.maybeQuote(n, stringBuffer, URLEncoder.encode(cookie.getComment(), "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    CookieTools.maybeQuote(n, stringBuffer, URLEncoder.encode(cookie.getComment()));
                }
            }
        }
        if (cookie.getDomain() != null) {
            stringBuffer.append(";Domain=");
            CookieTools.maybeQuote(n, stringBuffer, cookie.getDomain());
        }
        if (cookie.getMaxAge() >= 0) {
            if (n == 0) {
                stringBuffer.append(";Expires=");
                if (cookie.getMaxAge() == 0) {
                    DateTool.oldCookieFormat.format(new Date(10000L), stringBuffer, new FieldPosition(0));
                } else {
                    DateTool.oldCookieFormat.format(new Date(System.currentTimeMillis() + (long)cookie.getMaxAge() * 1000L), stringBuffer, new FieldPosition(0));
                }
            } else {
                stringBuffer.append(";Max-Age=");
                stringBuffer.append(cookie.getMaxAge());
            }
        } else if (n == 1) {
            stringBuffer.append(";Discard");
        }
        if (cookie.getPath() != null) {
            stringBuffer.append(";Path=");
            CookieTools.maybeQuote(n, stringBuffer, cookie.getPath());
        }
        if (cookie.getSecure()) {
            stringBuffer.append(";Secure");
        }
    }

    public static void getUnencodedCookieHeaderValue(Cookie cookie, StringBuffer stringBuffer) {
        String string;
        int n = cookie.getVersion();
        String string2 = cookie.getName();
        if (string2 == null) {
            string2 = "";
        }
        if ((string = cookie.getValue()) == null) {
            string = "";
        }
        stringBuffer.append(string2);
        stringBuffer.append("=");
        CookieTools.maybeQuote(n, stringBuffer, string);
        if (n == 1) {
            stringBuffer.append(";Version=1");
            if (cookie.getComment() != null) {
                stringBuffer.append(";Comment=");
                CookieTools.maybeQuote(n, stringBuffer, cookie.getComment());
            }
        }
        if (cookie.getDomain() != null) {
            stringBuffer.append(";Domain=");
            CookieTools.maybeQuote(n, stringBuffer, cookie.getDomain());
        }
        if (cookie.getMaxAge() >= 0) {
            if (n == 0) {
                stringBuffer.append(";Expires=");
                if (cookie.getMaxAge() == 0) {
                    DateTool.oldCookieFormat.format(new Date(10000L), stringBuffer, new FieldPosition(0));
                } else {
                    DateTool.oldCookieFormat.format(new Date(System.currentTimeMillis() + (long)cookie.getMaxAge() * 1000L), stringBuffer, new FieldPosition(0));
                }
            } else {
                stringBuffer.append(";Max-Age=");
                stringBuffer.append(cookie.getMaxAge());
            }
        } else if (n == 1) {
            stringBuffer.append(";Discard");
        }
        if (cookie.getPath() != null) {
            stringBuffer.append(";Path=");
            CookieTools.maybeQuote(n, stringBuffer, cookie.getPath());
        }
        if (cookie.getSecure()) {
            stringBuffer.append(";Secure");
        }
    }

    static void maybeQuote(int n, StringBuffer stringBuffer, String string) {
        if (n == 0 || CookieTools.isToken(string)) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append('\"');
            stringBuffer.append(string);
            stringBuffer.append('\"');
        }
    }

    private static boolean isToken(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c < ' ' || c >= '\u007f' || tspecials.indexOf(c) != -1) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

