/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.startup.UserDatabase;
import org.apache.catalina.util.StringManager;

public final class UserConfig
implements LifecycleListener {
    private String configClass = "org.apache.catalina.startup.ContextConfig";
    private String contextClass = "org.apache.catalina.core.StandardContext";
    private int debug = 999;
    private String directoryName = "public_html";
    private String homeBase = null;
    private Host host = null;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");
    private String userClass = "org.apache.catalina.startup.PasswdUserDatabase";

    public String getConfigClass() {
        return this.configClass;
    }

    public void setConfigClass(String string) {
        this.configClass = string;
    }

    public String getContextClass() {
        return this.contextClass;
    }

    public void setContextClass(String string) {
        this.contextClass = string;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int n) {
        this.debug = n;
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public void setDirectoryName(String string) {
        this.directoryName = string;
    }

    public String getHomeBase() {
        return this.homeBase;
    }

    public void setHomeBase(String string) {
        this.homeBase = string;
    }

    public String getUserClass() {
        return this.userClass;
    }

    public void setUserClass(String string) {
        this.userClass = string;
    }

    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        try {
            this.host = (Host)((Object)lifecycleEvent.getLifecycle());
        }
        catch (ClassCastException classCastException) {
            this.log(sm.getString("hostConfig.cce", lifecycleEvent.getLifecycle()), classCastException);
            return;
        }
        if (lifecycleEvent.getType().equals("start")) {
            this.start();
        } else if (lifecycleEvent.getType().equals("stop")) {
            this.stop();
        }
    }

    private void deploy() {
        Object object;
        if (this.debug >= 1) {
            this.log(sm.getString("userConfig.deploying"));
        }
        UserDatabase userDatabase = null;
        try {
            object = Class.forName(this.userClass);
            userDatabase = (UserDatabase)((Class)object).newInstance();
            userDatabase.setUserConfig(this);
        }
        catch (Exception exception) {
            this.log(sm.getString("userConfig.database"), exception);
            return;
        }
        object = userDatabase.getUsers();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            String string2 = userDatabase.getHome(string);
            this.deploy(string, string2);
        }
    }

    private void deploy(String string, String string2) {
        String string3 = "/~" + string;
        if (this.host.findChild(string3) != null) {
            return;
        }
        File file = new File(string2, this.directoryName);
        if (!file.exists() || !file.isDirectory()) {
            return;
        }
        this.log(sm.getString("userConfig.deploy", string));
        try {
            Class<?> clazz = Class.forName(this.contextClass);
            Context context = (Context)clazz.newInstance();
            context.setPath(string3);
            context.setDocBase(file.toString());
            if (context instanceof Lifecycle) {
                clazz = Class.forName(this.configClass);
                LifecycleListener lifecycleListener = (LifecycleListener)clazz.newInstance();
                ((Lifecycle)((Object)context)).addLifecycleListener(lifecycleListener);
            }
            this.host.addChild(context);
        }
        catch (Exception exception) {
            this.log(sm.getString("userConfig.error", string), exception);
        }
    }

    private void log(String string) {
        Logger logger = null;
        if (this.host != null) {
            logger = this.host.getLogger();
        }
        if (logger != null) {
            logger.log("UserConfig[" + this.host.getName() + "]: " + string);
        } else {
            System.out.println("UserConfig[" + this.host.getName() + "]: " + string);
        }
    }

    private void log(String string, Throwable throwable) {
        Logger logger = null;
        if (this.host != null) {
            logger = this.host.getLogger();
        }
        if (logger != null) {
            logger.log("UserConfig[" + this.host.getName() + "] " + string, throwable);
        } else {
            System.out.println("UserConfig[" + this.host.getName() + "]: " + string);
            System.out.println("" + throwable);
            throwable.printStackTrace(System.out);
        }
    }

    private void start() {
        if (this.debug > 0) {
            this.log(sm.getString("userConfig.start"));
        }
        this.deploy();
    }

    private void stop() {
        if (this.debug > 0) {
            this.log(sm.getString("userConfig.stop"));
        }
    }
}

