/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.logger;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Timestamp;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.logger.LoggerBase;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;

public final class FileLogger
extends LoggerBase
implements Lifecycle {
    private String date = "";
    private String directory = "logs";
    protected static final String info = "org.apache.catalina.logger.FileLogger/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    private String prefix = "catalina.";
    private StringManager sm = StringManager.getManager("org.apache.catalina.logger");
    private boolean started = false;
    private String suffix = ".log";
    private boolean timestamp = false;
    private PrintWriter writer = null;

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String string) {
        String string2 = this.directory;
        this.directory = string;
        this.support.firePropertyChange("directory", string2, this.directory);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String string) {
        String string2 = this.prefix;
        this.prefix = string;
        this.support.firePropertyChange("prefix", string2, this.prefix);
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String string) {
        String string2 = this.suffix;
        this.suffix = string;
        this.support.firePropertyChange("suffix", string2, this.suffix);
    }

    public boolean getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(boolean bl) {
        boolean bl2 = this.timestamp;
        this.timestamp = bl;
        this.support.firePropertyChange("timestamp", new Boolean(bl2), new Boolean(this.timestamp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String string) {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        String string2 = timestamp.toString().substring(0, 19);
        String string3 = string2.substring(0, 10);
        if (!this.date.equals(string3)) {
            FileLogger fileLogger = this;
            synchronized (fileLogger) {
                if (!this.date.equals(string3)) {
                    this.close();
                    this.date = string3;
                    this.open();
                }
            }
        }
        if (this.writer != null) {
            if (this.timestamp) {
                this.writer.println(string2 + " " + string);
            } else {
                this.writer.println(string);
            }
        }
    }

    private void close() {
        if (this.writer == null) {
            return;
        }
        this.writer.flush();
        this.writer.close();
        this.writer = null;
        this.date = "";
    }

    private void open() {
        File file = new File(this.directory);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.directory);
        }
        file.mkdirs();
        try {
            String string = file.getAbsolutePath() + File.separator + this.prefix + this.date + this.suffix;
            this.writer = new PrintWriter((Writer)new FileWriter(string, true), true);
        }
        catch (IOException iOException) {
            this.writer = null;
        }
    }

    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.addLifecycleListener(lifecycleListener);
    }

    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.removeLifecycleListener(lifecycleListener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(this.sm.getString("fileLogger.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(this.sm.getString("fileLogger.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.close();
    }
}

