/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.rmi.AccessException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.core.ApplicationFilterChain;
import org.apache.catalina.core.ApplicationFilterConfig;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.util.InstanceSupport;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;
import org.omg.CORBA.NO_PERMISSION;

final class StandardWrapperValve
extends ValveBase {
    private int debug = 0;
    private FilterDef filterDef = null;
    private static final String info = "org.apache.catalina.core.StandardWrapperValve/1.0";
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");

    StandardWrapperValve() {
    }

    public String getInfo() {
        return info;
    }

    public int invoke(Request request, Response response) throws IOException, ServletException {
        block41: {
            Servlet servlet;
            StandardWrapper standardWrapper;
            Throwable throwable;
            block40: {
                block39: {
                    boolean bl = false;
                    throwable = null;
                    standardWrapper = (StandardWrapper)this.getContainer();
                    ServletRequest servletRequest = request.getRequest();
                    ServletResponse servletResponse = response.getResponse();
                    servlet = null;
                    HttpServletRequest httpServletRequest = null;
                    if (servletRequest instanceof HttpServletRequest) {
                        httpServletRequest = (HttpServletRequest)servletRequest;
                    }
                    HttpServletResponse httpServletResponse = null;
                    if (servletResponse instanceof HttpServletResponse) {
                        httpServletResponse = (HttpServletResponse)servletResponse;
                    }
                    if (!((Context)standardWrapper.getParent()).getAvailable()) {
                        httpServletResponse.sendError(503, sm.getString("standardContext.isUnavailable"));
                        bl = true;
                    }
                    if (!bl && standardWrapper.isUnavailable()) {
                        this.log(sm.getString("standardWrapper.isUnavailable", standardWrapper.getName()));
                        if (httpServletResponse != null) {
                            long l = standardWrapper.getAvailable();
                            if (l > 0L && l < Long.MAX_VALUE) {
                                httpServletResponse.setDateHeader("Retry-After", l);
                            }
                            httpServletResponse.sendError(503, sm.getString("standardWrapper.isUnavailable", standardWrapper.getName()));
                        }
                        bl = true;
                    }
                    try {
                        if (!bl) {
                            servlet = standardWrapper.allocate();
                        }
                    }
                    catch (ServletException servletException) {
                        this.log(sm.getString("standardWrapper.allocateException", standardWrapper.getName()), servletException);
                        throwable = servletException;
                        this.exception(request, response, servletException);
                        servlet = null;
                    }
                    catch (Throwable throwable2) {
                        this.log(sm.getString("standardWrapper.allocateException", standardWrapper.getName()), throwable2);
                        throwable = throwable2;
                        this.exception(request, response, throwable2);
                        servlet = null;
                    }
                    ApplicationFilterChain applicationFilterChain = this.createFilterChain(request, servlet);
                    try {
                        String string = standardWrapper.getJspFile();
                        if (string != null) {
                            servletRequest.setAttribute("org.apache.catalina.jsp_file", (Object)string);
                        } else {
                            servletRequest.removeAttribute("org.apache.catalina.jsp_file");
                        }
                        if (servlet != null) {
                            if (applicationFilterChain != null) {
                                applicationFilterChain.doFilter(servletRequest, servletResponse);
                            } else if (System.getSecurityManager() != null) {
                                final Servlet servlet2 = servlet;
                                final ServletRequest servletRequest2 = servletRequest;
                                final ServletResponse servletResponse2 = servletResponse;
                                try {
                                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                        public Object run() throws ServletException, IOException {
                                            StandardWrapperValve.this.invokeServletService(servlet2, servletRequest2, servletResponse2);
                                            return null;
                                        }
                                    });
                                }
                                catch (PrivilegedActionException privilegedActionException) {
                                    Exception exception = privilegedActionException.getException();
                                    if (exception instanceof ServletException) {
                                        throw (ServletException)((Object)exception);
                                    }
                                    if (exception instanceof AccessException) {
                                        if (exception.getCause() != null && exception.getCause() instanceof NO_PERMISSION) {
                                            httpServletResponse.sendError(403, sm.getString("standardContext.nopermission"));
                                        }
                                        throw new ServletException(exception.getMessage(), (Throwable)exception);
                                    }
                                    if (exception instanceof IOException) {
                                        throw (IOException)exception;
                                    }
                                    if (exception instanceof RuntimeException) {
                                        throw (RuntimeException)exception;
                                    }
                                    throw new ServletException(exception.getMessage(), (Throwable)exception);
                                }
                            } else {
                                this.invokeServletService(servlet, servletRequest, servletResponse);
                            }
                        }
                        servletRequest.removeAttribute("org.apache.catalina.jsp_file");
                    }
                    catch (IOException iOException) {
                        servletRequest.removeAttribute("org.apache.catalina.jsp_file");
                        this.log(sm.getString("standardWrapper.serviceException", standardWrapper.getName()), iOException);
                        throwable = iOException;
                        this.exception(request, response, iOException);
                    }
                    catch (UnavailableException unavailableException) {
                        servletRequest.removeAttribute("org.apache.catalina.jsp_file");
                        this.log(sm.getString("standardWrapper.serviceException", standardWrapper.getName()), unavailableException);
                        standardWrapper.unavailable(unavailableException);
                        long l = standardWrapper.getAvailable();
                        if (l > 0L && l < Long.MAX_VALUE) {
                            httpServletResponse.setDateHeader("Retry-After", l);
                        }
                        httpServletResponse.sendError(503, sm.getString("standardWrapper.isUnavailable", standardWrapper.getName()));
                    }
                    catch (ServletException servletException) {
                        servletRequest.removeAttribute("org.apache.catalina.jsp_file");
                        this.log(sm.getString("standardWrapper.serviceException", standardWrapper.getName()), servletException);
                        throwable = servletException;
                        this.exception(request, response, servletException);
                    }
                    catch (Throwable throwable3) {
                        servletRequest.removeAttribute("org.apache.catalina.jsp_file");
                        this.log(sm.getString("standardWrapper.serviceException", standardWrapper.getName()), throwable3);
                        throwable = throwable3;
                        this.exception(request, response, throwable3);
                    }
                    try {
                        if (applicationFilterChain != null) {
                            applicationFilterChain.release();
                        }
                    }
                    catch (Throwable throwable4) {
                        this.log(sm.getString("standardWrapper.releaseFilters", standardWrapper.getName()), throwable4);
                        if (throwable != null) break block39;
                        throwable = throwable4;
                        this.exception(request, response, throwable4);
                    }
                }
                try {
                    if (servlet != null) {
                        standardWrapper.deallocate(servlet);
                    }
                }
                catch (Throwable throwable5) {
                    this.log(sm.getString("standardWrapper.deallocateException", standardWrapper.getName()), throwable5);
                    if (throwable != null) break block40;
                    throwable = throwable5;
                    this.exception(request, response, throwable5);
                }
            }
            try {
                if (servlet != null && standardWrapper.getAvailable() == Long.MAX_VALUE) {
                    standardWrapper.unload();
                }
            }
            catch (Throwable throwable6) {
                this.log(sm.getString("standardWrapper.unloadException", standardWrapper.getName()), throwable6);
                if (throwable != null) break block41;
                throwable = throwable6;
                this.exception(request, response, throwable6);
            }
        }
        return 2;
    }

    private ApplicationFilterChain createFilterChain(Request request, Servlet servlet) {
        String string;
        if (servlet == null) {
            return null;
        }
        StandardWrapper standardWrapper = (StandardWrapper)this.getContainer();
        StandardContext standardContext = (StandardContext)standardWrapper.getParent();
        FilterMap[] filterMapArray = standardContext.findFilterMaps();
        if (filterMapArray == null || filterMapArray.length == 0) {
            return null;
        }
        ApplicationFilterChain applicationFilterChain = null;
        String string2 = null;
        if (request instanceof HttpRequest) {
            String string3;
            string = (HttpServletRequest)request.getRequest();
            String string4 = string.getContextPath();
            if (string4 == null) {
                string4 = "";
            }
            if ((string3 = string.getRequestURI()).length() >= string4.length()) {
                string2 = string3.substring(string4.length());
            }
        }
        string = standardWrapper.getName();
        int n = 0;
        int n2 = 0;
        while (n2 < filterMapArray.length) {
            ApplicationFilterConfig applicationFilterConfig;
            if (this.matchFiltersURL(filterMapArray[n2], string2) && (applicationFilterConfig = (ApplicationFilterConfig)standardContext.findFilterConfig(filterMapArray[n2].getFilterName())) != null) {
                if (applicationFilterChain == null) {
                    applicationFilterChain = new ApplicationFilterChain();
                }
                applicationFilterChain.addFilter(applicationFilterConfig);
                ++n;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < filterMapArray.length) {
            ApplicationFilterConfig applicationFilterConfig;
            if (this.matchFiltersServlet(filterMapArray[n3], string) && (applicationFilterConfig = (ApplicationFilterConfig)standardContext.findFilterConfig(filterMapArray[n3].getFilterName())) != null) {
                if (applicationFilterChain == null) {
                    applicationFilterChain = new ApplicationFilterChain();
                }
                applicationFilterChain.addFilter(applicationFilterConfig);
                ++n;
            }
            ++n3;
        }
        if (applicationFilterChain != null) {
            applicationFilterChain.setServlet(servlet);
            applicationFilterChain.setSupport(standardWrapper.getInstanceSupport());
        }
        return applicationFilterChain;
    }

    private void exception(Request request, Response response, Throwable throwable) {
        ServletRequest servletRequest = request.getRequest();
        servletRequest.setAttribute("javax.servlet.error.exception", (Object)throwable);
        ServletResponse servletResponse = response.getResponse();
        if (servletResponse instanceof HttpServletResponse) {
            ((HttpServletResponse)servletResponse).setStatus(500);
        }
    }

    private void log(String string) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        if (logger != null) {
            logger.log("StandardWrapperValve[" + this.container.getName() + "]: " + string);
        } else {
            String string2 = null;
            if (this.container != null) {
                string2 = this.container.getName();
            }
            System.out.println("StandardWrapperValve[" + string2 + "]: " + string);
        }
    }

    private void log(String string, Throwable throwable) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        if (logger != null) {
            logger.log("StandardWrapperValve[" + this.container.getName() + "]: " + string, throwable);
        } else {
            String string2 = null;
            if (this.container != null) {
                string2 = this.container.getName();
            }
            System.out.println("StandardWrapperValve[" + string2 + "]: " + string);
            System.out.println("" + throwable);
            throwable.printStackTrace(System.out);
        }
    }

    private boolean matchFiltersServlet(FilterMap filterMap, String string) {
        if (string == null) {
            return false;
        }
        return string.equals(filterMap.getServletName());
    }

    private boolean matchFiltersURL(FilterMap filterMap, String string) {
        if (string == null) {
            return false;
        }
        String string2 = filterMap.getURLPattern();
        if (string2 == null) {
            return false;
        }
        if (string2.equals(string)) {
            return true;
        }
        if (string2.equals("/*")) {
            return true;
        }
        if (string2.endsWith("/*")) {
            String string3 = string;
            while (true) {
                if (string2.equals(string3 + "/*")) {
                    return true;
                }
                int n = string3.lastIndexOf(47);
                if (n < 0) break;
                string3 = string3.substring(0, n);
            }
            return false;
        }
        if (string2.startsWith("*.")) {
            int n = string.lastIndexOf(47);
            int n2 = string.lastIndexOf(46);
            if (n >= 0 && n2 > n) {
                return string2.equals("*." + string.substring(n2 + 1));
            }
        }
        return false;
    }

    private void invokeServletService(Servlet servlet, ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        StandardWrapper standardWrapper = (StandardWrapper)this.getContainer();
        InstanceSupport instanceSupport = standardWrapper.getInstanceSupport();
        try {
            instanceSupport.fireInstanceEvent("beforeService", servlet, servletRequest, servletResponse);
            if (servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
                servlet.service((ServletRequest)((HttpServletRequest)servletRequest), (ServletResponse)((HttpServletResponse)servletResponse));
            } else {
                servlet.service(servletRequest, servletResponse);
            }
            instanceSupport.fireInstanceEvent("afterService", servlet, servletRequest, servletResponse);
        }
        catch (IOException iOException) {
            instanceSupport.fireInstanceEvent("afterService", servlet, servletRequest, servletResponse, (Throwable)iOException);
            throw iOException;
        }
        catch (ServletException servletException) {
            instanceSupport.fireInstanceEvent("afterService", servlet, servletRequest, servletResponse, (Throwable)servletException);
            throw servletException;
        }
        catch (RuntimeException runtimeException) {
            instanceSupport.fireInstanceEvent("afterService", servlet, servletRequest, servletResponse, (Throwable)runtimeException);
            throw runtimeException;
        }
        catch (Throwable throwable) {
            instanceSupport.fireInstanceEvent("afterService", servlet, servletRequest, servletResponse, throwable);
            throw new ServletException(sm.getString("filterChain.servlet"), throwable);
        }
    }
}

