/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletOutputStream;
import org.apache.catalina.connector.HttpResponseBase;
import org.apache.catalina.connector.http.HttpResponseStream;

final class HttpResponseImpl
extends HttpResponseBase {
    protected static final String info = "org.apache.catalina.connector.http.HttpResponseImpl/1.0";
    protected boolean allowChunking;
    protected HttpResponseStream responseStream;

    HttpResponseImpl() {
    }

    public String getInfo() {
        return info;
    }

    void setAllowChunking(boolean bl) {
        this.allowChunking = bl;
    }

    public boolean isChunkingAllowed() {
        return this.allowChunking;
    }

    protected String getProtocol() {
        return "HTTP/1.1";
    }

    public void recycle() {
        super.recycle();
        this.responseStream = null;
        this.allowChunking = false;
    }

    public void sendError(int n, String string) throws IOException {
        this.addHeader("Connection", "close");
        super.sendError(n, string);
    }

    public void reset() {
        String string = this.getHeader("Connection");
        String string2 = this.getHeader("Transfer-Encoding");
        super.reset();
        if (string != null) {
            this.addHeader("Connection", string);
        }
        if (string2 != null) {
            this.addHeader("Transfer-Encoding", string2);
        }
    }

    public ServletOutputStream createOutputStream() throws IOException {
        this.responseStream = new HttpResponseStream(this);
        return this.responseStream;
    }

    public boolean isCloseConnection() {
        String string = this.getHeader("Connection");
        return string != null && string.equals("close");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHeader(String string, String string2) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            ArrayList arrayList = (ArrayList)this.headers.get(string);
            if (arrayList != null && !arrayList.isEmpty()) {
                arrayList.remove(string2);
                if (arrayList.isEmpty()) {
                    this.headers.remove(string);
                }
            }
        }
    }

    public boolean isStreamInitialized() {
        return this.responseStream != null;
    }

    public void finishResponse() throws IOException {
        if (this.getStatus() < 400) {
            if (!this.isStreamInitialized() && this.getContentLength() == -1 && this.getStatus() >= 200 && this.getStatus() != 304 && this.getStatus() != 204) {
                this.setContentLength(0);
            }
        } else {
            this.setHeader("Connection", "close");
        }
        super.finishResponse();
    }

    public void setStatus(int n) {
        super.setStatus(n);
        if (this.responseStream != null) {
            this.responseStream.checkChunking(this);
        }
    }

    public void setContentLength(int n) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        super.setContentLength(n);
        if (this.responseStream != null) {
            this.responseStream.checkChunking(this);
        }
    }
}

