/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.http;

final class HttpRequestLine {
    public static final int INITIAL_METHOD_SIZE = 8;
    public static final int INITIAL_URI_SIZE = 64;
    public static final int INITIAL_PROTOCOL_SIZE = 8;
    public static final int MAX_METHOD_SIZE = 1024;
    public static final int MAX_URI_SIZE = 32768;
    public static final int MAX_PROTOCOL_SIZE = 1024;
    public char[] method;
    public int methodEnd;
    public char[] uri;
    public int uriEnd;
    public char[] protocol;
    public int protocolEnd;

    public HttpRequestLine() {
        this(new char[8], 0, new char[64], 0, new char[8], 0);
    }

    public HttpRequestLine(char[] cArray, int n, char[] cArray2, int n2, char[] cArray3, int n3) {
        this.method = cArray;
        this.methodEnd = n;
        this.uri = cArray2;
        this.uriEnd = n2;
        this.protocol = cArray3;
        this.protocolEnd = n3;
    }

    public void recycle() {
        this.methodEnd = 0;
        this.uriEnd = 0;
        this.protocolEnd = 0;
    }

    public int indexOf(char[] cArray) {
        return this.indexOf(cArray, cArray.length);
    }

    public int indexOf(char[] cArray, int n) {
        char c = cArray[0];
        int n2 = 0;
        while (n2 < this.uriEnd) {
            if ((n2 = this.indexOf(c, n2)) == -1) {
                return -1;
            }
            if (this.uriEnd - n2 < n) {
                return -1;
            }
            int n3 = 0;
            while (n3 < n) {
                if (this.uri[n3 + n2] != cArray[n3]) break;
                if (n3 == n - 1) {
                    return n2;
                }
                ++n3;
            }
            ++n2;
        }
        return -1;
    }

    public int indexOf(String string) {
        return this.indexOf(string.toCharArray(), string.length());
    }

    public int indexOf(char c, int n) {
        int n2 = n;
        while (n2 < this.uriEnd) {
            if (this.uri[n2] == c) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object object) {
        return false;
    }
}

