/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.http;

final class HttpHeader {
    public static final int INITIAL_NAME_SIZE = 32;
    public static final int INITIAL_VALUE_SIZE = 64;
    public static final int MAX_NAME_SIZE = 128;
    public static final int MAX_VALUE_SIZE = 4096;
    public char[] name;
    public int nameEnd;
    public char[] value;
    public int valueEnd;
    protected int hashCode = 0;

    public HttpHeader() {
        this(new char[32], 0, new char[64], 0);
    }

    public HttpHeader(char[] cArray, int n, char[] cArray2, int n2) {
        this.name = cArray;
        this.nameEnd = n;
        this.value = cArray2;
        this.valueEnd = n2;
    }

    public HttpHeader(String string, String string2) {
        this.name = string.toLowerCase().toCharArray();
        this.nameEnd = string.length();
        this.value = string2.toCharArray();
        this.valueEnd = string2.length();
    }

    public void recycle() {
        this.nameEnd = 0;
        this.valueEnd = 0;
        this.hashCode = 0;
    }

    public boolean equals(char[] cArray) {
        return this.equals(cArray, cArray.length);
    }

    public boolean equals(char[] cArray, int n) {
        if (n != this.nameEnd) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (cArray[n2] != this.name[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean equals(String string) {
        return this.equals(string.toCharArray(), string.length());
    }

    public boolean valueEquals(char[] cArray) {
        return this.valueEquals(cArray, cArray.length);
    }

    public boolean valueEquals(char[] cArray, int n) {
        if (n != this.valueEnd) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (cArray[n2] != this.value[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean valueEquals(String string) {
        return this.valueEquals(string.toCharArray(), string.length());
    }

    public boolean valueIncludes(char[] cArray) {
        return this.valueIncludes(cArray, cArray.length);
    }

    public boolean valueIncludes(char[] cArray, int n) {
        char c = cArray[0];
        int n2 = 0;
        while (n2 < this.valueEnd) {
            if ((n2 = this.valueIndexOf(c, n2)) == -1) {
                return false;
            }
            if (this.valueEnd - n2 < n) {
                return false;
            }
            int n3 = 0;
            while (n3 < n) {
                if (this.value[n3 + n2] != cArray[n3]) break;
                if (n3 == n - 1) {
                    return true;
                }
                ++n3;
            }
            ++n2;
        }
        return false;
    }

    public boolean valueIncludes(String string) {
        return this.valueIncludes(string.toCharArray(), string.length());
    }

    public int valueIndexOf(char c, int n) {
        int n2 = n;
        while (n2 < this.valueEnd) {
            if (this.value[n2] == c) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public boolean equals(HttpHeader httpHeader) {
        return this.equals(httpHeader.name, httpHeader.nameEnd);
    }

    public boolean headerEquals(HttpHeader httpHeader) {
        return this.equals(httpHeader.name, httpHeader.nameEnd) && this.valueEquals(httpHeader.value, httpHeader.valueEnd);
    }

    public int hashCode() {
        int n = this.hashCode;
        if (n == 0) {
            int n2 = 0;
            char[] cArray = this.name;
            int n3 = this.nameEnd;
            int n4 = 0;
            while (n4 < n3) {
                n = 31 * n + cArray[n2++];
                ++n4;
            }
            this.hashCode = n;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof String) {
            return this.equals(((String)object).toLowerCase());
        }
        if (object instanceof HttpHeader) {
            return this.equals((HttpHeader)object);
        }
        return false;
    }
}

