/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import org.apache.catalina.Connector;
import org.apache.catalina.Context;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.connector.ResponseFacade;
import org.apache.catalina.connector.ResponseStream;
import org.apache.catalina.connector.ResponseWriter;
import org.apache.catalina.util.CharsetMapper;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.StringManager;

public abstract class ResponseBase
implements Response,
ServletResponse {
    protected boolean appCommitted = false;
    protected byte[] buffer = new byte[8192];
    protected int bufferCount = 0;
    protected boolean committed = false;
    protected Connector connector = null;
    protected int contentCount = 0;
    protected int contentLength = -1;
    protected String contentType = null;
    protected Context context = null;
    protected String encoding = null;
    protected ResponseFacade facade = new ResponseFacade(this);
    protected boolean included = false;
    protected static final String info = "org.apache.catalina.connector.ResponseBase/1.0";
    protected Locale locale = Locale.getDefault();
    protected OutputStream output = null;
    protected Request request = null;
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.connector");
    protected ServletOutputStream stream = null;
    protected boolean suspended = false;
    protected PrintWriter writer = null;
    protected boolean error = false;
    protected boolean isClosing = false;

    public void setAppCommitted(boolean bl) {
        this.appCommitted = bl;
    }

    public boolean isAppCommitted() {
        return this.appCommitted || this.committed;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public int getContentCount() {
        return this.contentCount;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public boolean getIncluded() {
        return this.included;
    }

    public void setIncluded(boolean bl) {
        this.included = bl;
    }

    public String getInfo() {
        return info;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public ServletResponse getResponse() {
        return this.facade;
    }

    public OutputStream getStream() {
        return this.output;
    }

    public void setStream(OutputStream outputStream) {
        this.output = outputStream;
    }

    public void setSuspended(boolean bl) {
        this.suspended = bl;
        if (this.stream != null) {
            ((ResponseStream)this.stream).setSuspended(bl);
        }
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void setError() {
        this.error = true;
    }

    public boolean isError() {
        return this.error;
    }

    public void setClosing() {
        this.isClosing = true;
    }

    public boolean isClosing() {
        return this.isClosing;
    }

    public ServletOutputStream createOutputStream() throws IOException {
        return new ResponseStream(this);
    }

    public void finishResponse() throws IOException {
        if (this.stream == null) {
            ServletOutputStream servletOutputStream = this.getOutputStream();
            servletOutputStream.close();
            return;
        }
        if (((ResponseStream)this.stream).closed()) {
            return;
        }
        if (this.writer != null) {
            this.writer.close();
        } else {
            this.stream.close();
        }
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public PrintWriter getReporter() {
        if (this.isError()) {
            try {
                if (this.stream == null) {
                    this.stream = this.createOutputStream();
                }
            }
            catch (IOException iOException) {
                return null;
            }
            try {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)this.stream, this.getCharacterEncoding());
                return new PrintWriter(outputStreamWriter);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return null;
            }
        }
        if (this.stream != null) {
            return null;
        }
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)this.getOutputStream(), this.getCharacterEncoding());
            return new PrintWriter(outputStreamWriter);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void recycle() {
        this.bufferCount = 0;
        this.committed = false;
        this.appCommitted = false;
        this.suspended = false;
        this.contentCount = 0;
        this.contentLength = -1;
        this.contentType = null;
        this.context = null;
        this.encoding = null;
        this.included = false;
        this.locale = Locale.getDefault();
        this.output = null;
        this.request = null;
        this.stream = null;
        this.writer = null;
        this.error = false;
        this.isClosing = false;
    }

    public void write(int n) throws IOException {
        if (this.suspended) {
            throw new IOException(sm.getString("responseBase.write.suspended"));
        }
        if (this.buffer.length == 0) {
            this.writeUnBuffered(n);
            return;
        }
        if (this.bufferCount >= this.buffer.length) {
            this.flushBuffer();
        }
        this.buffer[this.bufferCount++] = (byte)n;
        ++this.contentCount;
    }

    public void write(byte[] byArray) throws IOException {
        if (this.suspended) {
            throw new IOException(sm.getString("responseBase.write.suspended"));
        }
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.suspended) {
            throw new IOException(sm.getString("responseBase.write.suspended"));
        }
        if (n2 == 0) {
            return;
        }
        if (this.buffer.length == 0) {
            this.writeUnBuffered(byArray, n, n2);
            return;
        }
        if (n2 <= this.buffer.length - this.bufferCount) {
            System.arraycopy(byArray, n, this.buffer, this.bufferCount, n2);
            this.bufferCount += n2;
            this.contentCount += n2;
            return;
        }
        this.flushBuffer();
        int n3 = n2 / this.buffer.length;
        int n4 = n3 * this.buffer.length;
        int n5 = n2 - n4;
        int n6 = 0;
        while (n6 < n3) {
            this.write(byArray, n + n6 * this.buffer.length, this.buffer.length);
            ++n6;
        }
        if (n5 > 0) {
            this.write(byArray, n + n4, n5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBuffer() throws IOException {
        this.committed = true;
        if (this.bufferCount > 0) {
            try {
                this.output.write(this.buffer, 0, this.bufferCount);
                Object var2_1 = null;
                this.bufferCount = 0;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.bufferCount = 0;
                throw throwable;
            }
        }
    }

    public int getBufferSize() {
        return this.buffer.length;
    }

    public String getCharacterEncoding() {
        if (this.encoding == null) {
            return "ISO-8859-1";
        }
        return this.encoding;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException(sm.getString("responseBase.getOutputStream.ise"));
        }
        if (this.stream == null) {
            this.stream = this.createOutputStream();
        }
        ((ResponseStream)this.stream).setCommit(true);
        return this.stream;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer != null) {
            return this.writer;
        }
        if (this.stream != null) {
            throw new IllegalStateException(sm.getString("responseBase.getWriter.ise"));
        }
        ResponseStream responseStream = (ResponseStream)this.createOutputStream();
        responseStream.setCommit(false);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)((Object)responseStream), this.getCharacterEncoding());
        this.writer = new ResponseWriter(outputStreamWriter, responseStream);
        this.stream = responseStream;
        return this.writer;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void reset() {
        if (this.committed) {
            throw new IllegalStateException(sm.getString("responseBase.reset.ise"));
        }
        if (this.included) {
            return;
        }
        if (this.stream != null) {
            ((ResponseStream)this.stream).reset();
        }
        this.bufferCount = 0;
        this.contentLength = -1;
        this.contentType = null;
    }

    public void resetBuffer() {
        if (this.committed) {
            throw new IllegalStateException(sm.getString("responseBase.resetBuffer.ise"));
        }
        this.bufferCount = 0;
    }

    public void setBufferSize(int n) {
        if (this.committed || this.bufferCount > 0) {
            throw new IllegalStateException(sm.getString("responseBase.setBufferSize.ise"));
        }
        if (this.buffer.length == n) {
            return;
        }
        this.buffer = new byte[n];
    }

    public void setContentLength(int n) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.contentLength = n;
    }

    public void setContentType(String string) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.contentType = string;
        if (string.indexOf(59) >= 0) {
            this.encoding = RequestUtil.parseCharacterEncoding(string);
            if (this.encoding == null) {
                this.encoding = "ISO-8859-1";
            }
        }
    }

    public void setLocale(Locale locale) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.locale = locale;
        if (this.context != null) {
            CharsetMapper charsetMapper = this.context.getCharsetMapper();
            this.encoding = charsetMapper.getCharset(locale);
            if (this.contentType != null) {
                if (this.contentType.indexOf(59) < 0) {
                    this.contentType = this.contentType + ";charset=" + this.encoding;
                } else {
                    int n = this.contentType.indexOf(59);
                    this.contentType = this.contentType.substring(0, n) + ";charset=" + this.encoding;
                }
            }
        }
    }

    private void writeUnBuffered(int n) throws IOException {
        this.flushBuffer();
        this.output.write(n);
    }

    private void writeUnBuffered(byte[] byArray, int n, int n2) throws IOException {
        this.flushBuffer();
        this.output.write(byArray, n, n2);
    }
}

