/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.jta;

import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.ControlImpl;
import com.sun.jts.CosTransactions.GlobalTID;
import com.sun.jts.jta.TransactionManagerImpl;
import com.sun.jts.jta.TransactionState;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.Unavailable;

public class TransactionImpl
implements Transaction {
    private Control control;
    private GlobalTID gtid;
    private TransactionManagerImpl tm;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.transaction");
    private long startTime;

    public TransactionImpl(TransactionManagerImpl transactionManagerImpl, Control control, GlobalTID globalTID) throws SystemException {
        this.control = control;
        this.gtid = globalTID;
        this.tm = transactionManagerImpl;
        this.startTime = System.currentTimeMillis();
    }

    Control getControl() {
        return this.control;
    }

    public void commit() throws HeuristicMixedException, RollbackException, HeuristicRollbackException, IllegalStateException, SecurityException, SystemException {
        try {
            if (Configuration.isLocalFactory()) {
                ((ControlImpl)this.control).get_localTerminator().commit(true);
            } else {
                this.control.get_terminator().commit(true);
            }
        }
        catch (TRANSACTION_ROLLEDBACK tRANSACTION_ROLLEDBACK) {
            throw new RollbackException();
        }
        catch (INVALID_TRANSACTION iNVALID_TRANSACTION) {
            throw new IllegalStateException();
        }
        catch (HeuristicMixed heuristicMixed) {
            throw new HeuristicMixedException();
        }
        catch (HeuristicHazard heuristicHazard) {
            throw new HeuristicMixedException();
        }
        catch (NO_PERMISSION nO_PERMISSION) {
            throw new SecurityException();
        }
        catch (Unavailable unavailable) {
            throw new SystemException();
        }
        catch (Exception exception) {
            throw new SystemException();
        }
    }

    public void rollback() throws IllegalStateException, SystemException {
        try {
            if (Configuration.isLocalFactory()) {
                ((ControlImpl)this.control).get_localTerminator().rollback();
            } else {
                this.control.get_terminator().rollback();
            }
        }
        catch (INVALID_TRANSACTION iNVALID_TRANSACTION) {
            throw new IllegalStateException();
        }
        catch (TRANSACTION_ROLLEDBACK tRANSACTION_ROLLEDBACK) {
            throw new IllegalStateException();
        }
        catch (Unavailable unavailable) {
            throw new SystemException();
        }
        catch (Exception exception) {
            throw new SystemException();
        }
    }

    public boolean enlistResource(XAResource xAResource) throws RollbackException, IllegalStateException, SystemException {
        int n = this.getStatus();
        if (n != 0 && n != 1) {
            throw new IllegalStateException();
        }
        try {
            TransactionImpl transactionImpl = this;
            if (transactionImpl.tm.getXAResourceTimeOut() > 0) {
                TransactionImpl transactionImpl2 = this;
                xAResource.setTransactionTimeout(transactionImpl2.tm.getXAResourceTimeOut());
            }
        }
        catch (Exception exception) {
            _logger.log(Level.WARNING, "jts.error_while_setting_xares_txn_timeout", exception);
        }
        try {
            TransactionState transactionState = this.tm.getOrCreateTransactionState(this.gtid, this);
            transactionState.startAssociation(xAResource, this.control, n);
            if (n == 1) {
                throw new RollbackException();
            }
            return true;
        }
        catch (XAException xAException) {
            _logger.log(Level.WARNING, "jts.resource_outside_transaction", xAException);
            if (xAException.errorCode == -9) {
                throw new IllegalStateException();
            }
            throw new SystemException();
        }
    }

    public boolean delistResource(XAResource xAResource, int n) throws IllegalStateException, SystemException {
        try {
            TransactionState transactionState = this.tm.getTransactionState(this.gtid, this);
            if (transactionState == null) {
                throw new IllegalStateException();
            }
            if (!transactionState.containsXAResource(xAResource)) {
                throw new IllegalStateException();
            }
            transactionState.endAssociation(xAResource, n);
            if ((n & 0x20000000) != 0) {
                this.setRollbackOnly();
            }
            return true;
        }
        catch (XAException xAException) {
            throw new SystemException();
        }
    }

    public int getStatus() throws SystemException {
        try {
            Status status = Configuration.isLocalFactory() ? ((ControlImpl)this.control).get_localCoordinator().get_status() : this.control.get_coordinator().get_status();
            return TransactionManagerImpl.mapStatus(status);
        }
        catch (TRANSACTION_ROLLEDBACK tRANSACTION_ROLLEDBACK) {
            return 6;
        }
        catch (INVALID_TRANSACTION iNVALID_TRANSACTION) {
            return 6;
        }
        catch (Unavailable unavailable) {
            return 6;
        }
        catch (Exception exception) {
            _logger.log(Level.WARNING, "jts.unexpected_error_in_getstatus", exception);
            throw new SystemException();
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof TransactionImpl)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        return this.gtid.equals(((TransactionImpl)object).gtid);
    }

    public int hashCode() {
        return this.gtid.hashCode();
    }

    public void registerSynchronization(Synchronization synchronization) throws RollbackException, IllegalStateException, SystemException {
        int n = this.getStatus();
        if (n == 1) {
            throw new RollbackException();
        }
        if (n != 0) {
            throw new IllegalStateException();
        }
        TransactionState transactionState = this.tm.getOrCreateTransactionState(this.gtid, this);
        transactionState.registerSynchronization(synchronization, this.control);
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        int n = this.getStatus();
        if (n != 1 && n != 0) {
            throw new IllegalStateException();
        }
        try {
            if (Configuration.isLocalFactory()) {
                ((ControlImpl)this.control).get_localCoordinator().rollback_only();
            } else {
                this.control.get_coordinator().rollback_only();
            }
        }
        catch (Unavailable unavailable) {
            throw new SystemException();
        }
        catch (Inactive inactive) {
            throw new IllegalStateException();
        }
        catch (Exception exception) {
            throw new SystemException();
        }
    }

    private static void assertit(boolean bl) {
        if (!bl) {
            Exception exception = new Exception();
            _logger.log(Level.WARNING, "jts.assert", exception);
        }
    }

    public String getTransactionId() {
        return this.gtid.toString();
    }

    public long getStartTime() {
        return this.startTime;
    }
}

