/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.CoordinatorImpl;
import com.sun.jts.CosTransactions.RecoveryManager;
import com.sun.jts.CosTransactions.TimeoutInfo;
import com.sun.jts.CosTransactions.TimeoutThread;
import com.sun.jts.CosTransactions.TopCoordinator;
import com.sun.logging.LogDomains;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CosTransactions.Status;

class TimeoutManager {
    static final int CANCEL_TIMEOUT = 0;
    static final int NO_TIMEOUT = 0;
    static final int ACTIVE_TIMEOUT = 1;
    static final int IN_DOUBT_TIMEOUT = 2;
    private static boolean initialised = false;
    private static Hashtable pendingTimeouts = new Hashtable();
    private static TimeoutThread timeoutThread = null;
    private static boolean timeoutActive = false;
    private static boolean quiescing = false;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.transaction");

    TimeoutManager() {
    }

    static synchronized void initialise() {
        if (initialised) {
            return;
        }
        initialised = true;
        if (!timeoutActive && timeoutThread == null) {
            timeoutThread = new TimeoutThread();
            timeoutThread.start();
            timeoutActive = true;
        }
    }

    static synchronized boolean setTimeout(Long l, int n, int n2) {
        boolean bl;
        block7: {
            block6: {
                bl = true;
                if (!timeoutActive) break block6;
                TimeoutInfo timeoutInfo = (TimeoutInfo)pendingTimeouts.get(l);
                switch (n) {
                    case 1: 
                    case 2: {
                        if (timeoutInfo == null) {
                            timeoutInfo = new TimeoutInfo();
                            pendingTimeouts.put(l, timeoutInfo);
                        }
                        timeoutInfo.expireTime = new Date().getTime() + (long)(n2 * 1000);
                        timeoutInfo.localTID = l;
                        timeoutInfo.timeoutType = n;
                        break;
                    }
                    default: {
                        if (timeoutInfo != null) {
                            boolean bl2 = bl = pendingTimeouts.remove(l) != null;
                            if (quiescing && pendingTimeouts.isEmpty()) {
                                timeoutThread.stop();
                                timeoutActive = false;
                                pendingTimeouts = null;
                                break;
                            } else {
                                break;
                            }
                        } else {
                            break;
                        }
                    }
                }
                break block7;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void timeoutCoordinator(Long l, int n) {
        CoordinatorImpl coordinatorImpl = RecoveryManager.getLocalCoordinator(l);
        if (coordinatorImpl == null) {
            if (_logger.isLoggable(Level.FINER)) {
                _logger.logp(Level.FINER, "TimeoutManager", "timeoutCoordinator()", "RecoveryManager.getLocalCoordinator() returned null,which means txn is done. Setting timeout type to CANCEL_TIMEOUT");
            }
            TimeoutManager.setTimeout(l, 0, 0);
        } else {
            CoordinatorImpl coordinatorImpl2 = coordinatorImpl;
            synchronized (coordinatorImpl2) {
                boolean[] blArray = new boolean[1];
                switch (n) {
                    case 1: {
                        if (_logger.isLoggable(Level.FINER)) {
                            _logger.logp(Level.FINER, "TimeoutManager", "timeoutCoordinator()", "TimeoutManager.timeoutCoordinator():case ACTIVE_TIMEOUTRecoveryManager.getLocalCoordinator() returned non-null,which means txn is still around. Rolling back thetransaction...: GTID is : " + ((TopCoordinator)coordinatorImpl).superInfo.globalTID.toString());
                        }
                        try {
                            coordinatorImpl.rollback(true);
                        }
                        catch (Throwable throwable) {}
                        break;
                    }
                    case 2: {
                        Status status;
                        if (_logger.isLoggable(Level.FINER)) {
                            _logger.logp(Level.FINER, "TimeoutManager", "timeoutCoordinator()", "TimeoutManager.timeoutCoordinator():case IN_DOUBT_TIMEOUTRecoveryManager.getLocalCoordinator() returned non-null,which means txn is still around. Invoking recover(boolean)on TopCoordinator...: GTID is: " + ((TopCoordinator)coordinatorImpl).superInfo.globalTID.toString());
                        }
                        if ((status = ((TopCoordinator)coordinatorImpl).recover(blArray)) == Status.StatusUnknown) {
                            _logger.log(Level.WARNING, "jts.transaction_resync_from_orginator_failed");
                            break;
                        }
                        if (status == Status.StatusCommitted) {
                            try {
                                ((TopCoordinator)coordinatorImpl).commit();
                                if (!blArray[0]) break;
                                ((TopCoordinator)coordinatorImpl).afterCompletion(status);
                            }
                            catch (Throwable throwable) {}
                            break;
                        }
                        try {
                            ((TopCoordinator)coordinatorImpl).rollback(true);
                            if (!blArray[0]) break;
                            ((TopCoordinator)coordinatorImpl).afterCompletion(Status.StatusRolledBack);
                        }
                        catch (Throwable throwable) {}
                        break;
                    }
                }
            }
        }
    }

    static synchronized Enumeration checkTimeouts() {
        Enumeration enumeration = null;
        if (timeoutActive && pendingTimeouts != null) {
            Vector<TimeoutInfo> vector = null;
            Enumeration enumeration2 = pendingTimeouts.elements();
            while (enumeration2.hasMoreElements()) {
                TimeoutInfo timeoutInfo = (TimeoutInfo)enumeration2.nextElement();
                if (new Date().getTime() <= timeoutInfo.expireTime) continue;
                if (vector == null) {
                    vector = new Vector<TimeoutInfo>();
                }
                vector.addElement(timeoutInfo);
            }
            if (vector != null) {
                enumeration = vector.elements();
            }
        }
        return enumeration;
    }

    static synchronized long timeLeft(Long l) {
        TimeoutInfo timeoutInfo = (TimeoutInfo)pendingTimeouts.get(l);
        long l2 = -1L;
        if (timeoutInfo != null && (l2 = timeoutInfo.expireTime - new Date().getTime()) < 0L) {
            l2 = 0L;
        }
        return l2;
    }

    static void shutdown(boolean bl) {
        if (bl || pendingTimeouts == null || pendingTimeouts.isEmpty()) {
            if (timeoutThread != null) {
                timeoutThread.stop();
            }
            if (pendingTimeouts != null) {
                pendingTimeouts.clear();
            }
            pendingTimeouts = null;
            timeoutThread = null;
            timeoutActive = false;
        } else {
            quiescing = true;
        }
    }
}

