/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.LogControl;
import com.sun.jts.CosTransactions.LogException;
import com.sun.jts.CosTransactions.LogExtent;
import com.sun.jts.CosTransactions.LogHandle;
import com.sun.jts.CosTransactions.LogLSN;
import com.sun.jts.CosTransactions.LogRecordEnding;
import com.sun.jts.CosTransactions.LogRecordHeader;

class LogCursor {
    static final int ASCENDING = 0;
    static final int DESCENDING = 1;
    LogCursor blockValid;
    LogControl logControl;
    LogHandle logHandle;
    LogLSN startLSN;
    LogLSN endLSN;
    LogLSN currentLSN;
    int direction;
    boolean symbolicsChecked;

    LogCursor(LogControl logControl, LogHandle logHandle, LogLSN logLSN, LogLSN logLSN2) {
        this.logHandle = logHandle;
        this.logControl = logControl;
        this.startLSN = new LogLSN(logLSN);
        this.currentLSN = new LogLSN(logLSN);
        this.endLSN = new LogLSN(logLSN2);
        this.direction = logLSN.lessThan(logLSN2) ? 0 : 1;
        this.blockValid = this;
        this.symbolicsChecked = false;
    }

    public void finalize() {
        this.blockValid = null;
    }

    synchronized byte[] readCursor(int[] nArray, LogLSN logLSN) throws LogException {
        int n;
        Object object;
        if (this.blockValid != this) {
            throw new LogException(null, 20, 1);
        }
        if (this.logHandle == null || this.logHandle.blockValid != this.logHandle) {
            throw new LogException(null, 20, 2);
        }
        if (!this.logControl.logInitialised) {
            throw new LogException(null, 1, 3);
        }
        if (this.logHandle.logControlDescriptor.headLSN.isNULL()) {
            throw new LogException(null, 21, 5);
        }
        if (!this.symbolicsChecked) {
            if (this.currentLSN.equals(LogLSN.HEAD_LSN)) {
                this.currentLSN.copy(this.logHandle.logControlDescriptor.headLSN);
            } else if (this.currentLSN.equals(LogLSN.TAIL_LSN)) {
                this.currentLSN.copy(this.logHandle.logControlDescriptor.tailLSN);
            }
            this.symbolicsChecked = true;
        }
        if (this.currentLSN.greaterThan(this.logHandle.logControlDescriptor.headLSN) || this.currentLSN.lessThan(this.logHandle.logControlDescriptor.tailLSN)) {
            throw new LogException(null, 21, 6);
        }
        boolean bl = false;
        LogExtent logExtent = null;
        LogRecordHeader logRecordHeader = null;
        LogRecordEnding logRecordEnding = null;
        while (!bl) {
            logExtent = this.logHandle.positionFilePointer(this.currentLSN, 0, 1);
            object = new byte[32];
            n = 0;
            try {
                n = logExtent.fileHandle.fileRead((byte[])object);
            }
            catch (LogException logException) {
                logExtent.lastAccess = 0;
                throw new LogException(null, 3, 8);
            }
            logRecordHeader = new LogRecordHeader((byte[])object, 0);
            logExtent.cursorPosition += n;
            if (!logRecordHeader.currentLSN.equals(this.currentLSN)) {
                throw new LogException(null, 4, 9);
            }
            if (logRecordHeader.recordType == 65536) {
                if (this.direction == 0) {
                    this.currentLSN.copy(logRecordHeader.nextLSN);
                    continue;
                }
                this.currentLSN.copy(logRecordHeader.previousLSN);
                continue;
            }
            bl = true;
        }
        object = new byte[][]{new byte[logRecordHeader.recordLength], new byte[8]};
        n = 0;
        try {
            n = logExtent.fileHandle.readVector((byte[][])object);
        }
        catch (LogException logException) {
            logExtent.lastAccess = 0;
            throw new LogException(null, logException.errorCode, 11);
        }
        logExtent.cursorPosition += n;
        logRecordEnding = new LogRecordEnding(object[1], 0);
        if (!logRecordEnding.currentLSN.equals(this.currentLSN)) {
            throw new LogException(null, 4, 12);
        }
        if (this.direction == 0) {
            this.currentLSN.copy(logRecordHeader.nextLSN);
        } else {
            this.currentLSN.copy(logRecordHeader.previousLSN);
        }
        nArray[0] = logRecordHeader.recordType;
        logLSN.copy(logRecordHeader.currentLSN);
        return object[0];
    }
}

