/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.util.JarEntrySource;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class JarAccess {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    public static final String MANIFEST = "META-INF/MANIFEST.MF";
    static final char SEPARATOR = File.separatorChar;
    private File jarName;
    private File dirName;
    private String beanName;
    private String[] fileNames;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$util$JarAccess == null ? (class$com$sun$enterprise$util$JarAccess = JarAccess.class$("com.sun.enterprise.util.JarAccess")) : class$com$sun$enterprise$util$JarAccess);
    static /* synthetic */ Class class$com$sun$enterprise$util$JarAccess;

    public static void create(OutputStream outputStream, File file, String[] stringArray, String[] stringArray2) throws IOException {
        int n = 0;
        if (stringArray != null) {
            n = 1;
        }
        JarEntrySource[] jarEntrySourceArray = new JarEntrySource[stringArray2.length + n];
        if (stringArray != null) {
            jarEntrySourceArray[0] = JarAccess.makeManifestEntry(stringArray);
        }
        int n2 = 0;
        while (n2 < stringArray2.length) {
            jarEntrySourceArray[n2 + n] = new JarEntrySource(JarAccess.entryName(stringArray2[n2]), new File(file, stringArray2[n2]));
            ++n2;
        }
        JarAccess.create(outputStream, jarEntrySourceArray);
    }

    public static JarEntrySource makeManifestEntry(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("Manifest-Version: 1.0\n");
        stringBuffer.append("\n");
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append("Name: " + stringArray[n] + "\n");
            stringBuffer.append("Enterprise-Bean: True\n");
            stringBuffer.append("\n");
            ++n;
        }
        return new JarEntrySource(MANIFEST, new ByteArrayInputStream(stringBuffer.toString().getBytes()));
    }

    public static void create(OutputStream outputStream, String[] stringArray) throws IOException {
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        int n = 0;
        while (n < stringArray.length) {
            JarAccess.addEntry(zipOutputStream, new JarEntrySource(new File(stringArray[n])));
            ++n;
        }
        zipOutputStream.close();
    }

    public static void create(OutputStream outputStream, JarEntrySource[] jarEntrySourceArray) throws IOException {
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        int n = 0;
        while (n < jarEntrySourceArray.length) {
            try {
                JarAccess.addEntry(zipOutputStream, jarEntrySourceArray[n]);
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "enterprise_util.excep_jaraccess_create", exception);
                throw new IOException("Invalid JAR entry: " + jarEntrySourceArray[n].getName());
            }
            ++n;
        }
        zipOutputStream.close();
    }

    private static String entryName(String string) {
        if ((string = string.replace(File.separatorChar, '/')).startsWith("/")) {
            string = string.substring(1);
        } else if (string.startsWith("./")) {
            string = string.substring(2);
        }
        return string;
    }

    static void addEntry(ZipOutputStream zipOutputStream, JarEntrySource jarEntrySource) throws IOException {
        String string = jarEntrySource.getName();
        if (string.equals("") || string.equals(".")) {
            return;
        }
        ZipEntry zipEntry = new ZipEntry(string);
        zipEntry.setTime(jarEntrySource.getTime());
        boolean bl = jarEntrySource.isMarkOnly();
        if (bl) {
            zipEntry.setMethod(0);
            zipEntry.setSize(0L);
            zipEntry.setCrc(0L);
        }
        zipOutputStream.putNextEntry(zipEntry);
        if (!bl) {
            byte[] byArray = new byte[1024];
            int n = 0;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(jarEntrySource.getInputStream());
            while (n != -1) {
                try {
                    n = ((InputStream)bufferedInputStream).read(byArray, 0, byArray.length);
                }
                catch (EOFException eOFException) {
                    break;
                }
                if (n == -1) continue;
                zipOutputStream.write(byArray, 0, n);
            }
            ((InputStream)bufferedInputStream).close();
        }
        zipOutputStream.closeEntry();
    }

    public static void extract(InputStream inputStream, String[] stringArray) throws IOException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        block0: while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (stringArray == null) {
                JarAccess.extractFile(zipInputStream, zipEntry);
                continue;
            }
            String string = zipEntry.getName().replace('/', File.separatorChar);
            int n = 0;
            while (n < stringArray.length) {
                if (string.startsWith(stringArray[n])) {
                    JarAccess.extractFile(zipInputStream, zipEntry);
                    continue block0;
                }
                ++n;
            }
        }
    }

    private static void extractFile(ZipInputStream zipInputStream, ZipEntry zipEntry) throws IOException {
        File file = new File(zipEntry.getName().replace('/', File.separatorChar));
        if (zipEntry.isDirectory()) {
            if (!file.exists() && !file.mkdirs() || !file.isDirectory()) {
                throw new IOException(file + ": could not create directory");
            }
        } else {
            int n;
            Object object;
            if (!(file.getParent() == null || (((File)(object = new File(file.getParent()))).exists() || ((File)object).mkdirs()) && ((File)object).isDirectory())) {
                throw new IOException(object + ": could not create directory");
            }
            object = new FileOutputStream(file);
            byte[] byArray = new byte[512];
            while ((n = zipInputStream.read(byArray, 0, byArray.length)) != -1) {
                ((OutputStream)object).write(byArray, 0, n);
            }
            zipInputStream.closeEntry();
            ((OutputStream)object).close();
        }
    }

    public static Vector extract(InputStream inputStream, String[] stringArray, String string) throws IOException {
        ZipEntry zipEntry;
        Vector<Object> vector = new Vector<Object>();
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        block0: while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            Object object;
            if (stringArray == null) {
                object = JarAccess.extractFile(zipInputStream, zipEntry, string);
                vector.addElement(object);
                continue;
            }
            object = zipEntry.getName().replace('/', File.separatorChar);
            int n = 0;
            while (n < stringArray.length) {
                if (((String)object).startsWith(stringArray[n])) {
                    File file = JarAccess.extractFile(zipInputStream, zipEntry, string);
                    vector.addElement(file);
                    continue block0;
                }
                ++n;
            }
        }
        return vector;
    }

    private static File extractFile(ZipInputStream zipInputStream, ZipEntry zipEntry, String string) throws IOException {
        File file = new File(string + File.separatorChar + zipEntry.getName().replace('/', File.separatorChar));
        if (zipEntry.isDirectory()) {
            if (!file.exists() && !file.mkdirs() || !file.isDirectory()) {
                throw new IOException(file + ": could not create directory");
            }
        } else {
            int n;
            Object object;
            if (!(file.getParent() == null || (((File)(object = new File(file.getParent()))).exists() || ((File)object).mkdirs()) && ((File)object).isDirectory())) {
                throw new IOException(object + ": could not create directory");
            }
            object = new FileOutputStream(file);
            byte[] byArray = new byte[512];
            while ((n = zipInputStream.read(byArray, 0, byArray.length)) != -1) {
                ((OutputStream)object).write(byArray, 0, n);
            }
            zipInputStream.closeEntry();
            ((OutputStream)object).close();
        }
        return file;
    }

    private static void list(InputStream inputStream, String[] stringArray) throws IOException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        block0: while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            String string = zipEntry.getName().replace('/', File.separatorChar);
            zipInputStream.closeEntry();
            if (stringArray == null) {
                JarAccess.printEntry(zipEntry);
                continue;
            }
            int n = 0;
            while (n < stringArray.length) {
                if (string.startsWith(stringArray[n])) {
                    JarAccess.printEntry(zipEntry);
                    continue block0;
                }
                ++n;
            }
        }
    }

    private static void printEntry(ZipEntry zipEntry) throws IOException {
        JarAccess.output(zipEntry.getName());
    }

    private boolean parseArgs(String[] stringArray) {
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2].equals("-bean")) {
                if (n2 + 1 >= n) {
                    JarAccess.error(localStrings.getLocalString("jaraccess.bean.option", ""));
                    return false;
                }
                this.beanName = stringArray[n2 + 1];
                ++n2;
            } else {
                if (!stringArray[n2].equals("-dir")) break;
                if (n2 + 1 >= n) {
                    JarAccess.error(localStrings.getLocalString("jaraccess.dir.option", ""));
                    return false;
                }
                this.dirName = new File(stringArray[n2 + 1]);
                ++n2;
            }
            ++n2;
        }
        if (n2 + 1 >= n) {
            JarAccess.error(localStrings.getLocalString("jaraccess.num.args", ""));
            return false;
        }
        this.jarName = new File(stringArray[n2]);
        this.fileNames = new String[n - ++n2];
        int n3 = 0;
        while (n3 < n - n2) {
            this.fileNames[n3] = stringArray[n3 + n2];
            ++n3;
        }
        return true;
    }

    private void printArgs() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "jarName: " + this.jarName);
            _logger.log(Level.FINE, "dirName: " + this.dirName);
            _logger.log(Level.FINE, "beanName: " + this.beanName);
            _logger.log(Level.FINE, "fileNames: " + this.fileNames);
        }
        if (this.fileNames != null) {
            int n = 0;
            while (n < this.fileNames.length) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "fileNames[" + n + "]: " + this.fileNames[n]);
                }
                ++n;
            }
        }
    }

    protected static void output(String string) {
        _logger.log(Level.FINE, string);
    }

    protected static void error(String string) {
        _logger.log(Level.SEVERE, "enterprise_util.some_error", string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

