/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.session;

import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.MethodUtils;
import java.lang.reflect.Method;
import java.util.Enumeration;

public class TransactionDemarcationHomeInterface
extends EjbTest
implements EjbCheck {
    Result result = null;
    ComponentNameConstructor compName = null;

    public Result check(EjbDescriptor ejbDescriptor) {
        this.result = this.getInitializedResult();
        this.compName = new ComponentNameConstructor(ejbDescriptor);
        try {
            if (ejbDescriptor instanceof EjbSessionDescriptor) {
                String string = ejbDescriptor.getTransactionType();
                Context context = this.getVerifierContext();
                ClassLoader classLoader = context.getClassLoader();
                if (EjbDescriptor.CONTAINER_TRANSACTION_TYPE.equals(string)) {
                    Class<?> clazz;
                    boolean bl = false;
                    if (ejbDescriptor.getHomeClassName() != null && !"".equals(ejbDescriptor.getHomeClassName())) {
                        clazz = classLoader.loadClass(ejbDescriptor.getHomeClassName());
                        while (!(bl = this.commonToBothInterfaces(clazz.getName(), (EjbSessionDescriptor)ejbDescriptor)) && (clazz = clazz.getSuperclass()) != null) {
                        }
                    }
                    if (ejbDescriptor.getLocalHomeClassName() != null && !"".equals(ejbDescriptor.getLocalHomeClassName())) {
                        clazz = classLoader.loadClass(ejbDescriptor.getLocalHomeClassName());
                        while (!(bl = this.commonToBothInterfaces(clazz.getName(), (EjbSessionDescriptor)ejbDescriptor)) && (clazz = clazz.getSuperclass()) != null) {
                        }
                    }
                    if (bl) {
                        this.result.setStatus(1);
                    } else {
                        this.result.setStatus(0);
                    }
                    return this.result;
                }
                this.result.addNaDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable2", "Bean [ {0} ] is not [ {1} ] managed, it is [ {2} ] managed.", new Object[]{ejbDescriptor.getName(), EjbDescriptor.CONTAINER_TRANSACTION_TYPE, string}));
                return this.result;
            }
            this.result.addNaDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
            this.result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "{0} expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Session", "Entity"}));
            return this.result;
        }
        catch (Throwable throwable) {
            this.result.addErrorDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
            this.result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException1", "Error: Home interface  does not contain class [ {1} ] within bean [ {2} ]", new Object[]{throwable.getMessage(), ejbDescriptor.getName()}));
            return this.result;
        }
    }

    private boolean commonToBothInterfaces(String string, EjbSessionDescriptor ejbSessionDescriptor) {
        boolean bl = false;
        try {
            Context context = this.getVerifierContext();
            ClassLoader classLoader = context.getClassLoader();
            Class<?> clazz = classLoader.loadClass(string);
            Method[] methodArray = clazz.getDeclaredMethods();
            boolean bl2 = false;
            int n = 0;
            while (n < methodArray.length) {
                try {
                    ContainerTransaction containerTransaction = null;
                    boolean bl3 = true;
                    if (!ejbSessionDescriptor.getMethodContainerTransactions().isEmpty()) {
                        Enumeration enumeration = ejbSessionDescriptor.getMethodContainerTransactions().keys();
                        while (enumeration.hasMoreElements()) {
                            bl2 = false;
                            MethodDescriptor methodDescriptor = (MethodDescriptor)enumeration.nextElement();
                            bl2 = methodDescriptor.getName().equals(MethodDescriptor.ALL_EJB_METHODS) ? (methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_HOME) ? true : (methodDescriptor.getEjbClassSymbol().equals("") ? true : (methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_REMOTE) ? false : false))) : (methodDescriptor.getParameterClassNames() == null ? (methodDescriptor.getEjbClassSymbol().equals("") || methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_HOME) || methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_LOCALHOME)) && methodArray[n].getName().equals(methodDescriptor.getName()) : (methodDescriptor.getEjbClassSymbol().equals("") || methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_HOME) || methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_LOCALHOME)) && methodArray[n].getName().equals(methodDescriptor.getName()) && MethodUtils.stringArrayEquals(methodDescriptor.getParameterClassNames(), new MethodDescriptor(methodArray[n], ejbSessionDescriptor, classLoader).getParameterClassNames()));
                            if (!bl2) continue;
                            containerTransaction = (ContainerTransaction)ejbSessionDescriptor.getMethodContainerTransactions().get(methodDescriptor);
                            if (containerTransaction != null) {
                                String string2 = containerTransaction.getTransactionAttribute();
                                if (ContainerTransaction.NOT_SUPPORTED.equals(string2) || ContainerTransaction.SUPPORTS.equals(string2) || ContainerTransaction.REQUIRED.equals(string2) || ContainerTransaction.REQUIRES_NEW.equals(string2) || ContainerTransaction.MANDATORY.equals(string2) || ContainerTransaction.NEVER.equals(string2) || !string2.equals("")) {
                                    if (!methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_HOME) || !methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_LOCALHOME)) {
                                        this.result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "Valid: TransactionAttribute [ {0} ] for method [ {1} ] is not defined for home interface [ {2} ]", new Object[]{string2, methodDescriptor.getName(), string}));
                                        continue;
                                    }
                                    bl = true;
                                    this.result.addErrorDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                                    this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: TransactionAttribute [ {0} ] for method [ {1} ] is not valid.   Transaction attributes must not be specified for all methods of session bean home interface [ {2} ].", new Object[]{string2, methodDescriptor.getName(), string}));
                                    bl3 = false;
                                    continue;
                                }
                                this.result.addGoodDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                                this.result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "Valid: TransactionAttribute [ {0} ] for method [ {1} ] is not defined for home interface [ {2} ]", new Object[]{string2, methodDescriptor.getName(), string}));
                                continue;
                            }
                            this.result.addGoodDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                            this.result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passedException", "Valid: TransactionAttribute is null for method [ {0} ]", new Object[]{methodDescriptor.getName()}));
                        }
                        if (!bl3) {
                            bl = true;
                            this.result.addErrorDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                            this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed1", "Error: Transaction attributes must not be specified for the methods defined in the session bean home interface [ {0} ].  Method [ {1} ] has transaction attribute defined within this bean [ {2} ].", new Object[]{string, methodArray[n].getName(), ejbSessionDescriptor.getName()}));
                        } else {
                            this.result.addGoodDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                            this.result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed2", "Valid: Transaction attributes must not be specified for the methods defined in the session bean home interface [ {0} ].  Method [ {1} ] has no transaction attribute defined within this bean [ {2} ].", new Object[]{string, methodArray[n].getName(), ejbSessionDescriptor.getName()}));
                        }
                    } else {
                        this.result.addGoodDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                        this.result.passed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed1", "Valid: There are no method permissions within this bean [ {0} ].   Transaction attributes must not be specified for the methods defined in the session bean home interface [ {1} ].  Method [ {2} ] has no transaction attribute defined.", new Object[]{ejbSessionDescriptor.getName(), string, methodArray[n].getName()}));
                    }
                    if (bl) {
                        return bl;
                    }
                }
                catch (Exception exception) {
                    this.result.addErrorDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                    this.result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException1", "Error: Home interface [ {0} ] does not contain class [ {1} ] within bean [ {2} ]", new Object[]{string, exception.getMessage(), ejbSessionDescriptor.getName()}));
                    return bl;
                }
                ++n;
            }
            return bl;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Verifier.debug(classNotFoundException);
            this.result.addErrorDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
            this.result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Home interface [ {0} ] does not exist or is not loadable within bean [ {1} ]", new Object[]{string, ejbSessionDescriptor.getName()}));
            return bl;
        }
    }
}

