/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.connector.cci;

import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest;

public abstract class ConnectionFactoryTest
extends ConnectorTest {
    protected Class getConnectionFactoryImpl(ConnectorDescriptor connectorDescriptor) throws ClassNotFoundException {
        String string = connectorDescriptor.getConnectionFactoryImpl();
        if (string == null) {
            return null;
        }
        Context context = this.getVerifierContext();
        ClassLoader classLoader = context.getRarClassLoader();
        return classLoader.loadClass(string);
    }

    protected Class testConnectionFactoryImpl(ConnectorDescriptor connectorDescriptor, Result result) {
        Class clazz = null;
        ComponentNameConstructor componentNameConstructor = null;
        try {
            componentNameConstructor = new ComponentNameConstructor(connectorDescriptor);
            clazz = this.getConnectionFactoryImpl(connectorDescriptor);
            if (clazz == null) {
                result.addErrorDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
                result.failed(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.cci.ConnectionFactoryTest.nonimpl", "Error: The resource adapter must implement the javax.resource.cci.ConnectionFactory interface and declare it in the connectionfactory-impl-class deployment descriptor."));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            result.addErrorDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
            result.failed(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.cci.ConnectionFactoryTest.nonexist", "Error: The class [ {0} ] as defined in the connectionfactory-impl-class deployment descriptor does not exist", new Object[]{connectorDescriptor.getConnectionFactoryImpl()}));
        }
        return clazz;
    }

    protected boolean testImplementationOf(ConnectorDescriptor connectorDescriptor, String string, Result result) {
        Class clazz = this.testConnectionFactoryImpl(connectorDescriptor, result);
        if (clazz != null) {
            return VerifierTest.testImplementationOf(clazz, string, result);
        }
        return false;
    }

    public boolean isCCIImplemented(ConnectorDescriptor connectorDescriptor, Result result) {
        Class clazz = this.testConnectionFactoryImpl(connectorDescriptor, result);
        if (clazz != null) {
            return VerifierTest.isImplementorOf(clazz, "javax.resource.cci.ConnectionFactory");
        }
        return false;
    }
}

