/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.connector;

import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorCheck;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CheckConfigPropertyType
extends ConnectorTest
implements ConnectorCheck {
    private static Class[] allowedTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = CheckConfigPropertyType.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Boolean == null ? (class$java$lang$Boolean = CheckConfigPropertyType.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Integer == null ? (class$java$lang$Integer = CheckConfigPropertyType.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Double == null ? (class$java$lang$Double = CheckConfigPropertyType.class$("java.lang.Double")) : class$java$lang$Double, class$java$lang$Byte == null ? (class$java$lang$Byte = CheckConfigPropertyType.class$("java.lang.Byte")) : class$java$lang$Byte, class$java$lang$Short == null ? (class$java$lang$Short = CheckConfigPropertyType.class$("java.lang.Short")) : class$java$lang$Short, class$java$lang$Long == null ? (class$java$lang$Long = CheckConfigPropertyType.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$Float == null ? (class$java$lang$Float = CheckConfigPropertyType.class$("java.lang.Float")) : class$java$lang$Float, class$java$lang$Character == null ? (class$java$lang$Character = CheckConfigPropertyType.class$("java.lang.Character")) : class$java$lang$Character};
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Character;

    public Result check(ConnectorDescriptor connectorDescriptor) {
        boolean bl = false;
        Result result = this.getInitializedResult();
        ComponentNameConstructor componentNameConstructor = new ComponentNameConstructor(connectorDescriptor);
        Set set = connectorDescriptor.getConfigProperties();
        Iterator iterator = set.iterator();
        HashSet hashSet = new HashSet();
        while (iterator.hasNext()) {
            EnvironmentProperty environmentProperty = (EnvironmentProperty)iterator.next();
            String string = environmentProperty.getType();
            if (string == null) {
                result.addErrorDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
                result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notdefined", "Error: The configuration property named [ {0} ] has no type ", new Object[]{environmentProperty.getName()}));
                return result;
            }
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string);
            }
            catch (Throwable throwable) {
                result.addErrorDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
                result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".nonexist", "Error: The type [ {0} ] of the configuration property named [ {1} ] cannot be loaded", new Object[]{environmentProperty.getType(), environmentProperty.getName()}));
                return result;
            }
            boolean bl2 = false;
            int n = 0;
            while (n < allowedTypes.length) {
                if (allowedTypes[n].equals(clazz)) {
                    bl2 = true;
                    break;
                }
                ++n;
            }
            if (bl2) continue;
            bl = true;
            result.addErrorDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
            result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: The type [ {0} ] for the configuration property named [ {1} ] is not allowed", new Object[]{environmentProperty.getType(), environmentProperty.getName()}));
            return result;
        }
        if (!bl) {
            result.addGoodDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
            result.passed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "Success: all properties have an allowed type"));
        }
        return result;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

