/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.packager;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.ApplicationClientArchivist;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectorArchivist;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.FileContentsDescriptor;
import com.sun.enterprise.deployment.WebBundleArchivist;
import com.sun.enterprise.deployment.xml.ApplicationClientRuntimeDescriptorNode;
import com.sun.enterprise.deployment.xml.ApplicationNode;
import com.sun.enterprise.deployment.xml.ContentTransformationException;
import com.sun.enterprise.deployment.xml.ParseException;
import com.sun.enterprise.deployment.xml.RuntimeDescriptorNode;
import com.sun.enterprise.tools.packager.ApplicationAssemblyDescriptor;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class ComponentPackager {
    private static final boolean debug = false;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$packager$ComponentPackager == null ? (class$com$sun$enterprise$tools$packager$ComponentPackager = ComponentPackager.class$("com.sun.enterprise.tools.packager.ComponentPackager")) : class$com$sun$enterprise$tools$packager$ComponentPackager);
    static /* synthetic */ Class class$com$sun$enterprise$tools$packager$ComponentPackager;

    public void handlePackagingException(Exception exception) {
        System.out.println(localStrings.getLocalString("componentpackager.msg008", "Exception during packaging: "));
        if (exception instanceof ParseException) {
            ParseException parseException = (ParseException)exception;
            if (parseException.getSAXException() != null) {
                String string = parseException.getSAXException().getMessage();
                System.out.println(localStrings.getLocalString("componentpackager.msg009", "Error parsing XML: " + string, new String[]{string}));
            } else {
                System.out.println(parseException.getMessage());
            }
            parseException.printStackTrace();
        } else if (exception instanceof ContentTransformationException) {
            ContentTransformationException contentTransformationException = (ContentTransformationException)exception;
            System.out.println(localStrings.getLocalString("componentpackager.msg010", "Error interpreting XML: " + contentTransformationException.getMessage(), new String[]{contentTransformationException.getMessage()}));
            System.out.println(contentTransformationException.getXml());
            contentTransformationException.printStackTrace();
        } else if (exception instanceof IOException) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        } else {
            System.out.println(localStrings.getLocalString("componentpackager.msg011", "Unknown packaging error"));
            exception.printStackTrace();
        }
    }

    private Vector recursiveGetFiles(String string, Vector vector) throws IOException {
        Vector<String> vector2 = new Vector<String>();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            String string2 = (String)vector.elementAt(n2);
            File file = new File(string, string2);
            if (!file.exists()) {
                throw new FileNotFoundException(file.toString());
            }
            if (file.isDirectory()) {
                Set set = FileUtil.getAllFilesUnder(new File(string, string2), null);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    File file2 = (File)iterator.next();
                    if (file2.getPath().endsWith(".java")) continue;
                    vector2.addElement(string2 + File.separator + file2.getPath());
                }
            } else {
                vector2.addElement(string2);
            }
            ++n2;
        }
        return vector2;
    }

    private void deleteDestinationFile(File file) throws IOException {
        boolean bl;
        if (file.exists() && !(bl = file.delete())) {
            throw new IOException(localStrings.getLocalString("componentpackager.msg014", "Error deleting file: " + file.toString(), new String[]{file.toString()}));
        }
    }

    public void packageWebArchive(String string, Vector vector, Vector vector2, String string2, Vector vector3, String string3, String string4) throws Exception {
        int n;
        Vector vector4 = null;
        if (vector != null) {
            vector4 = this.recursiveGetFiles(string, vector);
            int n2 = vector4.size();
            n = 0;
            while (n < n2) {
                String string5 = (String)vector4.elementAt(n);
                vector4.setElementAt(new File(string5), n);
                ++n;
            }
        }
        Vector vector5 = null;
        if (vector3 != null) {
            vector5 = this.recursiveGetFiles(string2, vector3);
            n = vector5.size();
            int n3 = 0;
            while (n3 < n) {
                String string6 = (String)vector5.elementAt(n3);
                vector5.setElementAt(new File(string6), n3);
                ++n3;
            }
        }
        this.deleteDestinationFile(new File(string4));
        WebBundleArchivist.createPackage(string, vector4, vector2, string2, vector5, string3, string4);
    }

    public void packageEjbArchive(String string, Vector vector, String string2, String string3) throws Exception {
        Vector vector2 = this.recursiveGetFiles(string, vector);
        FileContentsDescriptor fileContentsDescriptor = new FileContentsDescriptor(string, vector2);
        File file = new File(string2);
        File file2 = new File(string3);
        this.deleteDestinationFile(file2);
        EjbBundleArchivist.createPackage(fileContentsDescriptor, file, file2);
    }

    public void packageConnectorArchive(String string, Vector vector, String string2, String string3) throws Exception {
        Vector vector2 = this.recursiveGetFiles(string, vector);
        FileContentsDescriptor fileContentsDescriptor = new FileContentsDescriptor(string, vector2);
        File file = new File(string2);
        File file2 = new File(string3);
        this.deleteDestinationFile(file2);
        ConnectorArchivist.createPackage(fileContentsDescriptor, file, file2);
    }

    public void packageApplicationClient(String string, Vector vector, String string2, String string3, String string4) throws Exception {
        Vector vector2 = this.recursiveGetFiles(string, vector);
        FileContentsDescriptor fileContentsDescriptor = new FileContentsDescriptor(string, vector2);
        File file = new File(string3);
        File file2 = new File(string4);
        this.deleteDestinationFile(file2);
        ApplicationClientArchivist.createPackage(fileContentsDescriptor, string2, file, file2);
    }

    private String relativize(String string, String string2) {
        String string3 = string.replace('\\', File.separatorChar).replace('/', File.separatorChar);
        String string4 = string2.replace('\\', File.separatorChar).replace('/', File.separatorChar);
        if (string4.startsWith(string3)) {
            return string4.substring(string3.length(), string4.length());
        }
        return string4;
    }

    public static String getEjbBundleFilename(String string) {
        return string + ".ejbBundle.xml";
    }

    public static String getRuntimeDescriptorFilename(String string) {
        return string + ".runtime.xml";
    }

    public void packageEjbs(String string, Vector vector, String string2, String string3, String string4, String string5) throws Exception {
        Serializable serializable;
        Object object;
        File file;
        Object object2;
        String string6 = "";
        String string7 = "";
        string6 = "".equals(string4) ? ComponentPackager.getEjbBundleFilename(string2) : string4;
        string7 = "".equals(string5) ? ComponentPackager.getRuntimeDescriptorFilename(string2) : string5;
        System.out.println("Package the ejbs specified in " + string6);
        System.out.println(" using the application descriptor in " + string2);
        System.out.println(" and the runtime descriptor in " + string7);
        System.out.println("All files relative to " + string);
        File file2 = new File(string, string2);
        FileInputStream fileInputStream = new FileInputStream(file2);
        ApplicationNode applicationNode = ApplicationNode.read(fileInputStream, false);
        Application application = applicationNode.getApplication(null, null);
        String string8 = application.getName();
        File file3 = new File("ejb-jar-" + System.currentTimeMillis() + new File(string3).getName());
        Vector<Object> vector2 = new Vector<Object>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            file = new File(string, (String)object2);
            if (file.isDirectory()) {
                object = FileUtil.getAllFilesUnder(file, null).iterator();
                while (object.hasNext()) {
                    serializable = null;
                    serializable = ((String)object2).equals(".") ? (File)object.next() : new File((String)object2, ((File)object.next()).toString());
                    vector2.addElement(((File)serializable).toString());
                }
                continue;
            }
            vector2.addElement(object2);
        }
        object2 = new FileContentsDescriptor(string, vector2);
        file = new File(string, string6);
        EjbBundleArchivist.createPackage((FileContentsDescriptor)object2, file, file3);
        object = new ApplicationAssemblyDescriptor();
        ((ApplicationAssemblyDescriptor)object).addJarFilename(file3.getAbsolutePath());
        this.assembleApplication((ApplicationAssemblyDescriptor)object, new Vector(), string8, string3);
        serializable = ApplicationArchivist.open(new File(string3));
        fileInputStream = new FileInputStream(new File(string, string7));
        RuntimeDescriptorNode runtimeDescriptorNode = RuntimeDescriptorNode.read(fileInputStream);
        runtimeDescriptorNode.updateRuntimeInformation((Application)serializable);
        file3.delete();
        ApplicationArchivist applicationArchivist = ((Application)serializable).getApplicationArchivist();
        applicationArchivist.save(applicationArchivist.getApplicationFile(), true);
    }

    public void assembleApplication(ApplicationAssemblyDescriptor applicationAssemblyDescriptor, Vector vector, String string, String string2) throws Exception {
        Object object;
        Vector vector2 = this.recursiveGetFiles(".", vector);
        int n = 0;
        while (n < vector2.size()) {
            object = (String)vector2.elementAt(n);
            applicationAssemblyDescriptor.addLibraryJarFilename((String)object);
            ++n;
        }
        object = new Application(string, new File(string2));
        this.deleteDestinationFile(new File(string2));
        ((Application)object).getApplicationArchivist().save(((Application)object).getApplicationArchivist().getApplicationFile(), true);
        Iterator iterator = applicationAssemblyDescriptor.getJarFilenames().iterator();
        while (iterator.hasNext()) {
            Iterator iterator2;
            BundleDescriptor bundleDescriptor;
            String string3 = (String)iterator.next();
            File file = new File(string3);
            String string4 = applicationAssemblyDescriptor.getExternalDDFilenameFor(string3);
            if (EjbBundleArchivist.isEjbBundle(file)) {
                bundleDescriptor = ((Application)object).getApplicationArchivist().addEjbJar(file, string4);
                if (!applicationAssemblyDescriptor.getLibraryJarFilenames().isEmpty()) {
                    iterator2 = applicationAssemblyDescriptor.getLibraryJarFilenames().iterator();
                    while (iterator2.hasNext()) {
                        bundleDescriptor.getArchivist().addManfiestClasspath(ApplicationAssemblyDescriptor.getLibraryJarEntryNameFrom((String)iterator2.next()));
                    }
                }
            }
            if (WebBundleArchivist.isWebBundle(file)) {
                ((Application)object).getApplicationArchivist().addWebJar(file, string4);
            }
            if (ApplicationClientArchivist.isApplicationClientJar(file)) {
                bundleDescriptor = ((Application)object).getApplicationArchivist().addApplicationClientJar(file, new HashSet(), string4);
                if (!applicationAssemblyDescriptor.getLibraryJarFilenames().isEmpty()) {
                    iterator2 = applicationAssemblyDescriptor.getLibraryJarFilenames().iterator();
                    while (iterator2.hasNext()) {
                        bundleDescriptor.getArchivist().addManfiestClasspath(ApplicationAssemblyDescriptor.getLibraryJarEntryNameFrom((String)iterator2.next()));
                    }
                }
            }
            if (ConnectorArchivist.isConnector(file)) {
                bundleDescriptor = ((Application)object).getApplicationArchivist().addRar(file, new HashSet(), string4);
                if (!applicationAssemblyDescriptor.getLibraryJarFilenames().isEmpty()) {
                    iterator2 = applicationAssemblyDescriptor.getLibraryJarFilenames().iterator();
                    while (iterator2.hasNext()) {
                        bundleDescriptor.getArchivist().addManfiestClasspath(ApplicationAssemblyDescriptor.getLibraryJarEntryNameFrom((String)iterator2.next()));
                    }
                }
            }
            if (!ApplicationArchivist.isApplication(file)) continue;
            ((Application)object).getApplicationArchivist().addApplicationJar(file);
        }
        if (!applicationAssemblyDescriptor.getLibraryJarFilenames().isEmpty()) {
            ((Application)object).getApplicationArchivist().addFiles(applicationAssemblyDescriptor.getLibraryJarFilenameToEntryNameMap(), ((Application)object).getApplicationArchivist().getApplicationFile());
        }
        ((Application)object).getApplicationArchivist().save(((Application)object).getApplicationArchivist().getApplicationFile(), false);
        System.out.println(localStrings.getLocalString("componentpackager.msg012", "Creation of application in " + string2 + " is complete", new String[]{string2}));
    }

    public void setRuntimeDeploymentInfo(Application application, File file) throws Exception {
        this.setRuntimeDeploymentInfo(application, file, null);
    }

    public void setRuntimeDeploymentInfo(Application application, File file, File file2) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(file);
        RuntimeDescriptorNode runtimeDescriptorNode = RuntimeDescriptorNode.read(fileInputStream);
        runtimeDescriptorNode.updateRuntimeInformation(application);
        if (file2 == null) {
            file2 = application.getApplicationArchivist().getApplicationFile();
        }
        application.getApplicationArchivist().save(file2, true);
        System.out.println(localStrings.getLocalString("componentpackager.msg013", "Set runtime done"));
    }

    public void setClientRuntimeDeploymentInfo(ApplicationClientDescriptor applicationClientDescriptor, File file) throws Exception {
        this.setClientRuntimeDeploymentInfo(applicationClientDescriptor, file, (File)null);
    }

    public void setClientRuntimeDeploymentInfo(ApplicationClientDescriptor applicationClientDescriptor, File file, File file2) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(file);
        ApplicationClientRuntimeDescriptorNode applicationClientRuntimeDescriptorNode = ApplicationClientRuntimeDescriptorNode.read(fileInputStream);
        applicationClientRuntimeDescriptorNode.updateRuntimeInformation(applicationClientDescriptor);
        if (file2 == null) {
            file2 = new File(applicationClientDescriptor.getArchivist().getArchiveUri());
        }
        ((ApplicationClientArchivist)applicationClientDescriptor.getArchivist()).save(file2, true);
        System.out.println(localStrings.getLocalString("componentpackager.msg013", "Set runtime done"));
    }

    public void setClientRuntimeDeploymentInfo(Application application, File file, String string) throws Exception {
        this.setClientRuntimeDeploymentInfo(application, file, string, null);
    }

    public void setClientRuntimeDeploymentInfo(Application application, File file, String string, File file2) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(file);
        ApplicationClientRuntimeDescriptorNode applicationClientRuntimeDescriptorNode = ApplicationClientRuntimeDescriptorNode.read(fileInputStream);
        ApplicationClientDescriptor applicationClientDescriptor = application.getApplicationClientByName(string);
        applicationClientRuntimeDescriptorNode.updateRuntimeInformation(applicationClientDescriptor);
        if (file2 == null) {
            file2 = application.getApplicationArchivist().getApplicationFile();
        }
        application.getApplicationArchivist().save(file2, true);
        System.out.println("Set runtime on client within application  done");
    }

    public String toString() {
        return "ComponentPackager";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

