/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.login;

import com.sun.enterprise.security.PrincipalImpl;
import com.sun.enterprise.security.auth.login.PasswordCredential;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class ClientPasswordLoginModule
implements LoginModule {
    private static Logger _logger = null;
    private static final String DEFAULT_REALMNAME = "default";
    private static LocalStringManagerImpl localStrings;
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean debug = false;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private String username;
    private char[] password;
    private final PasswordCredential passwordCredential = null;
    private PrincipalImpl userPrincipal;
    public static String LOGIN_NAME;
    public static String LOGIN_PASSWORD;
    static /* synthetic */ Class class$com$sun$enterprise$security$auth$login$ClientPasswordLoginModule;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = map;
        this.options = map2;
        this.debug = "true".equalsIgnoreCase((String)map2.get("debug"));
    }

    public boolean login() throws LoginException {
        Callback[] callbackArray;
        if (this.callbackHandler == null) {
            String string = localStrings.getLocalString("login.nocallback", "Error: no CallbackHandler available to garner authentication information from the user");
            throw new LoginException(string);
        }
        String string = System.getProperty(LOGIN_NAME);
        if (string != null) {
            this.username = new String(string);
            String string2 = System.getProperty(LOGIN_PASSWORD);
            if (string2 == null) {
                callbackArray = (Callback[])new char[0];
                this.password = new char[0];
            } else {
                int n = string2.length();
                callbackArray = (Callback[])new char[n];
                string2.getChars(0, n, (char[])callbackArray, 0);
                this.password = new char[n];
            }
            System.arraycopy(callbackArray, 0, this.password, 0, callbackArray.length);
        } else {
            callbackArray = new Callback[]{new NameCallback(localStrings.getLocalString("login.username", "ClientPasswordModule username: ")), new PasswordCallback(localStrings.getLocalString("login.password", "ClientPasswordModule password: "), false)};
            try {
                this.callbackHandler.handle(callbackArray);
                this.username = ((NameCallback)callbackArray[0]).getName();
                if (this.username == null) {
                    String string3 = localStrings.getLocalString("login.nousername", "No user specified");
                    throw new LoginException(string3);
                }
                char[] cArray = ((PasswordCallback)callbackArray[1]).getPassword();
                if (cArray == null) {
                    cArray = new char[]{};
                }
                this.password = new char[cArray.length];
                System.arraycopy(cArray, 0, this.password, 0, cArray.length);
                ((PasswordCallback)callbackArray[1]).clearPassword();
            }
            catch (IOException iOException) {
                throw new LoginException(iOException.toString());
            }
            catch (UnsupportedCallbackException unsupportedCallbackException) {
                String string4 = localStrings.getLocalString("login.callback", "Error: Callback not available to garner authentication information from user(CallbackName):");
                throw new LoginException(string4 + unsupportedCallbackException.getCallback().toString());
            }
        }
        if (this.debug) {
            int n = 0;
            while (n < this.password.length) {
                ++n;
            }
        }
        if (this.debug) {
            _logger.log(Level.FINE, "\t\t[ClientPasswordLoginModule] authentication succeeded");
        }
        this.succeeded = true;
        return true;
    }

    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        this.userPrincipal = new PrincipalImpl(this.username);
        if (!this.subject.getPrincipals().contains(this.userPrincipal)) {
            this.subject.getPrincipals().add(this.userPrincipal);
        }
        if (this.debug) {
            _logger.log(Level.FINE, "\t\t[ClientPasswordLoginModule] added PrincipalImpl to Subject");
        }
        String string = DEFAULT_REALMNAME;
        PasswordCredential passwordCredential = new PasswordCredential(this.username, new String(this.password), string);
        if (!this.subject.getPrivateCredentials().contains(passwordCredential)) {
            this.subject.getPrivateCredentials().add(passwordCredential);
        }
        this.username = null;
        int n = 0;
        while (n < this.password.length) {
            this.password[n] = 32;
            ++n;
        }
        this.password = null;
        this.commitSucceeded = true;
        return true;
    }

    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.username = null;
            if (this.password != null) {
                int n = 0;
                while (n < this.password.length) {
                    this.password[n] = 32;
                    ++n;
                }
                this.password = null;
            }
            this.userPrincipal = null;
        } else {
            this.logout();
        }
        return true;
    }

    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.userPrincipal);
        this.succeeded = false;
        this.succeeded = this.commitSucceeded;
        this.username = null;
        if (this.password != null) {
            int n = 0;
            while (n < this.password.length) {
                this.password[n] = 32;
                ++n;
            }
            this.password = null;
        }
        this.userPrincipal = null;
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
        localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$security$auth$login$ClientPasswordLoginModule == null ? (class$com$sun$enterprise$security$auth$login$ClientPasswordLoginModule = ClientPasswordLoginModule.class$("com.sun.enterprise.security.auth.login.ClientPasswordLoginModule")) : class$com$sun$enterprise$security$auth$login$ClientPasswordLoginModule);
        LOGIN_NAME = "j2eelogin.name";
        LOGIN_PASSWORD = "j2eelogin.password";
    }
}

