/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming;

import com.iplanet.ias.jms.IASJmsUtil;
import com.sun.ejb.Container;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationException;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.NamingManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.JmsDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.MailConfiguration;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.jms.ConnectionFactoryWrapperStandalone;
import com.sun.enterprise.jms.JmsWrapperFactory;
import com.sun.enterprise.naming.BindingsEnum;
import com.sun.enterprise.naming.J2EEEnvWrapper;
import com.sun.enterprise.naming.NamePairsEnum;
import com.sun.enterprise.naming.SerialContextProvider;
import com.sun.enterprise.naming.SerialNameParser;
import com.sun.enterprise.naming.java.javaURLContext;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.ORBManager;
import com.sun.enterprise.util.ObjectInputStreamWithLoader;
import com.sun.logging.LogDomains;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.Topic;
import javax.mail.Session;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;

public final class NamingManagerImpl
implements NamingManager {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.naming");
    public static final String SERIALOBJECT_FACTORY = "com.sun.enterprise.naming.factory.SerialObjectFactory";
    public static final String IIOPOBJECT_FACTORY = "com.sun.enterprise.naming.factory.IIOPObjectFactory";
    public static final String MAIL_COMPONENT_FACTORY = "com.sun.enterprise.naming.factory.MailSessionObjectFactory";
    public static final String JMS_CONNECTION_FACTORY_FACTORY = "com.sun.enterprise.naming.factory.JmsConnectionFactoryFactory";
    public static final String LOCAL_HOME_FACTORY = "com.sun.enterprise.naming.factory.LocalHomeFactory";
    public static final String JAVA_COMP_STRING = "java:comp/env/";
    private static final String CONTEXT_SEPARATOR = "/";
    private static final String ID_SEPARATOR = "_";
    private static final int UNKNOWN_COMPONENT = 0;
    private static final int EJB_COMPONENT = 1;
    private static final int WEB_COMPONENT = 2;
    private static final int APP_CLIENT_COMPONENT = 3;
    private static final boolean debug = false;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$naming$NamingManagerImpl == null ? (class$com$sun$enterprise$naming$NamingManagerImpl = NamingManagerImpl.class$("com.sun.enterprise.naming.NamingManagerImpl")) : class$com$sun$enterprise$naming$NamingManagerImpl);
    private SerialContextProvider serialContext;
    private InitialContext initialContext;
    private InitialContext cosContext;
    private InvocationManager im = null;
    private Switch theSwitch = null;
    private NameParser nameParser = new SerialNameParser();
    private Hashtable namespaces;
    public static final String EIS_STRING = "/eis/";
    static /* synthetic */ Class class$com$sun$enterprise$naming$NamingManagerImpl;
    static /* synthetic */ Class class$com$sun$enterprise$naming$SerialContextProvider;

    public NamingManagerImpl() throws NamingException {
        this(new InitialContext());
    }

    public NamingManagerImpl(InitialContext initialContext) throws NamingException {
        this.initialContext = initialContext;
        this.namespaces = new Hashtable();
        this.theSwitch = Switch.getSwitch();
        this.im = this.theSwitch.getInvocationManager();
        Hashtable<String, java.lang.Object> hashtable = new Hashtable<String, java.lang.Object>();
        hashtable.put("java.naming.factory.initial", "com.sun.jndi.cosnaming.CNCtxFactory");
        ORB oRB = ORBManager.getORB();
        hashtable.put("java.naming.corba.orb", oRB);
        this.cosContext = new InitialContext(hashtable);
        try {
            NamingContext namingContext = NamingContextHelper.narrow(oRB.resolve_initial_references("NameService"));
            NameComponent[] nameComponentArray = new NameComponent[]{new NameComponent("SerialContextProvider", "")};
            this.serialContext = (SerialContextProvider)PortableRemoteObject.narrow((java.lang.Object)namingContext.resolve(nameComponentArray), (Class)(class$com$sun$enterprise$naming$SerialContextProvider == null ? (class$com$sun$enterprise$naming$SerialContextProvider = NamingManagerImpl.class$("com.sun.enterprise.naming.SerialContextProvider")) : class$com$sun$enterprise$naming$SerialContextProvider));
        }
        catch (Exception exception) {
            throw new NamingException("Serial Context failure");
        }
    }

    public Context getInitialContext() {
        return this.initialContext;
    }

    public NameParser getNameParser() {
        return this.nameParser;
    }

    public void publishObject(String string, java.lang.Object object, boolean bl) throws NamingException {
        CompositeName compositeName = new CompositeName(string);
        this.publishObject(compositeName, object, bl);
    }

    public void publishObject(Name name, java.lang.Object object, boolean bl) throws NamingException {
        java.lang.Object object2 = object;
        if (this.isCOSNamingObj(object)) {
            this.createSubContexts(name, this.cosContext);
            if (bl) {
                this.cosContext.rebind(name, object);
            } else {
                this.cosContext.bind(name, object);
            }
            object2 = new Reference("reference", new StringRefAddr("url", name.toString()), IIOPOBJECT_FACTORY, null);
        }
        if (bl) {
            this.initialContext.rebind(name, object2);
        } else {
            this.initialContext.bind(name, object2);
        }
    }

    public void unpublishObject(String string) throws NamingException {
        java.lang.Object object = this.initialContext.lookup(string);
        if (this.isCOSNamingObj(object)) {
            this.cosContext.unbind(string);
        }
        this.initialContext.unbind(string);
    }

    public void unpublishObject(Name name) throws NamingException {
        this.unpublishObject(name.toString());
    }

    private void createSubContexts(Name name, Context context) throws NamingException {
        int n = name.size() - 1;
        Context context2 = context;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                Context context3;
                String string = name.get(n2);
                try {
                    java.lang.Object object = context2.lookup(string);
                    if (object == null) {
                        context2 = context3 = context2.createSubcontext(string);
                        break block5;
                    }
                    if (object instanceof Context) {
                        context2 = (Context)object;
                        break block5;
                    }
                    throw new NameAlreadyBoundException(string);
                }
                catch (NameNotFoundException nameNotFoundException) {
                    context2 = context3 = context2.createSubcontext(string);
                }
            }
            ++n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized String bindObjects(JndiNameEnvironment jndiNameEnvironment) throws NamingException {
        java.lang.Object object;
        java.lang.Object object2;
        java.lang.Object object3;
        java.lang.Object object4;
        java.lang.Object object5;
        java.lang.Object object6;
        String string = this.getMangledIdName(jndiNameEnvironment);
        HashMap<java.lang.Object, java.lang.Object> hashMap = new HashMap<java.lang.Object, java.lang.Object>();
        this.namespaces.put(string, hashMap);
        hashMap.put("java:", new javaURLContext("java:", null, this));
        hashMap.put("java:comp", new javaURLContext("java:comp", null, this));
        hashMap.put("java:comp/env", new javaURLContext("java:comp/env", null, this));
        Iterator iterator = jndiNameEnvironment.getEnvironmentProperties().iterator();
        while (iterator.hasNext()) {
            object6 = (EnvironmentProperty)iterator.next();
            object5 = this.descriptorToLogicalJndiName((Descriptor)object6);
            object4 = ((EnvironmentProperty)object6).getValueObject();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, localStrings.getLocalString("naming.bind", "Binding name:{0}", new java.lang.Object[]{object5}));
            }
            if (hashMap.put(object5, object4) != null) {
                _logger.log(Level.WARNING, localStrings.getLocalString("naming.alreadyexists", "Reference name [{0}] already exists in {1}", new java.lang.Object[]{((Descriptor)object6).getName(), this.getApplicationName(jndiNameEnvironment)}));
            }
            this.bindIntermediateContexts(hashMap, (String)object5);
        }
        object6 = jndiNameEnvironment.getJmsDestinationReferenceDescriptors().iterator();
        while (object6.hasNext()) {
            object5 = (JmsDestinationReferenceDescriptor)object6.next();
            object4 = this.descriptorToLogicalJndiName((Descriptor)object5);
            object3 = ((JmsDestinationReferenceDescriptor)object5).getJndiName();
            object2 = null;
            try {
                object2 = this.initialContext.lookup((String)object3);
            }
            catch (NamingException namingException) {
                _logger.log(Level.SEVERE, "enterprise_naming.notfound_jmsdestination", object3);
                _logger.log(Level.SEVERE, namingException.getClass().getName(), namingException);
                throw new InvalidNameException(localStrings.getLocalString("naming.notfound_jmsdestination", "JMS destination object not found: " + (String)object3, new java.lang.Object[]{object3}));
            }
            if (object2 instanceof Queue ? !((JmsDestinationReferenceDescriptor)object5).getRefType().equals("javax.jms.Queue") : object2 instanceof Topic && !((JmsDestinationReferenceDescriptor)object5).getRefType().equals("javax.jms.Topic")) {
                throw new InvalidNameException(localStrings.getLocalString("naming.destinationRefTypeMismatch", "", new java.lang.Object[]{((Descriptor)object5).getName(), ((JmsDestinationReferenceDescriptor)object5).getRefType()}));
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, localStrings.getLocalString("naming.bind", "Binding name:{0}", new java.lang.Object[]{object4}));
            }
            if (hashMap.put(object4, object2) != null) {
                _logger.log(Level.WARNING, localStrings.getLocalString("naming.alreadyexists", "Reference name [{0}] already exists in {1}", new java.lang.Object[]{((Descriptor)object5).getName(), this.getApplicationName(jndiNameEnvironment)}));
            }
            this.bindIntermediateContexts(hashMap, (String)object4);
        }
        object5 = jndiNameEnvironment.getEjbReferenceDescriptors().iterator();
        while (object5.hasNext()) {
            object4 = (EjbReferenceDescriptor)object5.next();
            object3 = this.descriptorToLogicalJndiName((Descriptor)object4);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, localStrings.getLocalString("naming.bind", "Binding name:{0}", new java.lang.Object[]{object3}));
            }
            object2 = ((EjbReferenceDescriptor)object4).getValue();
            object = null;
            object = ((EjbReferenceDescriptor)object4).isLocal() ? new J2EEEnvWrapper(object2, 4) : new J2EEEnvWrapper(object2, 3);
            if (hashMap.put(object3, object) != null) {
                _logger.log(Level.WARNING, localStrings.getLocalString("naming.alreadyexists", "Reference name [{0}] already exists in {1}", new java.lang.Object[]{((Descriptor)object4).getName(), this.getApplicationName(jndiNameEnvironment)}));
            }
            this.bindIntermediateContexts(hashMap, (String)object3);
        }
        object4 = jndiNameEnvironment.getResourceReferenceDescriptors().iterator();
        while (object4.hasNext()) {
            java.lang.Object object7;
            java.lang.Object object8;
            String string2;
            object3 = (ResourceReferenceDescriptor)object4.next();
            ((ResourceReferenceDescriptor)object3).checkType();
            object2 = ((Descriptor)object3).getName();
            object = this.descriptorToLogicalJndiName((Descriptor)object3);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, localStrings.getLocalString("naming.bind", "Binding name:{0}", new java.lang.Object[]{object}));
            }
            if ((string2 = ((EnvironmentProperty)object3).getValue()) == null || string2.equals("")) {
                throw new InvalidNameException("Real JNDI name cannot be empty for " + (String)object2);
            }
            java.lang.Object object9 = null;
            if (((ResourceReferenceDescriptor)object3).isMailResource()) {
                object9 = new J2EEEnvWrapper(string2, 2);
            } else if (((ResourceReferenceDescriptor)object3).isURLResource()) {
                object8 = ((ResourceReferenceDescriptor)object3).getJndiName();
                try {
                    object9 = new URL((String)object8);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new InvalidNameException(localStrings.getLocalString("naming.malformedURL", "Malformed URL:'{0}'", new java.lang.Object[]{object8}));
                }
                object9 = new J2EEEnvWrapper(object9, 1);
            } else if (((ResourceReferenceDescriptor)object3).isJMSConnectionFactory()) {
                java.lang.Object object10;
                int n = this.getComponentType(jndiNameEnvironment);
                object7 = null;
                switch (n) {
                    case 1: {
                        object7 = JmsWrapperFactory.getFactoryForEjb();
                        break;
                    }
                    case 2: {
                        object7 = JmsWrapperFactory.getFactoryForWeb();
                        break;
                    }
                    case 3: {
                        object7 = JmsWrapperFactory.getFactoryForAppClient();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid component type = " + n);
                    }
                }
                ConnectionFactory connectionFactory = null;
                try {
                    object10 = this.initialContext.lookup(string2);
                    if (object10 instanceof ConnectionFactoryWrapperStandalone) {
                        ConnectionFactoryWrapperStandalone connectionFactoryWrapperStandalone = (ConnectionFactoryWrapperStandalone)object10;
                        connectionFactory = connectionFactoryWrapperStandalone.getDelegate();
                    } else {
                        if (!(object10 instanceof ConnectionFactory)) throw new NamingException(localStrings.getLocalString("naming.unexpected_objtype", "Unexpected object type " + object10.getClass().getName() + " for " + string2, new java.lang.Object[]{object10.getClass().getName(), string2}));
                        connectionFactory = (ConnectionFactory)object10;
                        this.initialContext.rebind(IASJmsUtil.getXAConnectionFactoryName(string2), IASJmsUtil.wrapJMSConnectionFactoryObject(object10));
                    }
                }
                catch (NameNotFoundException nameNotFoundException) {
                    _logger.log(Level.SEVERE, "enterprise_naming.notfound_jmsconnfactory", string2);
                    _logger.log(Level.SEVERE, nameNotFoundException.getClass().getName(), nameNotFoundException);
                    throw new InvalidNameException(localStrings.getLocalString("naming.notfound_jmsconnfactory", "JMS connection factory resource not found: " + string2, new java.lang.Object[]{string2}));
                }
                catch (Exception exception) {
                    _logger.log(Level.SEVERE, exception.getClass().getName(), exception);
                    throw new NamingException(exception.getMessage());
                }
                object10 = IASJmsUtil.getXAConnectionFactoryName(string2);
                if (connectionFactory instanceof QueueConnectionFactory) {
                    if (!((ResourceReferenceDescriptor)object3).getType().equals("javax.jms.QueueConnectionFactory")) throw new InvalidNameException(localStrings.getLocalString("naming.jmsConnectionFactoryRefTypeMismatch", "", new java.lang.Object[]{object2, ((ResourceReferenceDescriptor)object3).getType()}));
                    object9 = ((JmsWrapperFactory)object7).createQueueConnectionFactoryWrapper((String)object10, (ResourceReferenceDescriptor)object3);
                } else {
                    if (!((ResourceReferenceDescriptor)object3).getType().equals("javax.jms.TopicConnectionFactory")) throw new InvalidNameException(localStrings.getLocalString("naming.jmsConnectionFactoryRefTypeMismatch", "", new java.lang.Object[]{object2, ((ResourceReferenceDescriptor)object3).getType()}));
                    object9 = ((JmsWrapperFactory)object7).createTopicConnectionFactoryWrapper((String)object10, (ResourceReferenceDescriptor)object3);
                }
                object9 = new J2EEEnvWrapper(object9, 1);
            } else if (this.isConnector((String)object)) {
                object9 = new J2EEEnvWrapper(string2, 7);
            } else if (((ResourceReferenceDescriptor)object3).isJDBCResource()) {
                try {
                    object8 = this.initialContext.lookup(string2);
                    object9 = new J2EEEnvWrapper(object8, 8);
                }
                catch (NamingException namingException) {
                    object7 = localStrings.getLocalString("naming.unresolved.warning", "", new java.lang.Object[]{object, string2});
                    _logger.log(Level.FINE, (String)object7);
                }
                if (object9 == null) {
                    object9 = new J2EEEnvWrapper(string2, 5);
                }
            } else {
                try {
                    object8 = this.initialContext.lookup(string2);
                    object9 = new J2EEEnvWrapper(object8, 1);
                }
                catch (NamingException namingException) {
                    object7 = localStrings.getLocalString("naming.unresolved.warning", "", new java.lang.Object[]{object, string2});
                    _logger.log(Level.FINE, (String)object7);
                }
                if (object9 == null) {
                    object9 = new J2EEEnvWrapper(string2, 5);
                }
            }
            if (hashMap.put(object, object9) != null) {
                _logger.log(Level.WARNING, localStrings.getLocalString("naming.alreadyexists", "Reference name [{0}] already exists in {1}", new java.lang.Object[]{((Descriptor)object3).getName(), this.getApplicationName(jndiNameEnvironment)}));
            }
            this.bindIntermediateContexts(hashMap, (String)object);
        }
        return string;
    }

    private void bindIntermediateContexts(HashMap hashMap, String string) throws NamingException {
        string = string.substring("java:comp/".length());
        StringTokenizer stringTokenizer = new StringTokenizer(string, CONTEXT_SEPARATOR, false);
        String string2 = "java:comp";
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (hashMap.get(string2 = string2 + CONTEXT_SEPARATOR + string3) != null) continue;
            hashMap.put(string2, new javaURLContext(string2, null, this));
        }
    }

    public void unbindObjects(JndiNameEnvironment jndiNameEnvironment) throws NamingException {
        String string = this.getMangledIdName(jndiNameEnvironment);
        this.namespaces.remove(string);
    }

    public java.lang.Object lookup(String string) throws NamingException {
        String string2 = this.getComponentId();
        HashMap hashMap = (HashMap)this.namespaces.get(string2);
        java.lang.Object object = hashMap.get(string);
        if (object == null) {
            throw new NameNotFoundException("No object bound to name " + string);
        }
        if (object instanceof J2EEEnvWrapper) {
            J2EEEnvWrapper j2EEEnvWrapper = (J2EEEnvWrapper)object;
            switch (j2EEEnvWrapper.type) {
                case 1: {
                    object = this.copyMutableObject(j2EEEnvWrapper.object);
                    break;
                }
                case 8: {
                    object = j2EEEnvWrapper.object;
                    break;
                }
                case 2: {
                    String string3 = (String)j2EEEnvWrapper.object;
                    MailConfiguration mailConfiguration = (MailConfiguration)this.initialContext.lookup(string3);
                    object = Session.getInstance((Properties)mailConfiguration.getMailProperties(), null);
                    break;
                }
                case 3: {
                    object = this.cosContext.lookup((String)j2EEEnvWrapper.object);
                    hashMap.put(string, object);
                    break;
                }
                case 4: {
                    object = this.theSwitch.getLocalHome((String)j2EEEnvWrapper.object);
                    if (object == null) {
                        throw new NamingException("EJBLocalHome lookup failed");
                    }
                    hashMap.put(string, object);
                    break;
                }
                case 5: {
                    object = this.initialContext.lookup((String)j2EEEnvWrapper.object);
                    j2EEEnvWrapper = new J2EEEnvWrapper(object, 1);
                    hashMap.put(string, j2EEEnvWrapper);
                    break;
                }
                case 6: {
                    object = j2EEEnvWrapper.object;
                    break;
                }
                case 7: {
                    object = this.initialContext.lookup((String)j2EEEnvWrapper.object);
                }
            }
        }
        return object;
    }

    private java.lang.Object copyMutableObject(java.lang.Object object) {
        if (object instanceof Serializable) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(object);
                objectOutputStream.flush();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                objectOutputStream.close();
                byteArrayOutputStream.close();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                ObjectInputStreamWithLoader objectInputStreamWithLoader = new ObjectInputStreamWithLoader(byteArrayInputStream, classLoader);
                return objectInputStreamWithLoader.readObject();
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "enterprise_naming.excep_in_copymutableobj", exception);
                throw new RuntimeException("Cant copy Serializable object:" + exception);
            }
        }
        return object;
    }

    public NamingEnumeration list(String string) throws NamingException {
        ArrayList arrayList = this.listNames(string);
        return new NamePairsEnum(this, arrayList.iterator());
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        ArrayList arrayList = this.listNames(string);
        return new BindingsEnum(this, arrayList.iterator());
    }

    private ArrayList listNames(String string) throws NamingException {
        String string2 = this.getComponentId();
        HashMap hashMap = (HashMap)this.namespaces.get(string2);
        java.lang.Object v = hashMap.get(string);
        if (v == null) {
            throw new NameNotFoundException("No object bound to name " + string);
        }
        if (!(v instanceof javaURLContext)) {
            throw new NotContextException(string + " cannot be listed");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = hashMap.keySet().iterator();
        if (!string.endsWith(CONTEXT_SEPARATOR)) {
            string = string + CONTEXT_SEPARATOR;
        }
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!string3.startsWith(string) || string3.indexOf(47, string.length()) != -1) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    private String getComponentId() throws NamingException {
        String string = null;
        ComponentInvocation componentInvocation = this.im.getCurrentInvocation();
        if (componentInvocation == null) {
            throw new NamingException("invocation exception ");
        }
        try {
            java.lang.Object object = componentInvocation.getContainerContext();
            if (object == null) {
                throw new NamingException("No container context");
            }
            if (object instanceof Container) {
                return ((Container)object).getComponentId();
            }
            JndiNameEnvironment jndiNameEnvironment = (JndiNameEnvironment)this.theSwitch.getDescriptorFor(object);
            string = this.getMangledIdName(jndiNameEnvironment);
        }
        catch (InvocationException invocationException) {
            throw new NamingException("invocation exception " + invocationException);
        }
        return string;
    }

    private String descriptorToLogicalJndiName(Descriptor descriptor) {
        return JAVA_COMP_STRING + descriptor.getName();
    }

    private int getComponentType(JndiNameEnvironment jndiNameEnvironment) {
        int n = 0;
        if (jndiNameEnvironment instanceof EjbDescriptor) {
            n = 1;
        } else if (jndiNameEnvironment instanceof WebBundleDescriptor) {
            n = 2;
        } else if (jndiNameEnvironment instanceof ApplicationClientDescriptor) {
            n = 3;
        } else {
            throw new IllegalArgumentException("Unknown component type");
        }
        return n;
    }

    private String getMangledIdName(JndiNameEnvironment jndiNameEnvironment) {
        String string = null;
        int n = this.getComponentType(jndiNameEnvironment);
        switch (n) {
            case 1: {
                EjbDescriptor ejbDescriptor = (EjbDescriptor)jndiNameEnvironment;
                String string2 = ejbDescriptor.getJndiName().replace('/', '.');
                EjbBundleDescriptor ejbBundleDescriptor = ejbDescriptor.getEjbBundleDescriptor();
                Archivist archivist = ejbBundleDescriptor.getArchivist();
                string = ejbDescriptor.getApplication().getName() + ID_SEPARATOR + archivist.getArchiveUri() + ID_SEPARATOR + ejbDescriptor.getName() + ID_SEPARATOR + string2;
                break;
            }
            case 2: {
                WebBundleDescriptor webBundleDescriptor = (WebBundleDescriptor)jndiNameEnvironment;
                string = webBundleDescriptor.getApplication().getName() + ID_SEPARATOR + webBundleDescriptor.getContextRoot();
                break;
            }
            case 3: {
                ApplicationClientDescriptor applicationClientDescriptor = (ApplicationClientDescriptor)jndiNameEnvironment;
                string = "client_" + applicationClientDescriptor.getName() + ID_SEPARATOR + applicationClientDescriptor.getMainClassName();
            }
        }
        return string;
    }

    private boolean isCOSNamingObj(java.lang.Object object) {
        return object instanceof Remote || object instanceof Object;
    }

    private String getApplicationName(JndiNameEnvironment jndiNameEnvironment) {
        String string = "";
        int n = this.getComponentType(jndiNameEnvironment);
        String string2 = "";
        switch (n) {
            case 1: {
                EjbDescriptor ejbDescriptor = (EjbDescriptor)jndiNameEnvironment;
                EjbBundleDescriptor ejbBundleDescriptor = ejbDescriptor.getEjbBundleDescriptor();
                string = "ejb [" + ejbDescriptor.getApplication().getRegistrationName();
                string2 = ejbDescriptor.getName();
                if (string2 == null || string2.equals("")) {
                    string = string + "]";
                    break;
                }
                string = string + ":" + ejbDescriptor.getName() + "]";
                break;
            }
            case 2: {
                WebBundleDescriptor webBundleDescriptor = (WebBundleDescriptor)jndiNameEnvironment;
                string = "web module [" + webBundleDescriptor.getApplication().getRegistrationName();
                string2 = webBundleDescriptor.getContextRoot();
                if (string2 == null || string2.equals("")) {
                    string = string + "]";
                    break;
                }
                string = string + ":" + webBundleDescriptor.getContextRoot() + "]";
                break;
            }
            case 3: {
                ApplicationClientDescriptor applicationClientDescriptor = (ApplicationClientDescriptor)jndiNameEnvironment;
                string = "client [" + applicationClientDescriptor.getName() + ":" + applicationClientDescriptor.getMainClassName() + "]";
            }
        }
        return string;
    }

    private boolean isConnector(String string) {
        return string.indexOf(EIS_STRING) != -1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

