/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop.security;

import com.sun.corba.ee.internal.core.IOR;
import com.sun.enterprise.iiop.POAEJBORB;
import com.sun.enterprise.iiop.security.InvalidIdentityTokenException;
import com.sun.enterprise.iiop.security.InvalidMechanismException;
import com.sun.enterprise.iiop.security.SecurityContext;
import com.sun.enterprise.iiop.security.SecurityMechanismException;
import com.sun.enterprise.iiop.security.SecurityMechanismSelector;
import com.sun.enterprise.iiop.security.SecurityService;
import com.sun.enterprise.iiop.security.ServerConnectionContext;
import com.sun.enterprise.security.auth.LoginContextDriver;
import com.sun.enterprise.util.ORBManager;
import com.sun.logging.LogDomains;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import org.omg.CORBA.Object;

public class SecurityServiceImpl
implements SecurityService {
    private static Logger _logger = null;
    private static final boolean debug = false;
    private String IS_A = "_is_a";

    public SecurityContext getSecurityContext(Object object) throws InvalidMechanismException, InvalidIdentityTokenException {
        SecurityContext securityContext = null;
        POAEJBORB pOAEJBORB = (POAEJBORB)ORBManager.getORB();
        IOR iOR = pOAEJBORB.getIOR(object);
        if (iOR.isLocal()) {
            return null;
        }
        try {
            SecurityMechanismSelector securityMechanismSelector = new SecurityMechanismSelector();
            securityContext = securityMechanismSelector.selectSecurityContext(iOR);
        }
        catch (InvalidMechanismException invalidMechanismException) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "iiop.invalidmechanism_exception", invalidMechanismException.toString());
            }
            throw new InvalidMechanismException(invalidMechanismException.getMessage());
        }
        catch (InvalidIdentityTokenException invalidIdentityTokenException) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "iiop.invalididtoken_exception", invalidIdentityTokenException.toString());
            }
            throw new InvalidIdentityTokenException(invalidIdentityTokenException.getMessage());
        }
        catch (SecurityMechanismException securityMechanismException) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "iiop.secmechanism_exception", securityMechanismException.toString());
            }
            throw new RuntimeException(securityMechanismException.getMessage());
        }
        return securityContext;
    }

    public void receivedReply(int n, Object object) {
        if (n == 1) {
            _logger.log(Level.FINE, "Failed status");
            throw new RuntimeException("Target did not accept security context");
        }
        if (n == 2) {
            // empty if block
        }
    }

    public int setSecurityContext(SecurityContext securityContext, byte[] byArray, String string) {
        SecurityContext securityContext2 = null;
        Class clazz = null;
        try {
            Subject subject = null;
            SecurityMechanismSelector securityMechanismSelector = new SecurityMechanismSelector();
            securityContext2 = securityMechanismSelector.evaluateTrust(securityContext, byArray);
            if (securityContext2 == null) {
                return 0;
            }
            clazz = securityContext2.authcls != null ? securityContext2.authcls : securityContext2.identcls;
            subject = securityContext2.subject;
            this.authenticate(subject, clazz);
        }
        catch (Exception exception) {
            if (!string.equals(this.IS_A) && _logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "iiop.authenticate_exception", exception.toString());
            }
            return 1;
        }
        return 0;
    }

    public void sendingReply(SecurityContext securityContext) {
    }

    public void unsetSecurityContext() {
        boolean bl = true;
        ServerConnectionContext serverConnectionContext = SecurityMechanismSelector.getServerConnectionContext();
        if (serverConnectionContext != null && serverConnectionContext.getSocket() != null) {
            bl = false;
        }
        if (!bl) {
            com.sun.enterprise.security.SecurityContext.setCurrent(null);
        }
    }

    private void authenticate(Subject subject, Class clazz) throws SecurityMechanismException {
        try {
            final Subject subject2 = subject;
            final Class clazz2 = clazz;
            AccessController.doPrivileged(new PrivilegedAction(){

                public java.lang.Object run() {
                    LoginContextDriver.login(subject2, clazz2);
                    return null;
                }
            });
        }
        catch (Exception exception) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "iiop.login_exception", exception.toString());
            }
            throw new SecurityMechanismException("Cannot login user:" + exception.getMessage());
        }
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.resource.corba");
    }
}

