/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop.security;

import com.sun.corba.ee.org.omg.CSIIOP.CompoundSecMech;
import com.sun.corba.ee.org.omg.GSSUP.InitialContextToken;
import com.sun.corba.ee.org.omg.GSSUP.InitialContextTokenHelper;
import com.sun.enterprise.iiop.POAEJBORB;
import com.sun.enterprise.iiop.security.ConnectionContext;
import com.sun.enterprise.iiop.security.GSSUtils;
import com.sun.enterprise.iiop.security.Logger;
import com.sun.enterprise.iiop.security.SecurityMechanismException;
import com.sun.enterprise.iiop.security.SecurityMechanismSelector;
import com.sun.enterprise.security.auth.login.PasswordCredential;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.IOP.Codec;

public class GSSUPToken {
    private static java.util.logging.Logger _logger = null;
    public static final String DELIMITER = "@";
    public static final char ESCAPE_CHAR = '\\';
    private static boolean debug;
    private byte[] cdr_encoded_token = new byte[0];
    PasswordCredential pwdcred = null;

    public GSSUPToken(ORB oRB, Codec codec, PasswordCredential passwordCredential) {
        byte[] byArray = new byte[]{};
        byte[] byArray2 = new byte[]{};
        POAEJBORB pOAEJBORB = (POAEJBORB)oRB;
        _logger.log(Level.FINE, "Going to construct a GSSUPToken:");
        _logger.log(Level.FINE, passwordCredential.toString());
        try {
            byArray = passwordCredential.getUser().getBytes("UTF8");
            byArray2 = passwordCredential.getPassword().getBytes("UTF8");
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "iiop.password_exception", exception);
        }
        SecurityMechanismSelector securityMechanismSelector = new SecurityMechanismSelector();
        ConnectionContext connectionContext = securityMechanismSelector.getClientConnectionContext();
        CompoundSecMech compoundSecMech = connectionContext.getMechanism();
        byte[] byArray3 = compoundSecMech.as_context_mech.target_name;
        Logger.fine("Username (UTF8) " + GSSUtils.dumpHex(byArray));
        Logger.fine("Password (UTF8) " + GSSUtils.dumpHex(byArray2));
        Logger.fine("Targetname      " + GSSUtils.dumpHex(byArray3));
        InitialContextToken initialContextToken = new InitialContextToken(byArray, byArray2, byArray3);
        Any any = oRB.create_any();
        InitialContextTokenHelper.insert(any, initialContextToken);
        try {
            this.cdr_encoded_token = codec.encode_value(any);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "iiop.encode_exception", exception);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Mech specific token length (CDR encoded) = " + this.cdr_encoded_token.length);
        }
    }

    public GSSUPToken(ORB oRB, Codec codec, byte[] byArray) throws SecurityMechanismException {
        String string;
        byte[] byArray2 = new byte[]{};
        byte[] byArray3 = new byte[]{};
        byte[] byArray4 = new byte[]{};
        String string2 = "";
        String string3 = "";
        String string4 = "";
        byte[] byArray5 = new byte[]{};
        _logger.log(Level.FINE, "Going to construct a GSSUPToken:");
        _logger.log(Level.FINE, "Getting CDR encoded GSSUP mechanism token from client authentication token");
        byArray5 = GSSUtils.getMechToken(GSSUtils.GSSUP_MECH_OID, byArray);
        _logger.log(Level.FINE, "CDR encoded mech specific token length = " + byArray5.length);
        Any any = oRB.create_any();
        try {
            any = codec.decode_value(byArray5, InitialContextTokenHelper.type());
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "iiop.decode_exception", exception);
        }
        InitialContextToken initialContextToken = InitialContextTokenHelper.extract(any);
        byArray3 = initialContextToken.password;
        byArray2 = initialContextToken.username;
        byArray4 = initialContextToken.target_name;
        Logger.fine("Username (UTF8) " + GSSUtils.dumpHex(byArray2));
        Logger.fine("Password (UTF8) " + GSSUtils.dumpHex(byArray3));
        Logger.fine("Targetname      " + GSSUtils.dumpHex(byArray4));
        try {
            string2 = new String(byArray2, "UTF8");
            string3 = new String(byArray3, "UTF8");
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "iiop.user_password_exception", exception);
        }
        int n = string2.indexOf(DELIMITER);
        int n2 = string2.indexOf(92);
        if (n == -1) {
            string = string2;
        } else {
            if (n == 0) {
                throw new SecurityMechanismException("No name_value in username");
            }
            if (n != -1 && n2 != -1) {
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                while ((n5 = string2.indexOf(DELIMITER, n5)) != -1) {
                    if (string2.charAt(n5 - 1) != '\\') {
                        n4 = n5;
                        break;
                    }
                    ++n5;
                }
                if (n4 > 0) {
                    string = string2.substring(n3, n4);
                    string4 = string2.substring(n4 + 1);
                    if (!string4.equals("default")) {
                        throw new SecurityMechanismException("Unknown realm");
                    }
                } else {
                    StringBuffer stringBuffer = new StringBuffer("");
                    int n6 = 0;
                    int n7 = 0;
                    while ((n7 = string2.indexOf(92, n6)) != -1) {
                        stringBuffer.append(string2.substring(n6, n7));
                        n6 = n7 + 1;
                    }
                    stringBuffer.append(string2.substring(n6));
                    string = string2 = stringBuffer.toString();
                    string4 = "default";
                }
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, DELIMITER);
                string = stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreTokens() && !(string4 = stringTokenizer.nextToken()).equals("default")) {
                    throw new SecurityMechanismException("Unknown realm");
                }
            }
        }
        this.pwdcred = new PasswordCredential(string, string3, "default", byArray4);
        _logger.log(Level.FINE, this.pwdcred.toString());
    }

    public byte[] getGSSToken() throws IOException {
        Logger.finer("GSSUP mech token : " + GSSUtils.dumpHex(this.cdr_encoded_token));
        byte[] byArray = GSSUtils.createMechIndToken(GSSUtils.GSSUP_MECH_OID, this.cdr_encoded_token);
        Logger.fine("GSSUP token length : " + byArray.length);
        Logger.finer("GSSUP token: " + GSSUtils.dumpHex(byArray));
        return byArray;
    }

    public PasswordCredential getPwdcred() {
        return this.pwdcred;
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.resource.corba");
        debug = false;
    }
}

