/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.distributedtx;

import com.sun.enterprise.Switch;
import com.sun.enterprise.distributedtx.J2EETransaction;
import com.sun.enterprise.distributedtx.J2EETransactionManagerImpl;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.jts.CosTransactions.RWLock;
import com.sun.logging.LogDomains;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.resource.spi.ManagedConnection;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;

public final class J2EETransactionManagerOpt
extends J2EETransactionManagerImpl {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.jta");
    private ThreadLocal transactions = new ThreadLocal();
    private ThreadLocal localCallCounter = new ThreadLocal();
    private Hashtable globalTransactions = new Hashtable();
    private static RWLock freezeLock = new RWLock();

    public void clearThreadTx() {
        this.transactions.set(null);
    }

    public boolean enlistResource(Transaction transaction, ResourceHandle resourceHandle) throws RollbackException, IllegalStateException, SystemException {
        if (!resourceHandle.isTransactional()) {
            return true;
        }
        if (!(transaction instanceof J2EETransaction)) {
            return super.enlistResource(transaction, resourceHandle);
        }
        J2EETransaction j2EETransaction = (J2EETransaction)transaction;
        if (j2EETransaction.getNonXAResource() != null) {
            boolean bl = false;
            try {
                bl = resourceHandle.getXAResource().isSameRM(j2EETransaction.getNonXAResource().getXAResource());
            }
            catch (Exception exception) {
                throw new SystemException("isSameRM exception: " + exception);
            }
            if (!bl) {
                throw new IllegalStateException("Local transaction already has 1 non-XA Resource: cannot add more resources");
            }
        }
        if (resourceHandle.supportsXA()) {
            if (j2EETransaction.isLocalTx()) {
                this.startJTSTx(j2EETransaction);
            }
            return super.enlistResource(j2EETransaction, resourceHandle);
        }
        if (j2EETransaction.isLocalTx()) {
            j2EETransaction.setNonXAResource(resourceHandle);
            try {
                resourceHandle.getXAResource().start(j2EETransaction.getLocalXid(), 0);
            }
            catch (XAException xAException) {
                throw new RuntimeException("Got exception during XAResource.start:", xAException);
            }
            if (resourceHandle.getResource() instanceof ManagedConnection) {
                Switch.getSwitch().getResourcePoolManager().resourceEnlisted(transaction, resourceHandle);
            } else {
                this.poolmgr.resourceEnlisted(j2EETransaction, resourceHandle);
            }
            return true;
        }
        return super.enlistResource(j2EETransaction, resourceHandle);
    }

    void startJTSTx(J2EETransaction j2EETransaction) throws RollbackException, IllegalStateException, SystemException {
        try {
            super.begin();
            if (j2EETransaction != null && this.monitoringEnabled && this.activeTransactions.remove(j2EETransaction)) {
                --this.m_transInFlight;
            }
        }
        catch (NotSupportedException notSupportedException) {
            throw new RuntimeException("Internal Error: could not start JTS transaction lazily");
        }
        Transaction transaction = this.tm.getTransaction();
        j2EETransaction.setJTSTx(transaction);
        transaction.registerSynchronization((Synchronization)new JTSSynchronization(transaction, this));
        this.globalTransactions.put(transaction, j2EETransaction);
    }

    public boolean delistResource(Transaction transaction, ResourceHandle resourceHandle, int n) throws IllegalStateException, SystemException {
        if (!resourceHandle.isTransactional()) {
            return true;
        }
        if (!(transaction instanceof J2EETransaction)) {
            return super.delistResource(transaction, resourceHandle, n);
        }
        J2EETransaction j2EETransaction = (J2EETransaction)transaction;
        if (j2EETransaction.isLocalTx()) {
            try {
                resourceHandle.getXAResource().end(j2EETransaction.getLocalXid(), n);
            }
            catch (XAException xAException) {
                throw new RuntimeException("Got exception during XAResource.end:" + xAException);
            }
            return true;
        }
        return super.delistResource(j2EETransaction, resourceHandle, n);
    }

    public void checkTransactionImport() {
        int[] nArray = (int[])this.localCallCounter.get();
        if (nArray != null && nArray[0] > 0) {
            nArray[0] = nArray[0] - 1;
            return;
        }
        this.clearThreadTx();
    }

    public void checkTransactionExport(boolean bl) {
        if (bl) {
            int[] nArray = (int[])this.localCallCounter.get();
            if (nArray == null) {
                nArray = new int[1];
                this.localCallCounter.set(nArray);
            }
            nArray[0] = nArray[0] + 1;
            return;
        }
        J2EETransaction j2EETransaction = (J2EETransaction)this.transactions.get();
        if (j2EETransaction == null) {
            return;
        }
        if (!j2EETransaction.isLocalTx()) {
            return;
        }
        if (j2EETransaction.getNonXAResource() != null) {
            throw new RuntimeException("Cannot export transaction having non-XA resource: 2-phase commit not possible.");
        }
        try {
            this.startJTSTx(j2EETransaction);
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to start JTS transaction");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin() throws NotSupportedException, SystemException {
        if (this.transactions.get() != null) {
            throw new NotSupportedException("Nested transaction not supported");
        }
        if (this.tm.getStatus() != 6) {
            throw new NotSupportedException("Nested transaction not supported");
        }
        if (this.transactionTimeout > 0) {
            super.begin();
        } else {
            boolean bl = false;
            if (this.monitoringEnabled) {
                freezeLock.acquireReadLock();
                bl = true;
            }
            try {
                J2EETransaction j2EETransaction = new J2EETransaction(this);
                this.transactions.set(j2EETransaction);
                if (this.monitoringEnabled) {
                    this.activeTransactions.addElement(j2EETransaction);
                    ++this.m_transInFlight;
                }
                Object var4_3 = null;
                if (bl) {
                    freezeLock.releaseReadLock();
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (bl) {
                    freezeLock.releaseReadLock();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        try {
            block17: {
                J2EETransaction j2EETransaction = (J2EETransaction)this.transactions.get();
                if (j2EETransaction != null && j2EETransaction.isLocalTx()) {
                    J2EETransaction j2EETransaction2 = null;
                    boolean bl = false;
                    if (this.monitoringEnabled) {
                        j2EETransaction2 = j2EETransaction;
                    }
                    try {
                        block16: {
                            try {
                                if (this.monitoringEnabled) {
                                    freezeLock.acquireReadLock();
                                    bl = true;
                                }
                                j2EETransaction.commit();
                                if (!this.monitoringEnabled) break block16;
                                this.monitorTxCompleted(j2EETransaction2, true);
                            }
                            catch (RollbackException rollbackException) {
                                if (this.monitoringEnabled) {
                                    this.monitorTxCompleted(j2EETransaction2, false);
                                }
                                throw rollbackException;
                            }
                            catch (HeuristicRollbackException heuristicRollbackException) {
                                if (this.monitoringEnabled) {
                                    this.monitorTxCompleted(j2EETransaction2, false);
                                }
                                throw heuristicRollbackException;
                            }
                            catch (HeuristicMixedException heuristicMixedException) {
                                if (this.monitoringEnabled) {
                                    this.monitorTxCompleted(j2EETransaction2, true);
                                }
                                throw heuristicMixedException;
                            }
                        }
                        Object var8_4 = null;
                        if (bl) {
                            freezeLock.releaseReadLock();
                        }
                        break block17;
                    }
                    catch (Throwable throwable) {
                        Object var8_5 = null;
                        if (bl) {
                            freezeLock.releaseReadLock();
                        }
                        throw throwable;
                    }
                }
                super.commit();
            }
            Object var10_10 = null;
            this.transactions.set(null);
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.transactions.set(null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        boolean bl = false;
        try {
            J2EETransaction j2EETransaction = (J2EETransaction)this.transactions.get();
            if (j2EETransaction != null && j2EETransaction.isLocalTx()) {
                J2EETransaction j2EETransaction2 = null;
                if (this.monitoringEnabled) {
                    j2EETransaction2 = j2EETransaction;
                }
                if (this.monitoringEnabled) {
                    freezeLock.acquireReadLock();
                    bl = true;
                }
                j2EETransaction.rollback();
                if (this.monitoringEnabled) {
                    this.monitorTxCompleted(j2EETransaction2, false);
                }
            } else {
                super.rollback();
            }
            Object var5_4 = null;
            this.transactions.set(null);
            if (bl) {
                freezeLock.releaseReadLock();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.transactions.set(null);
            if (bl) {
                freezeLock.releaseReadLock();
            }
            throw throwable;
        }
    }

    public int getStatus() throws SystemException {
        J2EETransaction j2EETransaction = (J2EETransaction)this.transactions.get();
        if (j2EETransaction != null && j2EETransaction.isLocalTx()) {
            return j2EETransaction.getStatus();
        }
        return this.tm.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        J2EETransaction j2EETransaction = (J2EETransaction)this.transactions.get();
        if (j2EETransaction != null) {
            return j2EETransaction;
        }
        Transaction transaction = this.tm.getTransaction();
        if (transaction == null) {
            return null;
        }
        j2EETransaction = (J2EETransaction)this.globalTransactions.get(transaction);
        if (j2EETransaction == null) {
            j2EETransaction = new J2EETransaction(this, transaction);
            try {
                transaction.registerSynchronization((Synchronization)new JTSSynchronization(transaction, this));
            }
            catch (Exception exception) {
                throw new SystemException(exception.toString());
            }
            this.globalTransactions.put(transaction, j2EETransaction);
        }
        this.transactions.set(j2EETransaction);
        return j2EETransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setRollbackOnly() throws IllegalStateException, SystemException {
        J2EETransaction j2EETransaction = (J2EETransaction)this.transactions.get();
        if (j2EETransaction != null && j2EETransaction.isLocalTx()) {
            boolean bl = false;
            if (this.monitoringEnabled) {
                freezeLock.acquireReadLock();
                bl = true;
            }
            try {
                j2EETransaction.setRollbackOnly();
                Object var4_3 = null;
                if (!bl) return;
                freezeLock.releaseReadLock();
                return;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (!bl) throw throwable;
                freezeLock.releaseReadLock();
                throw throwable;
            }
        } else {
            super.setRollbackOnly();
        }
    }

    public Transaction suspend() throws SystemException {
        J2EETransaction j2EETransaction = (J2EETransaction)this.transactions.get();
        if (j2EETransaction != null) {
            if (!j2EETransaction.isLocalTx()) {
                this.tm.suspend();
            }
            this.transactions.set(null);
            return j2EETransaction;
        }
        return this.tm.suspend();
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
        J2EETransaction j2EETransaction = (J2EETransaction)this.transactions.get();
        if (j2EETransaction != null) {
            throw new IllegalStateException("Transaction exists on current thread");
        }
        if (transaction instanceof J2EETransaction) {
            J2EETransaction j2EETransaction2 = (J2EETransaction)transaction;
            if (!j2EETransaction2.isLocalTx()) {
                this.tm.resume(j2EETransaction2.getJTSTx());
            }
            this.transactions.set(transaction);
        } else {
            this.tm.resume(transaction);
        }
    }

    public synchronized void freeze() {
        super.freeze();
        if (freezeLock.isWriteLocked()) {
            return;
        }
        freezeLock.acquireWriteLock();
    }

    public synchronized void unfreeze() {
        super.unfreeze();
        if (freezeLock.isWriteLocked()) {
            freezeLock.releaseWriteLock();
        }
    }

    private class JTSSynchronization
    implements Synchronization {
        private Transaction jtsTx;
        private J2EETransactionManagerOpt j2eeTM;

        JTSSynchronization(Transaction transaction, J2EETransactionManagerOpt j2EETransactionManagerOpt2) {
            this.jtsTx = transaction;
            this.j2eeTM = j2EETransactionManagerOpt2;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int n) {
            this.j2eeTM.globalTransactions.remove(this.jtsTx);
        }
    }
}

