/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.repository.MailResource;
import com.sun.enterprise.repository.ResourceProperty;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MailConfiguration
implements Serializable {
    private static String PROTOCOL_TYPE_IMAP = "imap";
    private static String PROTOCOL_TYPE_POP3 = "pop3";
    private static String PROTOCOL_TYPE_SMTP = "smtp";
    private static String PROP_NAME_PREFIX = "mail-";
    private static String PROP_NAME_SUFFIX_HOST = "-host";
    private static String PROP_NAME_SUFFIX_USER = "-user";
    private static char PROP_NAME_DELIM = (char)45;
    private static String DEF_VAL_STORE_PROTOCOL = PROTOCOL_TYPE_IMAP;
    private static String DEF_VAL_STORE_PROTOCOL_CLASS = "com.sun.mail.imap.IMAPStore";
    private static String DEF_VAL_TRANSPORT_PROTOCOL = PROTOCOL_TYPE_SMTP;
    private static String DEF_VAL_TRANSPORT_PROTOCOL_CLASS = "com.sun.mail.smtp.SMTPTransport";
    private static String DEF_VAL_HOST = "localhost";
    private static String DEF_VAL_USER = "user.name";
    private static String DEF_VAL_FROM = "username@host";
    private static boolean DEF_VAL_DEBUG = false;
    private static String MAIL_STORE_PROTOCOL = "mail.store.protocol";
    private static String MAIL_TRANSPORT_PROTOCOL = "mail.transport.protocol";
    private static String MAIL_HOST = "mail.host";
    private static String MAIL_USER = "mail.user";
    private static String MAIL_FROM = "mail.from";
    private static String MAIL_DEBUG = "mail.debug";
    private static String MAIL_PREFIX = "mail.";
    private static String MAIL_SUFFIX_CLASS = ".class";
    private static String MAIL_SUFFIX_HOST = ".host";
    private static String MAIL_SUFFIX_USER = ".user";
    private static char MAIL_DELIM = (char)46;
    private String description = "";
    private String jndiName = "";
    private boolean enabled = false;
    private String storeProtocol = DEF_VAL_STORE_PROTOCOL;
    private String storeProtocolClass = DEF_VAL_STORE_PROTOCOL_CLASS;
    private String transportProtocol = DEF_VAL_TRANSPORT_PROTOCOL;
    private String transportProtocolClass = DEF_VAL_TRANSPORT_PROTOCOL_CLASS;
    private String mailHost = DEF_VAL_HOST;
    private String username = DEF_VAL_USER;
    private String mailFrom = DEF_VAL_FROM;
    private boolean debug = DEF_VAL_DEBUG;
    private Properties mailProperties = new Properties();
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");

    public MailConfiguration(String string, String string2) {
        this.username = string;
        this.mailFrom = string2;
        this.mailHost = "";
        this.mailProperties.put(MAIL_FROM, this.getMailFrom());
        this.mailProperties.put(MAIL_USER, this.getUsername());
        this.mailProperties.put(MAIL_HOST, this.getMailHost());
    }

    public MailConfiguration(String string, String string2, String string3) {
        this.username = string;
        this.mailFrom = string2;
        this.mailHost = string3;
        this.mailProperties.put(MAIL_FROM, this.getMailFrom());
        this.mailProperties.put(MAIL_USER, this.getUsername());
        this.mailProperties.put(MAIL_HOST, this.getMailHost());
    }

    public MailConfiguration(MailResource mailResource) {
        try {
            this.loadMailResources(mailResource);
        }
        catch (Exception exception) {
            _logger.log(Level.INFO, "enterprise.deployment_mail_cfgexcp", exception);
        }
    }

    private void loadMailResources(MailResource mailResource) throws Exception {
        if (mailResource == null) {
            _logger.log(Level.FINE, "MailConfiguration: no MailResource object. mailResource=" + mailResource);
            return;
        }
        this.jndiName = mailResource.getName();
        this.description = mailResource.getDescription();
        this.enabled = mailResource.isEnabled();
        this.storeProtocol = mailResource.getStoreProtocol();
        this.storeProtocolClass = mailResource.getStoreProtocolClass();
        this.transportProtocol = mailResource.getTransportProtocol();
        this.transportProtocolClass = mailResource.getTransportProtocolClass();
        this.mailHost = mailResource.getMailHost();
        this.username = mailResource.getUsername();
        this.mailFrom = mailResource.getMailFrom();
        this.debug = mailResource.isDebug();
        String string = MAIL_PREFIX + this.storeProtocol + MAIL_SUFFIX_CLASS;
        String string2 = MAIL_PREFIX + this.transportProtocol + MAIL_SUFFIX_CLASS;
        this.mailProperties.put(MAIL_STORE_PROTOCOL, this.storeProtocol);
        this.mailProperties.put(MAIL_TRANSPORT_PROTOCOL, this.transportProtocol);
        this.mailProperties.put(string, this.storeProtocolClass);
        this.mailProperties.put(string2, this.transportProtocolClass);
        this.mailProperties.put(MAIL_FROM, this.mailFrom);
        this.mailProperties.put(MAIL_DEBUG, this.debug ? "true" : "false");
        Set set = mailResource.getProperties();
        ResourceProperty resourceProperty = null;
        String string3 = null;
        String string4 = null;
        String string5 = PROP_NAME_PREFIX + this.storeProtocol + PROP_NAME_SUFFIX_HOST;
        String string6 = PROP_NAME_PREFIX + this.storeProtocol + PROP_NAME_SUFFIX_USER;
        String string7 = MAIL_PREFIX + this.storeProtocol + MAIL_SUFFIX_HOST;
        String string8 = MAIL_PREFIX + this.storeProtocol + MAIL_SUFFIX_USER;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            resourceProperty = (ResourceProperty)iterator.next();
            string3 = resourceProperty.getName();
            string4 = (String)resourceProperty.getValue();
            if (!string3.startsWith(PROP_NAME_PREFIX)) continue;
            if (string3.equals(string5)) {
                this.mailHost = string4;
                this.mailProperties.put(string7, string4);
                continue;
            }
            if (string3.equals(string6)) {
                this.username = string4;
                this.mailProperties.put(string8, string4);
                continue;
            }
            string3 = string3.replace(PROP_NAME_DELIM, MAIL_DELIM);
            this.mailProperties.put(string3, string4);
        }
        this.mailProperties.put(MAIL_HOST, this.mailHost);
        this.mailProperties.put(MAIL_USER, this.username);
    }

    public String getUsername() {
        return this.username;
    }

    public String getMailFrom() {
        return this.mailFrom;
    }

    public String getMailHost() {
        return this.mailHost;
    }

    public String getMailStoreProtocol() {
        return this.storeProtocol;
    }

    public String getMailTransportProtocol() {
        return this.transportProtocol;
    }

    public String getMailStoreProtocolClass() {
        return this.storeProtocolClass;
    }

    public String getMailTransportProtocolClass() {
        return this.transportProtocolClass;
    }

    public boolean getMailDebug() {
        return this.debug;
    }

    public String getDescription() {
        return this.description;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public Properties getMailProperties() {
        return this.mailProperties;
    }

    public String toString() {
        String string = "MailConfiguration: [";
        string = string + "description=" + this.description;
        string = string + ", jndiName=" + this.jndiName;
        string = string + ", enabled=" + this.enabled;
        string = string + ", storeProtocol=" + this.storeProtocol;
        string = string + ", transportProtocol=" + this.transportProtocol;
        string = string + ", storeProtocolClass=" + this.storeProtocolClass;
        string = string + ", transportProtocolClass=" + this.transportProtocolClass;
        string = string + ", mailHost=" + this.mailHost;
        string = string + ", username=" + this.username;
        string = string + ", mailFrom=" + this.mailFrom;
        string = string + ", debug=" + this.debug;
        string = string + ", mailProperties: [";
        Enumeration<?> enumeration = this.mailProperties.propertyNames();
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = this.mailProperties.getProperty(string2);
            if (bl) {
                string = string + string2 + "=" + string3;
                bl = false;
                continue;
            }
            string = string + ", " + string2 + "=" + string3;
        }
        string = string + "]]";
        return string;
    }
}

