/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.persistence;

import com.sun.ejb.EJBUtils;
import com.sun.ejb.PMDeployer;
import com.sun.ejb.Partition;
import com.sun.ejb.PersistenceManager;
import com.sun.ejb.PersistenceUtils;
import com.sun.ejb.PersistentInstance;
import com.sun.ejb.PersistentState;
import com.sun.ejb.persistence.JDBCUtils;
import com.sun.ejb.persistence.PMDeployerImpl;
import com.sun.ejb.persistence.PartitionImpl;
import com.sun.ejb.persistence.RelationshipManager;
import com.sun.ejb.persistence.SQLEngine;
import com.sun.enterprise.deployment.CMRFieldInfo;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.JoinObjectDescriptor;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.PersistentFieldInfo;
import com.sun.enterprise.deployment.RelationRoleDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.resource.ResourcePrincipal;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import javax.ejb.EJBException;
import javax.ejb.NoSuchEntityException;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

public class PersistenceManagerImpl
implements PersistenceManager {
    private static final boolean debug = false;
    private Hashtable partitions = new Hashtable();
    private TransactionManager tm;
    protected RelationshipManager relationshipManager;
    private SQLEngine sqlEngine;
    private Partition noTxPartition;
    private long nextLong = 0L;
    private EjbBundleDescriptor ejbBundleDescriptor;

    public PersistenceManagerImpl(EjbBundleDescriptor ejbBundleDescriptor) {
        this.ejbBundleDescriptor = ejbBundleDescriptor;
        this.relationshipManager = new RelationshipManager(this);
        PMDeployer pMDeployer = PersistenceUtils.getPMDeployer(ejbBundleDescriptor);
        this.sqlEngine = new SQLEngine(this, (PMDeployerImpl)pMDeployer);
        this.noTxPartition = new PartitionImpl(this, this.relationshipManager, null);
    }

    public synchronized long getNextLong() {
        return this.nextLong++;
    }

    public SQLEngine getSQLEngine() {
        return this.sqlEngine;
    }

    public Partition getPartition(PersistentInstance persistentInstance) {
        try {
            Transaction transaction;
            if (this.tm == null) {
                this.tm = (TransactionManager)new InitialContext().lookup("java:pm/TransactionManager");
            }
            if ((transaction = this.tm.getTransaction()) != null) {
                PartitionImpl partitionImpl = (PartitionImpl)this.partitions.get(transaction);
                if (partitionImpl == null) {
                    partitionImpl = new PartitionImpl(this, this.relationshipManager, transaction);
                    this.partitions.put(transaction, partitionImpl);
                    transaction.registerSynchronization((Synchronization)partitionImpl);
                }
                return partitionImpl;
            }
            return this.noTxPartition;
        }
        catch (Exception exception) {
            EJBUtils.throwEJBException(exception);
            return null;
        }
    }

    void releasePartition(Partition partition) {
        this.partitions.remove(partition.getTransaction());
    }

    void resetFields(final PersistentState persistentState) {
        PersistenceDescriptor persistenceDescriptor = persistentState.__getPersistenceDescriptor();
        final PersistentFieldInfo[] persistentFieldInfoArray = persistenceDescriptor.getPersistentFieldInfo();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                int n = 0;
                while (n < persistentFieldInfoArray.length) {
                    block14: {
                        try {
                            Field field = persistentFieldInfoArray[n].field;
                            Class<?> clazz = field.getType();
                            if (clazz.isPrimitive()) {
                                switch (persistentFieldInfoArray[n].jdbcType) {
                                    case -7: {
                                        field.setBoolean(persistentState, false);
                                        break block14;
                                    }
                                    case -6: {
                                        field.setByte(persistentState, (byte)0);
                                        break block14;
                                    }
                                    case 5: {
                                        field.setShort(persistentState, (short)0);
                                        break block14;
                                    }
                                    case 1: {
                                        field.setChar(persistentState, '\u0000');
                                        break block14;
                                    }
                                    case 4: {
                                        field.setInt(persistentState, 0);
                                        break block14;
                                    }
                                    case -5: {
                                        field.setLong(persistentState, 0L);
                                        break block14;
                                    }
                                    case 7: {
                                        field.setFloat(persistentState, 0.0f);
                                        break block14;
                                    }
                                    case 8: {
                                        field.setDouble(persistentState, 0.0);
                                        break block14;
                                    }
                                    default: {
                                        throw new EJBException("ERROR initializing EJB field " + field);
                                    }
                                }
                            }
                            field.set(persistentState, null);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            EJBUtils.throwEJBException(illegalAccessException);
                        }
                    }
                    ++n;
                }
                return null;
            }
        });
    }

    void beforeCompletion(Transaction transaction, Collection collection) {
        block10: {
            try {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    PersistentState persistentState = (PersistentState)iterator.next();
                    int n = persistentState.__getStatus();
                    if (n == 1) continue;
                    Object object = this.getPrimaryKey(persistentState);
                    switch (n) {
                        case 2: {
                            this.createRow(persistentState, object);
                            break;
                        }
                        case 3: {
                            this.removeRow(persistentState, object);
                            break;
                        }
                        case 4: {
                            this.storeRow(persistentState, object);
                        }
                    }
                    persistentState.__setStatus(1);
                }
            }
            catch (EJBException eJBException) {
                try {
                    if (transaction == null) break block10;
                    transaction.setRollbackOnly();
                }
                catch (SystemException systemException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadRow(PersistentState persistentState, Object object) throws EJBException {
        Connection connection = null;
        Statement statement = null;
        try {
            PersistenceDescriptor persistenceDescriptor = persistentState.__getPersistenceDescriptor();
            String string = persistenceDescriptor.getSqlStatementFor("loadRow");
            PersistentFieldInfo[] persistentFieldInfoArray = persistenceDescriptor.getNonPkeyPersFieldInfo();
            PersistentFieldInfo[] persistentFieldInfoArray2 = persistenceDescriptor.getPkeyFieldInfo();
            Field[] fieldArray = persistenceDescriptor.getPkeyClassFields();
            connection = PersistenceManagerImpl.getConnection(persistenceDescriptor);
            statement = connection.prepareStatement(string);
            if (persistenceDescriptor.primaryKeyIsOneField()) {
                JDBCUtils.copyObjToDB((PreparedStatement)statement, 1, object, persistentFieldInfoArray2[0].jdbcType);
            } else {
                int n = 0;
                while (n < fieldArray.length) {
                    JDBCUtils.copyFieldToDB((PreparedStatement)statement, n + 1, fieldArray[n], object, persistentFieldInfoArray2[n].jdbcType);
                    ++n;
                }
            }
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                throw new NoSuchEntityException("ERROR in SQL SELECT: No database row for EJB");
            }
            int n = 0;
            while (n < persistentFieldInfoArray.length) {
                JDBCUtils.copyFieldFromDB(resultSet, n + 1, persistentFieldInfoArray[n].field, persistentState, persistentFieldInfoArray[n].jdbcType);
                ++n;
            }
            if (persistenceDescriptor.primaryKeyIsOneField()) {
                persistentFieldInfoArray2[0].field.set(persistentState, object);
            } else {
                int n2 = 0;
                while (n2 < persistentFieldInfoArray2.length) {
                    persistentFieldInfoArray2[n2].field.set(persistentState, fieldArray[n2].get(object));
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            EJBUtils.throwEJBException(exception);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    boolean primaryKeyExists(Object object, PersistenceDescriptor persistenceDescriptor) throws EJBException {
        Connection connection = null;
        Statement statement = null;
        String string = persistenceDescriptor.getSqlStatementFor("findByPrimaryKey");
        connection = PersistenceManagerImpl.getConnection(persistenceDescriptor);
        statement = connection.prepareStatement(string);
        PersistentFieldInfo[] persistentFieldInfoArray = persistenceDescriptor.getPkeyFieldInfo();
        Field[] fieldArray = persistenceDescriptor.getPkeyClassFields();
        if (persistenceDescriptor.primaryKeyIsOneField()) {
            JDBCUtils.copyObjToDB((PreparedStatement)statement, 1, object, persistentFieldInfoArray[0].jdbcType);
        } else {
            int n = 0;
            while (n < fieldArray.length) {
                JDBCUtils.copyFieldToDB((PreparedStatement)statement, n + 1, fieldArray[n], object, persistentFieldInfoArray[n].jdbcType);
                ++n;
            }
        }
        ResultSet resultSet = statement.executeQuery();
        boolean bl = resultSet.next();
        try {
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
        catch (Exception exception) {
            boolean bl2;
            try {
                EJBUtils.throwEJBException(exception);
                bl2 = false;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception2) {}
                throw throwable;
            }
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception3) {
                // empty catch block
            }
            return bl2;
        }
    }

    Object getPrimaryKey(PersistentState persistentState) throws EJBException {
        PersistenceDescriptor persistenceDescriptor = persistentState.__getPersistenceDescriptor();
        Descriptor descriptor = persistenceDescriptor.getParentDescriptor();
        if (descriptor instanceof JoinObjectDescriptor) {
            return persistentState;
        }
        Object object = null;
        try {
            Field[] fieldArray = persistenceDescriptor.getPkeyClassFields();
            PersistentFieldInfo[] persistentFieldInfoArray = persistenceDescriptor.getPkeyFieldInfo();
            if (persistenceDescriptor.primaryKeyIsOneField()) {
                object = persistentFieldInfoArray[0].field.get(persistentState);
            } else {
                Class<?> clazz = fieldArray[0].getDeclaringClass();
                object = clazz.newInstance();
                int n = 0;
                while (n < fieldArray.length) {
                    Object object2 = persistentFieldInfoArray[n].field.get(persistentState);
                    if (object2 == null) {
                        return null;
                    }
                    fieldArray[n].set(object, object2);
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            EJBUtils.throwEJBException(exception);
            return null;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRow(PersistentState persistentState, Object object) throws EJBException {
        PersistenceDescriptor persistenceDescriptor = persistentState.__getPersistenceDescriptor();
        String string = persistenceDescriptor.getSqlStatementFor("deleteRow");
        Field[] fieldArray = persistenceDescriptor.getPkeyClassFields();
        PersistentFieldInfo[] persistentFieldInfoArray = persistenceDescriptor.getPkeyFieldInfo();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            int n;
            connection = PersistenceManagerImpl.getConnection(persistenceDescriptor);
            preparedStatement = connection.prepareStatement(string);
            if (persistenceDescriptor.primaryKeyIsOneField()) {
                JDBCUtils.copyObjToDB(preparedStatement, 1, object, persistentFieldInfoArray[0].jdbcType);
            } else {
                n = 0;
                while (n < fieldArray.length) {
                    JDBCUtils.copyFieldToDB(preparedStatement, n + 1, fieldArray[n], object, persistentFieldInfoArray[n].jdbcType);
                    ++n;
                }
            }
            n = preparedStatement.executeUpdate();
            if (n != 1) {
                throw new EJBException("ERROR in removeRow!! resultCount = " + n);
            }
        }
        catch (Exception exception) {
            EJBUtils.throwEJBException(exception);
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeRow(PersistentState persistentState, Object object) throws EJBException {
        Object object2;
        int n = persistentState.__getStatus();
        PersistenceDescriptor persistenceDescriptor = persistentState.__getPersistenceDescriptor();
        Descriptor descriptor = persistenceDescriptor.getParentDescriptor();
        if (descriptor instanceof EjbCMPEntityDescriptor) {
            object2 = (EjbCMPEntityDescriptor)descriptor;
            switch (n) {
                case 1: {
                    if (!((EjbCMPEntityDescriptor)object2).isEJB20()) break;
                    return;
                }
                case 2: {
                    this.createRow(persistentState, object);
                    return;
                }
                case 3: {
                    throw new EJBException("Internal Error: ejbStore called for deleted bean");
                }
            }
        }
        object2 = persistenceDescriptor.getSqlStatementFor("storeRow");
        PersistentFieldInfo[] persistentFieldInfoArray = persistenceDescriptor.getNonPkeyPersFieldInfo();
        PersistentFieldInfo[] persistentFieldInfoArray2 = persistenceDescriptor.getPkeyFieldInfo();
        if (persistentFieldInfoArray.length == 0) {
            return;
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = PersistenceManagerImpl.getConnection(persistenceDescriptor);
            preparedStatement = connection.prepareStatement((String)object2);
            int n2 = 1;
            int n3 = 0;
            while (n3 < persistentFieldInfoArray.length) {
                JDBCUtils.copyFieldToDB(preparedStatement, n2++, persistentFieldInfoArray[n3].field, persistentState, persistentFieldInfoArray[n3].jdbcType);
                ++n3;
            }
            int n4 = 0;
            while (n4 < persistentFieldInfoArray2.length) {
                JDBCUtils.copyFieldToDB(preparedStatement, n2++, persistentFieldInfoArray2[n4].field, persistentState, persistentFieldInfoArray2[n4].jdbcType);
                ++n4;
            }
            int n5 = preparedStatement.executeUpdate();
            if (n5 != 1) {
                throw new EJBException("ERROR in storeRow!! resultCount = " + n5);
            }
        }
        catch (Exception exception) {
            EJBUtils.throwEJBException(exception);
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    HashSet loadJoinObjects(PersistentState persistentState, Object object, PersistenceDescriptor persistenceDescriptor, CMRFieldInfo cMRFieldInfo, PartitionImpl partitionImpl) throws Exception {
        Serializable serializable;
        RelationRoleDescriptor relationRoleDescriptor = cMRFieldInfo.role;
        JoinObjectDescriptor joinObjectDescriptor = relationRoleDescriptor.getRelationshipDescriptor().getJoinDescriptor();
        PersistenceDescriptor persistenceDescriptor2 = joinObjectDescriptor.getPersistenceDescriptor();
        Connection connection = null;
        Statement statement = null;
        String string = relationRoleDescriptor.getRelationshipDescriptor().getSource() == relationRoleDescriptor ? persistenceDescriptor2.getSqlStatementFor("findBySourceKey") : persistenceDescriptor2.getSqlStatementFor("findBySinkKey");
        PersistentFieldInfo[] persistentFieldInfoArray = persistenceDescriptor.getPkeyFieldInfo();
        Field[] fieldArray = persistenceDescriptor.getPkeyClassFields();
        connection = PersistenceManagerImpl.getConnection(persistenceDescriptor);
        statement = connection.prepareStatement(string);
        if (persistenceDescriptor.primaryKeyIsOneField()) {
            JDBCUtils.copyObjToDB((PreparedStatement)statement, 1, object, persistentFieldInfoArray[0].jdbcType);
        } else {
            int n = 0;
            while (n < fieldArray.length) {
                JDBCUtils.copyFieldToDB((PreparedStatement)statement, n + 1, fieldArray[n], object, persistentFieldInfoArray[n].jdbcType);
                ++n;
            }
        }
        ResultSet resultSet = statement.executeQuery();
        HashSet<Object> hashSet = new HashSet<Object>();
        while (resultSet.next()) {
            Object object2;
            serializable = persistenceDescriptor2.getPersistentClass();
            PersistentState persistentState2 = (PersistentState)((Class)serializable).newInstance();
            persistentState2.__setPersistenceDescriptor(persistenceDescriptor2);
            PersistentFieldInfo[] persistentFieldInfoArray2 = persistenceDescriptor2.getPersistentFieldInfo();
            int n = 1;
            int n2 = 0;
            while (n2 < persistentFieldInfoArray2.length) {
                object2 = persistentFieldInfoArray2[n2];
                if (((PersistentFieldInfo)object2).relatedObj == relationRoleDescriptor.getPersistenceDescriptor()) {
                    Object object3 = object;
                    if (!persistenceDescriptor.primaryKeyIsOneField()) {
                        Field field = object.getClass().getField(((PersistentFieldInfo)object2).relatedName);
                        object3 = field.get(object);
                    }
                    ((PersistentFieldInfo)object2).field.set(persistentState2, object3);
                } else {
                    JDBCUtils.copyFieldFromDB(resultSet, n++, ((PersistentFieldInfo)object2).field, persistentState2, ((PersistentFieldInfo)object2).jdbcType);
                }
                ++n2;
            }
            persistentState2.__setStatus(1);
            object2 = partitionImpl.addJoinObject(persistentState2, joinObjectDescriptor, relationRoleDescriptor);
            if (object2 == null) continue;
            hashSet.add(object2);
        }
        serializable = hashSet;
        try {
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return serializable;
        catch (Exception exception) {
            HashSet hashSet2;
            try {
                EJBUtils.throwEJBException(exception);
                hashSet2 = null;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception2) {}
                throw throwable;
            }
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception3) {
                // empty catch block
            }
            return hashSet2;
        }
    }

    static Connection getConnection(PersistenceDescriptor persistenceDescriptor) {
        return PersistenceManagerImpl.getConnection(persistenceDescriptor.getEjbBundleDescriptor());
    }

    static Connection getConnection(EjbBundleDescriptor ejbBundleDescriptor) {
        try {
            ResourceReferenceDescriptor resourceReferenceDescriptor = ejbBundleDescriptor.getCMPResourceReference();
            DataSource dataSource = null;
            if (resourceReferenceDescriptor != null) {
                dataSource = resourceReferenceDescriptor.getPMJDBCDataSource();
            }
            if (dataSource == null) {
                throw new EJBException("Unable to get JDBC DataSource for CMP EntityBean state");
            }
            ResourcePrincipal resourcePrincipal = resourceReferenceDescriptor.getResourcePrincipal();
            Connection connection = dataSource.getConnection(resourcePrincipal.getName(), resourcePrincipal.getPassword());
            return connection;
        }
        catch (SQLException sQLException) {
            throw new EJBException((Exception)sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRow(PersistentState persistentState, Object object) throws EJBException {
        PersistenceDescriptor persistenceDescriptor = persistentState.__getPersistenceDescriptor();
        String string = persistenceDescriptor.getSqlStatementFor("createRow");
        PersistentFieldInfo[] persistentFieldInfoArray = persistenceDescriptor.getPersistentFieldInfo();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = PersistenceManagerImpl.getConnection(persistenceDescriptor);
            preparedStatement = connection.prepareStatement(string);
            int n = 0;
            while (n < persistentFieldInfoArray.length) {
                JDBCUtils.copyFieldToDB(preparedStatement, n + 1, persistentFieldInfoArray[n].field, persistentState, persistentFieldInfoArray[n].jdbcType);
                ++n;
            }
            int n2 = preparedStatement.executeUpdate();
            if (n2 != 1) {
                throw new EJBException("ERROR in createRow!! resultCount = " + n2);
            }
        }
        catch (Exception exception) {
            EJBUtils.throwEJBException(exception);
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

