/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.monitor;

import com.iplanet.ias.admin.monitor.BaseMonitorMBean;
import com.iplanet.ias.admin.monitor.types.Counter;
import com.iplanet.ias.admin.monitor.types.Gauge;
import com.iplanet.ias.admin.monitor.types.MonitoredAttributeType;
import com.sun.ejb.containers.util.pool.AbstractPool;
import com.sun.logging.LogDomains;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanInfo;
import javax.management.RuntimeOperationsException;

public class PoolMonitorMBean
extends BaseMonitorMBean {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    AbstractPool pool;
    private static Object[][] attrNameTypeArray;
    private Map attrNameTypeMap;
    private MBeanInfo mBeanInfo;

    public PoolMonitorMBean(AbstractPool abstractPool) {
        this.pool = abstractPool;
        attrNameTypeArray = this.getAttrNameTypeArray();
        this.attrNameTypeMap = BaseMonitorMBean.createAttrNameTypeMap(attrNameTypeArray);
        this.mBeanInfo = BaseMonitorMBean.createMBeanInfo(this.attrNameTypeMap);
    }

    protected Object[][] getAttrNameTypeArray() {
        return new Object[][]{{"max-pool-size", new Gauge(Integer.TYPE)}, {"steady-pool-size", new Gauge(Integer.TYPE)}, {"pool-resize-quantity", new Gauge(Integer.TYPE)}, {"idle-timeout-in-seconds", new Gauge(Integer.TYPE)}, {"num-beans-in-pool", new Gauge(Integer.TYPE)}, {"num-threads-waiting", new Gauge(Integer.TYPE)}, {"total-beans-created", Counter.INTEGER}, {"total-beans-destroyed", Counter.INTEGER}};
    }

    public Object getAttribute(String string) throws AttributeNotFoundException {
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"));
        }
        if (string.equals("max-pool-size")) {
            return new Integer(this.pool.getMaxPoolSize());
        }
        if (string.equals("steady-pool-size")) {
            return new Integer(this.pool.getSteadyPoolSize());
        }
        if (string.equals("pool-resize-quantity")) {
            return new Integer(this.pool.getResizeQuantity());
        }
        if (string.equals("idle-timeout-in-seconds")) {
            return new Integer(this.pool.getIdleTimeoutInSeconds());
        }
        if (string.equals("num-beans-in-pool")) {
            return new Integer(this.pool.getSize());
        }
        if (string.equals("num-threads-waiting")) {
            return new Integer(this.pool.getWaitCount());
        }
        if (string.equals("total-beans-created")) {
            return new Integer(this.pool.getCreatedCount());
        }
        if (string.equals("total-beans-destroyed")) {
            return new Integer(this.pool.getDestroyedCount());
        }
        throw new AttributeNotFoundException("Cannot find " + string + " attribute");
    }

    public AttributeList getAttributes(String[] stringArray) {
        if (stringArray == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attributeNames[] cannot be null"));
        }
        AttributeList attributeList = new AttributeList();
        if (stringArray.length == 0) {
            return attributeList;
        }
        int n = 0;
        while (n < stringArray.length) {
            try {
                Object object = this.getAttribute(stringArray[n]);
                attributeList.add(new Attribute(stringArray[n], object));
            }
            catch (Exception exception) {
                _logger.log(Level.WARNING, "ejb.getattribute_excepton", exception.toString());
            }
            ++n;
        }
        return attributeList;
    }

    public void startMonitoring() {
    }

    public void stopMonitoring() {
    }

    public MBeanInfo getMBeanInfo() {
        return this.mBeanInfo;
    }

    public Map getMonitoringMetaData() {
        return this.attrNameTypeMap;
    }

    public MonitoredAttributeType getAttributeType(String string) {
        MonitoredAttributeType monitoredAttributeType = null;
        if (this.attrNameTypeMap != null && string != null) {
            monitoredAttributeType = (MonitoredAttributeType)this.attrNameTypeMap.get(string);
        }
        return monitoredAttributeType;
    }
}

