/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.iiop;

import com.iplanet.ias.corba.ee.internal.util.LogWrap;
import com.sun.corba.ee.internal.core.GIOPVersion;
import com.sun.corba.ee.internal.iiop.IIOPConnection;
import com.sun.corba.ee.internal.orbutil.ORBUtility;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import org.omg.CORBA.INTERNAL;

final class ReaderThread
extends Thread {
    private boolean keepRunning = true;
    private boolean debug;
    private IIOPConnection c;

    private void dprint(String string) {
        ORBUtility.dprint(this, string);
    }

    public ReaderThread(ThreadGroup threadGroup, IIOPConnection iIOPConnection, String string, boolean bl) {
        super(threadGroup, string);
        this.c = iIOPConnection;
        this.debug = bl;
    }

    public ReaderThread(IIOPConnection iIOPConnection, String string, boolean bl) {
        super(string);
        this.c = iIOPConnection;
        this.debug = bl;
    }

    public IIOPConnection getCurrentConnection() {
        return this.c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.keepRunning) {
            try {
                this.c.processInput();
            }
            catch (IOException iOException) {
                if (this.debug) {
                    this.dprint("IOException in createInputStream: " + iOException);
                    iOException.printStackTrace();
                }
                this.c.purge_calls(1398079696, true, false);
                this.keepRunning = false;
            }
            catch (ThreadDeath threadDeath) {
                if (this.debug) {
                    this.dprint("ThreadDeath thrown while reading request: " + threadDeath);
                    threadDeath.printStackTrace();
                }
                try {
                    this.c.purge_calls(1398079696, false, false);
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw threadDeath;
                }
                throw threadDeath;
            }
            catch (Throwable throwable) {
                LogWrap.logger.log(Level.WARNING, "", throwable);
                if (this.debug) {
                    this.dprint("Exception thrown while reading request: " + throwable);
                    throwable.printStackTrace();
                }
                try {
                    if (throwable instanceof INTERNAL) {
                        this.c.sendMessageError(GIOPVersion.DEFAULT_VERSION);
                    }
                }
                catch (IOException iOException) {
                    LogWrap.logger.log(Level.WARNING, "", iOException);
                }
                this.c.purge_calls(1398079696, false, false);
                this.keepRunning = false;
                return;
            }
        }
    }

    synchronized void shutdown() {
        this.keepRunning = false;
        try {
            InputStream inputStream = this.c.getInputStream();
            inputStream.close();
        }
        catch (Exception exception) {
            LogWrap.logger.log(Level.FINE, "", exception);
        }
        try {
            this.start();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            LogWrap.logger.log(Level.FINE, "", illegalThreadStateException);
        }
    }
}

