/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.iiop;

import com.sun.corba.ee.internal.iiop.BufferManagerWrite;
import com.sun.corba.ee.internal.iiop.ByteBufferWithInfo;
import com.sun.corba.ee.internal.iiop.IIOPConnection;
import com.sun.corba.ee.internal.iiop.messages.FragmentMessage;
import com.sun.corba.ee.internal.iiop.messages.MessageBase;

public class BufferManagerWriteStream
extends BufferManagerWrite {
    private int initialFragmentSize = 0;
    private int fragmentCount = 0;
    private ByteBufferWithInfo finalFragment = null;

    public BufferManagerWriteStream(int n) {
        this.stream = null;
        this.initialFragmentSize = n;
    }

    public ByteBufferWithInfo getInitialBuffer(int n) {
        return new ByteBufferWithInfo(n);
    }

    public int getInitialBufferSize() {
        return this.initialFragmentSize;
    }

    public void overflow(ByteBufferWithInfo byteBufferWithInfo) {
        MessageBase.setFlag(byteBufferWithInfo.buf, 2);
        this.sendFragment(false);
        byteBufferWithInfo.index = 0;
        byteBufferWithInfo.buflen = byteBufferWithInfo.buf.length;
        byteBufferWithInfo.fragmented = true;
        FragmentMessage fragmentMessage = this.stream.getMessage().createFragmentMessage();
        fragmentMessage.write(this.stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFragment(boolean bl) {
        int n;
        IIOPConnection iIOPConnection = (IIOPConnection)this.stream.getConnection();
        iIOPConnection.writeLock();
        if (this.fragmentCount == 0) {
            n = MessageBase.getRequestId(this.stream.getMessage());
            iIOPConnection.createOutCallDescriptor(n);
            iIOPConnection.createIdToFragmentedOutputStreamEntry(n, this.stream);
        }
        try {
            iIOPConnection.sendWithoutLock(this.stream);
        }
        finally {
            if (bl) {
                n = MessageBase.getRequestId(this.stream.getMessage());
                iIOPConnection.removeIdToFragmentedOutputStreamEntry(n);
            }
            iIOPConnection.writeUnlock();
            ++this.fragmentCount;
        }
    }

    public void sendMessage() {
        this.sendFragment(true);
    }
}

