/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.Activation;

import com.iplanet.ias.corba.ee.internal.util.LogWrap;
import com.sun.corba.ee.ActivationIDL.EndPointInfo;
import com.sun.corba.ee.ActivationIDL.InvalidORBid;
import com.sun.corba.ee.ActivationIDL.Locator;
import com.sun.corba.ee.ActivationIDL.LocatorHelper;
import com.sun.corba.ee.ActivationIDL.LocatorPackage.ServerLocationPerORB;
import com.sun.corba.ee.ActivationIDL.ServerHeldDown;
import com.sun.corba.ee.ActivationIDL.ServerNotRegistered;
import com.sun.corba.ee.internal.Activation.CommandHandler;
import com.sun.corba.ee.internal.Activation.ServerTool;
import com.sun.corba.ee.internal.orbutil.CorbaResourceUtil;
import java.io.PrintStream;
import java.util.logging.Level;
import org.omg.CORBA.ORB;

class LocateServerForORB
implements CommandHandler {
    static final int illegalServerId = -1;

    LocateServerForORB() {
    }

    public String getCommandName() {
        return "locateperorb";
    }

    public void printCommandHelp(PrintStream printStream, boolean bl) {
        if (!bl) {
            printStream.println(CorbaResourceUtil.getText("servertool.locateorb"));
        } else {
            printStream.println(CorbaResourceUtil.getText("servertool.locateorb1"));
        }
    }

    public boolean processCommand(String[] stringArray, ORB oRB, PrintStream printStream) {
        int n = -1;
        String string = "";
        try {
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string2;
                if ((string2 = stringArray[n2++]).equals("-serverid")) {
                    if (n2 < stringArray.length) {
                        n = Integer.valueOf(stringArray[n2++]);
                        continue;
                    }
                    return true;
                }
                if (string2.equals("-applicationName")) {
                    if (n2 < stringArray.length) {
                        n = ServerTool.getServerIdForAlias(oRB, stringArray[n2++]);
                        continue;
                    }
                    return true;
                }
                if (!string2.equals("-orbid") || n2 >= stringArray.length) continue;
                string = stringArray[n2++];
            }
            if (n == -1) {
                return true;
            }
            Locator locator = LocatorHelper.narrow(oRB.resolve_initial_references("ServerLocator"));
            ServerLocationPerORB serverLocationPerORB = locator.locateServerForORB(n, string);
            printStream.println(CorbaResourceUtil.getText("servertool.locateorb2", serverLocationPerORB.hostname));
            int n3 = serverLocationPerORB.ports.length;
            n2 = 0;
            while (n2 < n3) {
                EndPointInfo endPointInfo = serverLocationPerORB.ports[n2];
                printStream.println("\t\t" + endPointInfo.port + "\t\t" + endPointInfo.endpointType + "\t\t" + string);
                ++n2;
            }
        }
        catch (InvalidORBid invalidORBid) {
            LogWrap.logger.log(Level.FINE, CorbaResourceUtil.getText("servertool.nosuchorb"), invalidORBid);
            printStream.println(CorbaResourceUtil.getText("servertool.nosuchorb"));
        }
        catch (ServerHeldDown serverHeldDown) {
            LogWrap.logger.log(Level.FINE, CorbaResourceUtil.getText("servertool.helddown"), serverHeldDown);
            printStream.println(CorbaResourceUtil.getText("servertool.helddown"));
        }
        catch (ServerNotRegistered serverNotRegistered) {
            LogWrap.logger.log(Level.FINE, CorbaResourceUtil.getText("servertool.nosuchserver"), serverNotRegistered);
            printStream.println(CorbaResourceUtil.getText("servertool.nosuchserver"));
        }
        catch (Exception exception) {
            LogWrap.logger.log(Level.WARNING, "", exception);
        }
        return false;
    }
}

