/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.web.cache.mapping;

import com.sun.appserv.web.cache.mapping.Constants;
import com.sun.appserv.web.cache.mapping.Field;
import com.sun.appserv.web.cache.mapping.ValueConstraint;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class ConstraintField
extends Field {
    private static Logger _logger = null;
    private static boolean _isTraceEnabled = false;
    boolean cacheOnMatch = true;
    boolean cacheOnMatchFailure = false;
    ValueConstraint[] constraints = new ValueConstraint[0];

    public ConstraintField(String string, String string2) throws IllegalArgumentException {
        super(string, string2);
        if (_logger == null) {
            _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
            _isTraceEnabled = _logger.isLoggable(Level.FINE);
        }
    }

    public void setCacheOnMatch(boolean bl) {
        this.cacheOnMatch = bl;
    }

    public boolean getCacheOnMatch() {
        return this.cacheOnMatch;
    }

    public void setCacheOnMatchFailure(boolean bl) {
        this.cacheOnMatchFailure = bl;
    }

    public boolean getCacheOnMatchFailure() {
        return this.cacheOnMatchFailure;
    }

    public void addConstraint(ValueConstraint valueConstraint) {
        if (valueConstraint == null) {
            return;
        }
        ValueConstraint[] valueConstraintArray = new ValueConstraint[this.constraints.length + 1];
        int n = 0;
        while (n < this.constraints.length) {
            valueConstraintArray[n] = this.constraints[n];
            ++n;
        }
        valueConstraintArray[this.constraints.length] = valueConstraint;
        this.constraints = valueConstraintArray;
    }

    public void setValueConstraints(ValueConstraint[] valueConstraintArray) {
        if (valueConstraintArray == null) {
            return;
        }
        this.constraints = valueConstraintArray;
    }

    public boolean applyConstraints(ServletContext servletContext, HttpServletRequest httpServletRequest) {
        Object object = this.getValue(servletContext, httpServletRequest);
        if (object == null) {
            if (_isTraceEnabled) {
                _logger.fine("The constraint field " + this.name + " is not found in the scope " + Constants.SCOPE_NAMES[this.scope] + "; returning cache-on-match-failure: " + this.cacheOnMatchFailure);
            }
            return this.cacheOnMatchFailure;
        }
        if (this.constraints.length == 0) {
            if (_isTraceEnabled) {
                _logger.fine("The constraint field " + this.name + " value = " + object.toString() + " is found in the scope " + Constants.SCOPE_NAMES[this.scope] + "; returning cache-on-match: " + this.cacheOnMatch);
            }
            return this.cacheOnMatch;
        }
        int n = 0;
        while (n < this.constraints.length) {
            ValueConstraint valueConstraint = this.constraints[n];
            if (valueConstraint.matches(object)) {
                if (_isTraceEnabled) {
                    _logger.fine("The constraint field " + this.name + " value = " + object.toString() + " is found in the scope " + Constants.SCOPE_NAMES[this.scope] + "; and matches with a value " + valueConstraint.toString() + "; returning cache-on-match: " + this.cacheOnMatch);
                }
                return this.cacheOnMatch;
            }
            ++n;
        }
        if (_isTraceEnabled) {
            _logger.fine("The constraint field " + this.name + " value = " + object.toString() + " is found in the scope " + Constants.SCOPE_NAMES[this.scope] + "; but didn't match with any of the value constraints; returning cache-on-match-failure = " + this.cacheOnMatchFailure);
        }
        return this.cacheOnMatchFailure;
    }
}

