/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.orbutil;

import com.iplanet.ias.util.orbutil.IdentityHashtableEntry;
import com.iplanet.ias.util.orbutil.IdentityHashtableEnumerator;
import java.util.Dictionary;
import java.util.Enumeration;

public final class IdentityHashtable
extends Dictionary {
    private transient IdentityHashtableEntry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;

    public IdentityHashtable(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = f;
        this.table = new IdentityHashtableEntry[n];
        this.threshold = (int)((float)n * f);
    }

    public IdentityHashtable(int n) {
        this(n, 0.75f);
    }

    public IdentityHashtable() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Enumeration keys() {
        return new IdentityHashtableEnumerator(this.table, true);
    }

    public Enumeration elements() {
        return new IdentityHashtableEnumerator(this.table, false);
    }

    public boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        IdentityHashtableEntry[] identityHashtableEntryArray = this.table;
        int n = identityHashtableEntryArray.length;
        while (n-- > 0) {
            IdentityHashtableEntry identityHashtableEntry = identityHashtableEntryArray[n];
            while (identityHashtableEntry != null) {
                if (identityHashtableEntry.value == object) {
                    return true;
                }
                identityHashtableEntry = identityHashtableEntry.next;
            }
        }
        return false;
    }

    public boolean containsKey(Object object) {
        boolean bl = true;
        if (this.get(object, System.identityHashCode(object)) == null) {
            bl = false;
        }
        return bl;
    }

    public boolean containsKey(Object object, int n) {
        boolean bl = true;
        if (this.get(object, n) == null) {
            bl = false;
        }
        return bl;
    }

    public Object get(Object object, int n) {
        IdentityHashtableEntry[] identityHashtableEntryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % identityHashtableEntryArray.length;
        IdentityHashtableEntry identityHashtableEntry = identityHashtableEntryArray[n2];
        while (identityHashtableEntry != null) {
            if (identityHashtableEntry.hash == n && identityHashtableEntry.key == object) {
                return identityHashtableEntry.value;
            }
            identityHashtableEntry = identityHashtableEntry.next;
        }
        return null;
    }

    public Object get(Object object) {
        return this.get(object, System.identityHashCode(object));
    }

    protected void rehash() {
        int n = this.table.length;
        IdentityHashtableEntry[] identityHashtableEntryArray = this.table;
        int n2 = n * 2 + 1;
        IdentityHashtableEntry[] identityHashtableEntryArray2 = new IdentityHashtableEntry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = identityHashtableEntryArray2;
        int n3 = n;
        while (n3-- > 0) {
            IdentityHashtableEntry identityHashtableEntry = identityHashtableEntryArray[n3];
            while (identityHashtableEntry != null) {
                IdentityHashtableEntry identityHashtableEntry2 = identityHashtableEntry;
                identityHashtableEntry = identityHashtableEntry.next;
                int n4 = (identityHashtableEntry2.hash & Integer.MAX_VALUE) % n2;
                identityHashtableEntry2.next = identityHashtableEntryArray2[n4];
                identityHashtableEntryArray2[n4] = identityHashtableEntry2;
            }
        }
    }

    public Object put(Object object, Object object2) {
        if (object2 == null) {
            throw new NullPointerException();
        }
        return this.put(object, System.identityHashCode(object), object2);
    }

    public Object put(Object object, int n, Object object2) {
        if (object2 == null) {
            throw new NullPointerException();
        }
        IdentityHashtableEntry[] identityHashtableEntryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % identityHashtableEntryArray.length;
        IdentityHashtableEntry identityHashtableEntry = identityHashtableEntryArray[n2];
        while (identityHashtableEntry != null) {
            if (identityHashtableEntry.hash == n && identityHashtableEntry.key == object) {
                Object object3 = identityHashtableEntry.value;
                identityHashtableEntry.value = object2;
                return object3;
            }
            identityHashtableEntry = identityHashtableEntry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(object, object2);
        }
        IdentityHashtableEntry identityHashtableEntry2 = new IdentityHashtableEntry();
        identityHashtableEntry2.hash = n;
        identityHashtableEntry2.key = object;
        identityHashtableEntry2.value = object2;
        identityHashtableEntry2.next = identityHashtableEntryArray[n2];
        identityHashtableEntryArray[n2] = identityHashtableEntry2;
        ++this.count;
        return null;
    }

    public Object remove(Object object) {
        return this.remove(object, System.identityHashCode(object));
    }

    public Object remove(Object object, int n) {
        IdentityHashtableEntry[] identityHashtableEntryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % identityHashtableEntryArray.length;
        IdentityHashtableEntry identityHashtableEntry = identityHashtableEntryArray[n2];
        IdentityHashtableEntry identityHashtableEntry2 = null;
        while (identityHashtableEntry != null) {
            if (identityHashtableEntry.hash == n && identityHashtableEntry.key == object) {
                if (identityHashtableEntry2 != null) {
                    identityHashtableEntry2.next = identityHashtableEntry.next;
                } else {
                    identityHashtableEntryArray[n2] = identityHashtableEntry.next;
                }
                --this.count;
                return identityHashtableEntry.value;
            }
            identityHashtableEntry2 = identityHashtableEntry;
            identityHashtableEntry = identityHashtableEntry.next;
        }
        return null;
    }

    public void clear() {
        IdentityHashtableEntry[] identityHashtableEntryArray = this.table;
        int n = identityHashtableEntryArray.length;
        while (--n >= 0) {
            identityHashtableEntryArray[n] = null;
        }
        this.count = 0;
    }

    public String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.keys();
        Enumeration enumeration2 = this.elements();
        stringBuffer.append("{");
        int n2 = 0;
        while (n2 <= n) {
            String string = enumeration.nextElement().toString();
            String string2 = enumeration2.nextElement().toString();
            stringBuffer.append(string + "=" + string2);
            if (n2 < n) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

