/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util;

import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ApproximateClock
implements Runnable {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    private long sleepTime = 1000L;
    private long now;
    private Thread timerThread;
    private long[] time;
    private int index = 0;
    private int nextIndex;

    public ApproximateClock(long l) {
        this.setDelay(l);
        this.timerThread = new Thread((Runnable)this, "ApproximateClock");
        this.timerThread.setDaemon(true);
        this.time = new long[2];
        this.time[0] = System.currentTimeMillis();
        this.timerThread.start();
    }

    public long getActualTime() {
        this.nextIndex = 1 - this.index;
        this.time[this.nextIndex] = System.currentTimeMillis();
        this.index = this.nextIndex;
        return this.time[this.index];
    }

    public long getTime() {
        return this.time[this.index];
    }

    public void setDelay(long l) {
        this.sleepTime = l < 1L ? 1L : l;
    }

    public long getDelay() {
        return this.sleepTime;
    }

    public final void run() {
        try {
            while (true) {
                this.getActualTime();
                Thread.sleep(this.sleepTime);
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        int n = 100000000;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        l2 = System.currentTimeMillis();
        int n2 = 0;
        while (n2 < n) {
            l = System.currentTimeMillis();
            ++n2;
        }
        l3 = System.currentTimeMillis();
        _logger.log(Level.FINE, "sys.currentTimeMillis() took: " + (double)(l3 - l2) / 1000.0 + " seconds " + l);
        l2 = System.currentTimeMillis();
        ApproximateClock approximateClock = new ApproximateClock(3000L);
        int n3 = 0;
        while (n3 < n) {
            l = approximateClock.getTime();
            ++n3;
        }
        l3 = System.currentTimeMillis();
        _logger.log(Level.FINE, "clock.getTime() took: " + (double)(l3 - l2) / 1000.0 + " seconds " + l);
    }
}

