/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.server;

import com.iplanet.ias.admin.event.AdminEventListenerException;
import com.iplanet.ias.admin.event.AdminEventMulticaster;
import com.iplanet.ias.admin.event.ResourceDeployEvent;
import com.iplanet.ias.admin.event.ResourceDeployEventListener;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.Resources;
import com.iplanet.ias.config.serverbeans.ServerBeansFactory;
import com.iplanet.ias.server.ResourceDeployerFactory;
import com.iplanet.ias.server.ServerContext;
import com.iplanet.ias.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

class ResourceManager
implements ResourceDeployEventListener {
    static Logger _logger;
    private ServerContext serverContext_;
    private ResourceDeployerFactory factory_ = null;
    private static StringManager localStrings;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$iplanet$ias$server$ResourceManager;

    public ResourceManager(ServerContext serverContext) {
        this.serverContext_ = serverContext;
        this.factory_ = new ResourceDeployerFactory();
    }

    public void resourceDeployed(ResourceDeployEvent resourceDeployEvent) throws AdminEventListenerException {
        if (!$assertionsDisabled && resourceDeployEvent.getJ2EEComponentType() != "resource") {
            throw new AssertionError();
        }
        try {
            Resources resources = this.getResources(resourceDeployEvent.getConfigContext());
            String string = resourceDeployEvent.getResourceType();
            Object object = this.factory_.getResource(string, resourceDeployEvent.getResourceName(), resources);
            this.factory_.getResourceDeployer(string).deployResource(object);
            _logger.log(Level.INFO, "core.resourcedeployed", string + ":" + resourceDeployEvent.getResourceName());
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "core.resourcedeploy_error", exception);
            throw new AdminEventListenerException(exception.getMessage());
        }
    }

    public void resourceUndeployed(ResourceDeployEvent resourceDeployEvent) throws AdminEventListenerException {
        if (!$assertionsDisabled && resourceDeployEvent.getJ2EEComponentType() != "resource") {
            throw new AssertionError();
        }
        try {
            Resources resources = this.getResources(resourceDeployEvent.getOldConfigContext());
            String string = resourceDeployEvent.getResourceType();
            Object object = this.factory_.getResource(string, resourceDeployEvent.getResourceName(), resources);
            this.factory_.getResourceDeployer(string).undeployResource(object);
            _logger.log(Level.INFO, "core.resourceundeployed", string + ":" + resourceDeployEvent.getResourceName());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            AdminEventMulticaster.notifyFailure(resourceDeployEvent, "restart");
            _logger.log(Level.INFO, "core.resource_undeployed_restart_needed", resourceDeployEvent.getResourceName());
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "core.resourceundeploy_error", exception);
            throw new AdminEventListenerException(exception.getMessage());
        }
    }

    public void resourceRedeployed(ResourceDeployEvent resourceDeployEvent) throws AdminEventListenerException {
        if (!$assertionsDisabled && resourceDeployEvent.getJ2EEComponentType() != "resource") {
            throw new AssertionError();
        }
        try {
            Resources resources = this.getResources(resourceDeployEvent.getConfigContext());
            String string = resourceDeployEvent.getResourceType();
            Object object = this.factory_.getResource(string, resourceDeployEvent.getResourceName(), resources);
            this.factory_.getResourceDeployer(string).redeployResource(object);
            _logger.log(Level.INFO, "core.resourceredeployed", string + ":" + resourceDeployEvent.getResourceName());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            AdminEventMulticaster.notifyFailure(resourceDeployEvent, "restart");
            _logger.log(Level.INFO, "core.resource_redeployed_restart_needed", resourceDeployEvent.getResourceName());
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "core.resourceredeploy_error", exception);
            throw new AdminEventListenerException(exception.getMessage());
        }
    }

    public void resourceEnabled(ResourceDeployEvent resourceDeployEvent) throws AdminEventListenerException {
        if (!$assertionsDisabled && resourceDeployEvent.getJ2EEComponentType() != "resource") {
            throw new AssertionError();
        }
        try {
            Resources resources = this.getResources(resourceDeployEvent.getConfigContext());
            String string = resourceDeployEvent.getResourceType();
            Object object = this.factory_.getResource(string, resourceDeployEvent.getResourceName(), resources);
            this.factory_.getResourceDeployer(string).enableResource(object);
            _logger.log(Level.INFO, "core.resourceenabled", string + ":" + resourceDeployEvent.getResourceName());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            AdminEventMulticaster.notifyFailure(resourceDeployEvent, "restart");
            _logger.log(Level.INFO, "core.resource_enabled_restart_needed", resourceDeployEvent.getResourceName());
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "core.resourceenabled_error", exception);
            throw new AdminEventListenerException(exception.getMessage());
        }
    }

    public void resourceDisabled(ResourceDeployEvent resourceDeployEvent) throws AdminEventListenerException {
        if (!$assertionsDisabled && resourceDeployEvent.getJ2EEComponentType() != "resource") {
            throw new AssertionError();
        }
        try {
            Resources resources = this.getResources(resourceDeployEvent.getConfigContext());
            String string = resourceDeployEvent.getResourceType();
            Object object = this.factory_.getResource(string, resourceDeployEvent.getResourceName(), resources);
            this.factory_.getResourceDeployer(string).disableResource(object);
            _logger.log(Level.INFO, "core.resourcedisabled", string + ":" + resourceDeployEvent.getResourceName());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            AdminEventMulticaster.notifyFailure(resourceDeployEvent, "restart");
            _logger.log(Level.INFO, "core.resource_disabled_restart_needed", resourceDeployEvent.getResourceName());
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "core.resourcedisabled_error", exception);
            throw new AdminEventListenerException(exception.getMessage());
        }
    }

    private Resources getResources(ConfigContext configContext) throws ConfigException {
        Resources resources = ServerBeansFactory.getServerBean(configContext).getResources();
        if (resources == null) {
            String string = localStrings.getString("resourceManager.resource_not_found");
            throw new ConfigException(string);
        }
        return resources;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$iplanet$ias$server$ResourceManager == null ? (class$com$iplanet$ias$server$ResourceManager = ResourceManager.class$("com.iplanet.ias.server.ResourceManager")) : class$com$iplanet$ias$server$ResourceManager).desiredAssertionStatus();
        _logger = LogDomains.getLogger("javax.enterprise.system.core");
        localStrings = StringManager.getManager("com.iplanet.ias.server");
    }
}

