/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.security.util;

import com.iplanet.ias.security.util.IASSecurityException;
import com.iplanet.ias.util.i18n.StringManager;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class SSHA {
    private static final String SSHA_TAG = "{SSHA}";
    private static StringManager sm;
    private static MessageDigest md;
    static /* synthetic */ Class class$com$iplanet$ias$security$util$SSHA;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compute(byte[] byArray, byte[] byArray2) throws IASSecurityException {
        byte[] byArray3 = new byte[byArray2.length + byArray.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(byArray, 0, byArray3, byArray2.length, byArray.length);
        byte[] byArray4 = null;
        Class clazz = class$com$iplanet$ias$security$util$SSHA == null ? (class$com$iplanet$ias$security$util$SSHA = SSHA.class$("com.iplanet.ias.security.util.SSHA")) : class$com$iplanet$ias$security$util$SSHA;
        synchronized (clazz) {
            if (md == null) {
                try {
                    md = MessageDigest.getInstance("SHA");
                }
                catch (Exception exception) {
                    throw new IASSecurityException(exception);
                }
            }
            if (!$assertionsDisabled && md == null) {
                throw new AssertionError();
            }
            md.reset();
            byArray4 = md.digest(byArray3);
        }
        if (!$assertionsDisabled && byArray4.length != 20) {
            throw new AssertionError();
        }
        return byArray4;
    }

    public static byte[] compute(int n, byte[] byArray) throws IASSecurityException {
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray2 = new byte[n];
        secureRandom.nextBytes(byArray2);
        return SSHA.compute(byArray2, byArray);
    }

    public static String encode(byte[] byArray, byte[] byArray2) {
        if (!$assertionsDisabled && byArray2.length != 20) {
            throw new AssertionError();
        }
        byte[] byArray3 = new byte[20 + byArray.length];
        System.arraycopy(byArray2, 0, byArray3, 0, 20);
        System.arraycopy(byArray, 0, byArray3, 20, byArray.length);
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        String string = bASE64Encoder.encode(byArray3);
        String string2 = SSHA_TAG + string;
        return string2;
    }

    public static String computeAndEncode(byte[] byArray, byte[] byArray2) throws IASSecurityException {
        byte[] byArray3 = SSHA.compute(byArray, byArray2);
        return SSHA.encode(byArray, byArray3);
    }

    public static String computeAndEncode(int n, byte[] byArray) throws IASSecurityException {
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray2 = new byte[n];
        secureRandom.nextBytes(byArray2);
        byte[] byArray3 = SSHA.compute(byArray2, byArray);
        return SSHA.encode(byArray2, byArray3);
    }

    public static boolean verify(String string, byte[] byArray) throws IASSecurityException {
        byte[] byArray2 = new byte[20];
        byte[] byArray3 = SSHA.decode(string, byArray2);
        return SSHA.verify(byArray3, byArray2, byArray);
    }

    public static boolean verify(byte[] byArray, byte[] byArray2, byte[] byArray3) throws IASSecurityException {
        byte[] byArray4 = SSHA.compute(byArray, byArray3);
        return Arrays.equals(byArray2, byArray4);
    }

    public static byte[] decode(String string, byte[] byArray) throws IASSecurityException {
        if (!$assertionsDisabled && byArray.length != 20) {
            throw new AssertionError();
        }
        if (!string.startsWith(SSHA_TAG)) {
            String string2 = sm.getString("ssha.badformat", string);
            throw new IASSecurityException(string2);
        }
        String string3 = string.substring(SSHA_TAG.length());
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        byte[] byArray2 = null;
        try {
            byArray2 = bASE64Decoder.decodeBuffer(string3);
        }
        catch (IOException iOException) {
            throw new IASSecurityException(iOException);
        }
        if (!$assertionsDisabled && byArray2.length <= 20) {
            throw new AssertionError();
        }
        byte[] byArray3 = new byte[byArray2.length - 20];
        System.arraycopy(byArray2, 0, byArray, 0, 20);
        System.arraycopy(byArray2, 20, byArray3, 0, byArray2.length - 20);
        return byArray3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$iplanet$ias$security$util$SSHA == null ? (class$com$iplanet$ias$security$util$SSHA = SSHA.class$("com.iplanet.ias.security.util.SSHA")) : class$com$iplanet$ias$security$util$SSHA).desiredAssertionStatus();
        sm = StringManager.getManager("com.iplanet.ias.security.util");
        md = null;
    }
}

