/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.installer.dialogs;

import com.iplanet.install.panels.common.DirectorySelectionPanelBase;
import com.iplanet.install.panels.common.SetupSDKPanelBase;
import com.iplanet.install.util.QandA;
import com.iplanet.install.util.wbResource;
import com.sun.wizards.awt.ColumnLayout;
import com.sun.wizards.awt.HeaderPanel;
import com.sun.wizards.awt.VerticalLayout;
import com.sun.wizards.core.ArchiveReader;
import com.sun.wizards.core.Msg;
import com.sun.wizards.core.Route;
import com.sun.wizards.core.TTYDisplay;
import com.sun.wizards.core.WizardLeaf;
import com.sun.wizards.core.WizardState;
import com.sun.wizards.core.WizardTreeManager;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JTextField;

public class StudioDirectorySelectionPanel
extends DirectorySelectionPanelBase {
    protected Panel textPanel = null;
    protected Msg headerText = null;
    protected Msg descriptionText = null;
    protected Msg labelText = null;
    protected Button browseButton = null;
    protected Label dirSelectionLabel = null;
    protected transient String dirSelection = null;
    protected JFileChooser fc = null;
    protected JTextField baseDirectoryField = null;
    private String fileSep;

    public StudioDirectorySelectionPanel() {
    }

    public StudioDirectorySelectionPanel(WizardState wizardState, String string) {
        super(wizardState, string);
        this.setKeyValues(wizardState);
    }

    public StudioDirectorySelectionPanel(String string, Route route, WizardTreeManager wizardTreeManager) {
        super(string, route, wizardTreeManager);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.browseButton) {
            this.browseButtonPressed();
        }
    }

    public void addCriticalStateKeys(Vector vector) {
        super.addCriticalStateKeys(vector);
        vector.addElement(this.defaultKey);
        vector.addElement(this.currentKey);
    }

    public void addDescriptionText(Msg msg) {
        this.descriptionText = msg;
    }

    public void addHeaderText(Msg msg) {
        this.headerText = msg;
    }

    public void addLabelText(Msg msg) {
        this.labelText = msg;
    }

    public void addRuntimeResources(Vector vector) {
        super.addRuntimeResources(vector);
        vector.addElement("com.iplanet.ias.installer.dialogs.StudioDirectorySelectionPanel");
        vector.addElement("com.iplanet.install.panels.common.DirectorySelectionPanelBase");
    }

    protected void browseButtonPressed() {
        String string = null;
        try {
            String string2;
            string = this.baseDirectoryField.getText();
            if (string != null && string.length() > 0) {
                while (!this.fileExists(string)) {
                    string = this.getParentDirectory(string);
                    if (!System.getProperty("os.name").startsWith("Windows") || this.fileExists(string) || !this.getParentDirectory(string).equals(string)) continue;
                    string2 = ArchiveReader.systemInterface.getStandardInstallDirectory();
                    while (!string2.equals(this.getParentDirectory(string2))) {
                        string2 = this.getParentDirectory(string2);
                    }
                    string = string2;
                }
            }
            this.initDirBrowser(string);
            string2 = this.showDirBrowser();
            if (string2 != null && !string2.equals(this.baseDirectoryField.getText())) {
                this.baseDirectoryField.setText(string2);
            }
        }
        catch (Exception exception) {
            String string3 = "Unable to browse filesystem \"" + string + "\"";
            ((SetupSDKPanelBase)this).debug.error(string3);
            this.logEvent(string3);
        }
    }

    public void consoleInteraction() {
        Object[] objectArray = new Object[]{this.getProductName()};
        TTYDisplay.showNewline();
        TTYDisplay.showText((String)wbResource.getString((String)(String.valueOf(this.getName()) + "-ConsoleInteraction"), (Object[])objectArray));
        TTYDisplay.showNewline();
        TTYDisplay.setNavEnabled((boolean)true);
        String string = ((String)this.getData(this.currentKey)).trim();
        this.dirSelection = TTYDisplay.queryValue((String)wbResource.getString((String)(String.valueOf(this.getName()) + "-ConsoleInteraction-DirectorySelectionQuestion"), (Object[])objectArray), (String)string, null);
        if (this.dirSelection != null && this.dirSelection.equals(TTYDisplay.backOption)) {
            this.dirSelection = null;
            this.getTreeManager().backButtonPressed();
            return;
        }
        if (this.dirSelection != null) {
            this.dirSelection = this.dirSelection.trim();
        }
    }

    public void createUI() {
        super.createUI();
        if (!this.isGUIInstall()) {
            return;
        }
        HeaderPanel headerPanel = this.getHeaderPanel();
        if (headerPanel != null) {
            if (this.headerText != null) {
                headerPanel.setText(this.headerText.getString());
            } else {
                headerPanel.setText(wbResource.getString((String)(String.valueOf(this.getName()) + "-Gui-HeaderText")));
            }
            headerPanel.setInsets(new Insets(12, 10, 12, 10));
        }
        this.setTextPanel();
        ((Container)((Object)this)).add(this.textPanel, "Center");
    }

    protected void deserialize(DataInput dataInput) {
        super.deserialize(dataInput);
        try {
            this.defaultKey = dataInput.readUTF();
            this.currentKey = dataInput.readUTF();
            ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)((Object)dataInput));
            this.descriptionText = (Msg)objectInputStream.readObject();
            this.labelText = (Msg)objectInputStream.readObject();
            this.headerText = (Msg)objectInputStream.readObject();
        }
        catch (IOException iOException) {
            ((SetupSDKPanelBase)this).debug.error("deserialize: Error deserializing panel: " + iOException.toString());
            this.exit_serialization();
        }
        catch (ClassNotFoundException classNotFoundException) {
            ((SetupSDKPanelBase)this).debug.error("deserialize: Error deserializing DirectorySelectionPanel: " + classNotFoundException.toString());
            this.exit_serialization();
        }
    }

    public int getButtonMask() {
        return WizardLeaf.BACK_BUTTON | WizardLeaf.NEXT_BUTTON | WizardLeaf.EXIT_BUTTON;
    }

    protected void initDirBrowser(String string) {
        String string2 = wbResource.getString((String)(String.valueOf(this.getName()) + "-Gui-HeaderText"));
        this.fc = new JFileChooser(string);
        this.fc.setFileSelectionMode(1);
        this.fc.setMultiSelectionEnabled(false);
    }

    public boolean isDisplayComplete() {
        if (this.isGUIInstall()) {
            this.dirSelection = this.baseDirectoryField.getText().trim();
        }
        if (System.getProperty("wizard.statefile") != null) {
            this.dirSelection = (String)this.getWizardState().getData("AS_INSTALL_STUDIO_DIR");
        }
        if (!super.isDisplayComplete()) {
            return false;
        }
        if (this.dirSelection == null || this.dirSelection.trim().equals("")) {
            return false;
        }
        String string = this.getAbsolutePath(this.dirSelection);
        this.setData(this.currentKey, string);
        boolean bl = this.validateForteInstallation(string);
        if (!bl) {
            if (this.isGUIInstall()) {
                QandA.oneButton((WizardTreeManager)this.getTreeManager(), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-invalidfortelocation-Text")), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-invalidfortelocationdetail-Text")), (String)wbResource.getString((String)"Common-OK"));
            } else {
                System.out.println(wbResource.getString((String)(String.valueOf(this.getName()) + "-invalidfortelocationdetail-Text")));
            }
            if (System.getProperty("wizard.statefile") != null) {
                this.getTreeManager().exit(5);
            }
            return false;
        }
        if (!this.isWritable(this.dirSelection)) {
            if (this.isGUIInstall()) {
                QandA.oneButton((WizardTreeManager)this.getTreeManager(), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-QandA3-Title")), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-QandA3-Message")), (String)wbResource.getString((String)"Common-OK"));
                return false;
            }
            System.out.println(wbResource.getString((String)(String.valueOf(this.getName()) + "-QandA3-Message")));
            if (System.getProperty("wizard.statefile") != null) {
                this.getTreeManager().exit(6);
            } else {
                return false;
            }
        }
        return true;
    }

    public void reset(Object object) {
        String string = ((String)this.getData(this.defaultKey)).trim();
        this.setData(this.currentKey, string);
        this.setDirectory();
    }

    protected void serialize(DataOutput dataOutput) {
        super.serialize(dataOutput);
        try {
            dataOutput.writeUTF(this.defaultKey);
            dataOutput.writeUTF(this.currentKey);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)((Object)dataOutput));
            objectOutputStream.writeObject(this.descriptionText);
            objectOutputStream.writeObject(this.labelText);
            objectOutputStream.writeObject(this.headerText);
        }
        catch (IOException iOException) {
            ((SetupSDKPanelBase)this).debug.error(String.valueOf(((Object)((Object)this)).getClass().getName()) + "::serialize: Error serializing panel: " + iOException.toString());
            this.exit_serialization();
        }
    }

    public String setDirectory() {
        WizardTreeManager wizardTreeManager = this.getTreeManager();
        if (this.baseDirectoryField != null) {
            String string = ((String)this.getData(this.currentKey)).trim();
            if (string == null || string.length() == 0 || string.startsWith("null")) {
                return null;
            }
            Object object = this.getData("separatorCharacter");
            char c = '/';
            if (object != null && object instanceof Character) {
                c = ((Character)object).charValue();
            }
            string = string.replace('/', c);
            int n = -1;
            while ((n = string.indexOf(new String(new char[]{c, c}))) != -1) {
                string = String.valueOf(string.substring(0, n)) + string.substring(n + 1);
            }
            if (string.length() > File.separator.length() && string.endsWith(File.separator)) {
                string = string.substring(0, string.length() - File.separator.length());
            }
            if (this.baseDirectoryField != null) {
                this.baseDirectoryField.setText(string);
            }
            return string;
        }
        return null;
    }

    protected void setKeyValues(WizardState wizardState) {
        this.defaultKey = "AS_INSTALL_DEFAULT_STUDIO_DIR";
        this.currentKey = "AS_INSTALL_STUDIO_DIR";
    }

    protected void setTextPanel() {
        Object[] objectArray = new Object[]{this.getProductName()};
        this.textPanel = new Panel((LayoutManager)new VerticalLayout());
        Panel panel = new Panel((LayoutManager)new ColumnLayout());
        this.dirSelectionLabel = new Label(this.labelText != null ? this.labelText.getString() : wbResource.getString((String)(String.valueOf(this.getName()) + "-Gui-DirectorySelectionLabel"), (Object[])objectArray));
        panel.add(this.dirSelectionLabel);
        Panel panel2 = new Panel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.baseDirectoryField = new JTextField("", 30);
        panel2.add(this.baseDirectoryField);
        String string = this.setDirectory();
        this.browseButton = new Button(wbResource.getString((String)(String.valueOf(this.getName()) + "-Gui-BrowseButton")));
        panel2.add((Component)this.browseButton, gridBagConstraints);
        panel.add(panel2);
        this.setLayoutPercent("0", "0");
        this.textPanel.add((Component)panel, this.directoryNameLayoutPercent);
        this.browseButton.addActionListener((ActionListener)((Object)this));
    }

    protected String showDirBrowser() {
        Frame frame = this.getFrame();
        int n = this.fc.showOpenDialog(frame);
        if (n == 0) {
            return this.fc.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    public boolean skip() {
        if (super.skip()) {
            return true;
        }
        ((SetupSDKPanelBase)this).debug = this.getDebugObject();
        Vector vector = (Vector)this.getWizardState().getData("selectedComponents");
        return this.isStringInVector(wbResource.getString((String)"studioPluginComponentName"), vector) ^ true;
    }

    private boolean validateForteInstallation(String string) {
        if (System.getProperty("os.name").startsWith("Windows")) {
            return this.fileExists(String.valueOf(string) + "\\bin\\runide.exe") && this.fileExists(String.valueOf(string) + "\\bin\\ide.cfg") && this.fileExists(String.valueOf(string) + "\\lib\\core.jar");
        }
        return this.fileExists(String.valueOf(string) + "/bin/runide.sh") && this.fileExists(String.valueOf(string) + "/bin/ide.cfg") && this.fileExists(String.valueOf(string) + "/lib/core.jar");
    }
}

