/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.installer.dialogs;

import com.iplanet.ias.installer.dialogs.CommonTextField;
import com.iplanet.ias.installer.dialogs.RootFrame;
import com.iplanet.ias.installer.utilities.LinuxRoutines;
import com.iplanet.ias.installer.utilities.ProcessExecutor;
import com.iplanet.ias.installer.utilities.ValidateOS;
import com.iplanet.install.util.QandA;
import com.iplanet.install.util.wbResource;
import com.sun.wizards.awt.FlowLabel;
import com.sun.wizards.core.Route;
import com.sun.wizards.core.TTYDisplay;
import com.sun.wizards.core.WizardLeaf;
import com.sun.wizards.core.WizardState;
import com.sun.wizards.core.WizardTreeManager;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

public class LicenseKeyPanel
extends RootFrame {
    private transient String licenseKey;
    private transient CommonTextField licenseKeyField;
    private transient boolean isWindows;
    private transient boolean isMainstream;
    private transient String jdkHome;
    private transient String installDir;
    private transient String configDir;
    private transient String fileSep;
    private boolean isLinux;
    protected Button applyButton = null;
    boolean isGUIInstall;

    public LicenseKeyPanel() {
    }

    public LicenseKeyPanel(WizardState wizardState, String string) {
        super(wizardState, string);
    }

    public LicenseKeyPanel(String string, Route route, WizardTreeManager wizardTreeManager) {
        super(string, route, wizardTreeManager);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.applyButton) {
            this.applyButtonPressed();
        }
    }

    public void addCriticalStateKeys(Vector vector) {
        super.addCriticalStateKeys(vector);
    }

    public void addRuntimeResources(Vector vector) {
        super.addRuntimeResources(vector);
        vector.addElement("com.iplanet.ias.installer.dialogs.LicenseKeyPanel");
        vector.addElement("com.iplanet.ias.installer.dialogs.CommonTextField");
        vector.addElement("com.iplanet.ias.installer.utilities.ValidateOS");
        vector.addElement("com.iplanet.ias.installer.utilities.LinuxRoutines");
        vector.addElement("com.iplanet.ias.installer.utilities.NetworkRoutines");
        vector.addElement("com.iplanet.ias.installer.utilities.ProcessExecutor");
        vector.addElement("com.iplanet.ias.installer.utilities.FlusherThread");
        vector.addElement("com.iplanet.install.sobj.wbServerObject");
    }

    protected void applyButtonPressed() {
        WizardTreeManager wizardTreeManager = this.getTreeManager();
        if (this.licenseKeyField == null || this.licenseKeyField.getText().trim().length() == 0) {
            QandA.oneButton((WizardTreeManager)wizardTreeManager, (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-EmptyKey-Title")), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-EmptyKey-Text")), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-OK")));
            return;
        }
        boolean bl = this.upgradeLicense();
        if (bl) {
            QandA.oneButton((WizardTreeManager)wizardTreeManager, (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-LicenseUpgradeSuccess-Title")), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-LicenseUpgradeSuccess-Text")), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-OK")));
        } else {
            QandA.oneButton((WizardTreeManager)wizardTreeManager, (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-LicenseUpgradeFailure-Title")), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-LicenseUpgradeFailure-Text")), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-OK")));
        }
    }

    public void beginDisplay() {
        super.beginDisplay();
    }

    public void consoleInteraction() {
        String string;
        String string2 = wbResource.getString((String)(String.valueOf(this.getName()) + "-ConsoleInteraction-yesAnswer"));
        String string3 = wbResource.getString((String)(String.valueOf(this.getName()) + "-ConsoleInteraction-noAnswer"));
        wbResource.TTYShowText((String)wbResource.getString((String)(String.valueOf(this.getName()) + "-ConsoleInteraction")));
        this.licenseKey = string = TTYDisplay.queryValue((String)wbResource.getString((String)(String.valueOf(this.getName()) + "-ConsoleInteraction-licenseKeyQuestion")), (String)this.licenseKey, (String)"");
        if (this.licenseKey == null || this.licenseKey.trim().length() == 0) {
            wbResource.TTYShowText((String)wbResource.getString((String)(String.valueOf(this.getName()) + "-EmptyKeyConsole-Text")));
            return;
        }
        boolean bl = this.upgradeLicense();
        if (bl) {
            wbResource.TTYShowText((String)wbResource.getString((String)(String.valueOf(this.getName()) + "-LicenseUpgradeSuccess-Text")));
        } else {
            wbResource.TTYShowText((String)wbResource.getString((String)(String.valueOf(this.getName()) + "-LicenseUpgradeFailureConsole-Text")));
        }
    }

    public void createUI() {
        Object object;
        super.createUI();
        WizardState wizardState = this.getTreeManager().getWizardState();
        this.fileSep = "/";
        ValidateOS.init();
        if (ValidateOS.OSName.indexOf("Windows") != -1) {
            this.isWindows = true;
            this.fileSep = "\\";
        }
        if (ValidateOS.OSName.indexOf("Linux") != -1) {
            this.isLinux = true;
        }
        this.installDir = (String)wizardState.getData("currentInstallDirectory");
        String string = (String)wizardState.getData("IS_MAINSTREAM");
        this.isMainstream = string.equals("true");
        this.configDir = this.isWindows ? String.valueOf(this.installDir) + this.fileSep + "config" : (String)wizardState.getData("AS_INSTALL_CONFIG_DIR");
        this.jdkHome = this.isWindows ? (this.isMainstream ? (((String)(object = (String)wizardState.getData("USE_BUNDLED_JDK"))).equals("FALSE") ? (String)wizardState.getData("JDK_LOCATION") : String.valueOf(this.installDir) + this.fileSep + "jdk") : String.valueOf(this.installDir) + this.fileSep + "jdk") : (((String)(object = (String)wizardState.getData("USE_BUNDLED_JDK"))).equals("FALSE") ? (String)wizardState.getData("JDK_LOCATION") : (this.isLinux ? "/usr/java" + this.fileSep + "j2sdk" + LinuxRoutines.findRpmVersion((String)"j2sdk") : "/usr/j2se"));
        this.isGUIInstall = this.getTreeManager().getWizardState().hasGUI();
        if (!this.isGUIInstall) {
            return;
        }
        object = new Panel(new FlowLayout());
        FlowLabel flowLabel = new FlowLabel(wbResource.getString((String)(String.valueOf(this.getName()) + "-IntroText")));
        ((Container)object).add((Component)flowLabel);
        Panel panel = new Panel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.licenseKeyField = new CommonTextField(21);
        panel.add(this.licenseKeyField);
        this.applyButton = new Button(wbResource.getString((String)(String.valueOf(this.getName()) + "-ApplyButton")));
        panel.add((Component)this.applyButton, gridBagConstraints);
        this.applyButton.addActionListener((ActionListener)((Object)this));
        ((Container)object).add(panel);
        ((Container)((Object)this)).add((Component)object);
    }

    public int getButtonMask() {
        this.getTreeManager().requestFocusOnButton("exit");
        this.getTreeManager().setButtonLabel("exit", wbResource.getString((String)"Finish-Button"));
        if (this.isLast()) {
            return WizardLeaf.EXIT_BUTTON | WizardLeaf.BACK_BUTTON;
        }
        return WizardLeaf.EXIT_BUTTON | WizardLeaf.BACK_BUTTON | WizardLeaf.NEXT_BUTTON;
    }

    public boolean isDisplayComplete() {
        return true;
    }

    protected boolean upgradeLicense() {
        String string = String.valueOf(this.jdkHome) + this.fileSep + "bin" + this.fileSep + "java";
        String string2 = "-cp " + this.installDir + this.fileSep + "lib" + this.fileSep + "appserv-rt.jar" + " " + "-Dcom.sun.aas.configRoot=" + this.configDir;
        String string3 = "com.iplanet.ias.license.LicenseManager";
        String string4 = this.isGUIInstall ? this.licenseKeyField.getText().trim() : this.licenseKey;
        String string5 = String.valueOf(string) + " " + string2 + " " + string3 + " " + string4;
        ProcessExecutor processExecutor = new ProcessExecutor(string5, 600L);
        boolean bl = true;
        try {
            processExecutor.execute();
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }
}

