/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.installer.dialogs;

import com.iplanet.ias.installer.dialogs.RootFrame;
import com.iplanet.ias.installer.utilities.LinuxRoutines;
import com.iplanet.ias.installer.utilities.SolarisRoutines;
import com.iplanet.ias.installer.utilities.ValidateOS;
import com.iplanet.install.sobj.wbServerObject;
import com.iplanet.install.util.QandA;
import com.iplanet.install.util.wbResource;
import com.sun.wizards.awt.FlowLabel;
import com.sun.wizards.core.Route;
import com.sun.wizards.core.TTYDisplay;
import com.sun.wizards.core.WizardState;
import com.sun.wizards.core.WizardTreeManager;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;

public class JDKCheckPanel
extends RootFrame
implements ItemListener,
ActionListener {
    private transient TextField jdkpath;
    private transient Checkbox useBundled;
    private transient Checkbox usepreInstalled;
    protected Button browseButton = null;
    private boolean installJDK;
    private boolean installable;
    private boolean upgradable;
    private boolean preinstalled;
    private Cursor oldCursor = null;
    private String jdkdirectory;
    private String jdkinputDirectory;
    private String jdkenvDir;
    private String installDir;
    private String installType;
    private String jdkinstallType;
    private String jdkRpmLocation;
    static Object nLock = new Object();
    static InputStream eStream = null;
    static BufferedReader err = null;

    public JDKCheckPanel() {
    }

    public JDKCheckPanel(WizardState wizardState, String string) {
        super(wizardState, string);
    }

    public JDKCheckPanel(String string, Route route, WizardTreeManager wizardTreeManager) {
        super(string, route, wizardTreeManager);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.browseButton && !this.installJDK) {
            this.browseButtonPressed(this.jdkpath);
        }
    }

    public void addCriticalStateKeys(Vector vector) {
        super.addCriticalStateKeys(vector);
        vector.addElement("USE_BUNDLED_JDK");
        vector.addElement("JDK_LOCATION");
        vector.addElement("JDK_INSTALLTYPE");
    }

    public void addRuntimeResources(Vector vector) {
        super.addRuntimeResources(vector);
        vector.addElement("com.iplanet.install.sobj.wbServerObject");
        vector.addElement("com.iplanet.install.util.wbResource");
        vector.addElement("com.iplanet.ias.installer.dialogs.JDKCheckPanel");
        vector.addElement("com.iplanet.ias.installer.utilities.ValidateOS");
        vector.addElement("com.iplanet.ias.installer.utilities.IORoutines");
        vector.addElement("com.iplanet.ias.installer.utilities.LinuxRoutines");
        vector.addElement("com.iplanet.ias.installer.utilities.SolarisRoutines");
        vector.addElement("com.sun.wizards.awt.VerticalLayout");
    }

    private void addjdkpath(Panel panel) {
        this.jdkpath = new TextField();
        this.jdkpath.setColumns(30);
        this.jdkpath.setEditable(false);
        this.addCompToPanel(0, 44, new Insets(0, 0, 0, 0), 17, panel, this.jdkpath);
        this.browseButton = new Button("Browse...");
        this.browseButton.addActionListener(this);
        this.browseButton.setEnabled(false);
        this.addCompToPanel(9, 44, new Insets(0, 10, 0, 0), 17, panel, this.browseButton);
    }

    private void addradiogroup(Panel panel) {
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.useBundled = new Checkbox(wbResource.getString((String)(String.valueOf(this.getName()) + "-UsebundledText")), checkboxGroup, true);
        this.addCompToPanel(0, 29, new Insets(0, 0, 0, 0), 17, panel, this.useBundled);
        this.useBundled.addItemListener(this);
        this.usepreInstalled = new Checkbox(wbResource.getString((String)(String.valueOf(this.getName()) + "-UsepreInstalledText")), checkboxGroup, false);
        this.addCompToPanel(0, 37, new Insets(0, 0, 0, 0), 17, panel, this.usepreInstalled);
        this.usepreInstalled.addItemListener(this);
    }

    public void beginDisplay() {
        super.beginDisplay();
        if (!this.installType.equals("GUI")) {
            return;
        }
        if (System.getProperty("os.name").indexOf("SunOS") != -1) {
            this.validateSolarisPackages();
            this.oldCursor = this.getTreeManager().getWizardFrame().getCursor();
            this.useBundled.setEnabled(true);
            this.setValue("JDK_INSTALLTYPE", "CANNOTUPGRADE");
            if (this.jdkinstallType.equals("PREINSTALLED")) {
                this.useBundled.setEnabled(false);
                this.usepreInstalled.setState(true);
                this.useBundled.setState(false);
                this.jdkpath.setEditable(true);
                this.browseButton.setEnabled(true);
                this.jdkpath.setText("/usr/j2se");
                this.jdkpath.requestFocus();
                this.installJDK = false;
            }
        }
        if (System.getProperty("os.name").indexOf("Linux") != -1) {
            this.validateLinuxRpm();
            this.oldCursor = this.getTreeManager().getWizardFrame().getCursor();
            this.useBundled.setEnabled(true);
            this.setValue("JDK_INSTALLTYPE", "CANNOTUPGRADE");
            if (this.jdkinstallType.equals("PREINSTALLED")) {
                this.useBundled.setEnabled(false);
                this.usepreInstalled.setState(true);
                this.useBundled.setState(false);
                this.jdkpath.setEditable(true);
                this.browseButton.setEnabled(true);
                this.jdkpath.setText(this.jdkRpmLocation);
                this.jdkpath.requestFocus();
                this.installJDK = false;
            }
        }
    }

    public void changecursorShape(String string) {
        if (!this.installType.equals("GUI")) {
            return;
        }
        if (string.equals("NORMAL")) {
            this.getTreeManager().getWizardFrame().setCursor(this.oldCursor);
        } else {
            this.getTreeManager().getWizardFrame().setCursor(new Cursor(3));
        }
    }

    public void consoleInteraction() {
        String string;
        TTYDisplay.showText((String)wbResource.getString((String)(String.valueOf(this.getName()) + "-Gui-HeaderText")));
        this.installJDK = false;
        boolean bl = false;
        String string2 = "1";
        while (!bl) {
            TTYDisplay.showNewline();
            TTYDisplay.showText((String)("1. " + wbResource.getString((String)(String.valueOf(this.getName()) + "-UsebundledText"))));
            TTYDisplay.showText((String)("2. " + wbResource.getString((String)(String.valueOf(this.getName()) + "-UsepreInstalledText"))));
            TTYDisplay.showText((String)("3. " + wbResource.getString((String)(String.valueOf(this.getName()) + "-Exit"))));
            TTYDisplay.showNewline();
            string = TTYDisplay.queryValue((String)wbResource.getString((String)(String.valueOf(this.getName()) + "-AskOption")), (String)string2, (String)"");
            TTYDisplay.showNewline();
            if (string != null && string.equals(TTYDisplay.backOption)) {
                this.getTreeManager().backButtonPressed();
                bl = true;
                return;
            }
            string2 = string;
            if (string2.trim().equals("1") || string2.trim().equals("2") || string2.trim().equals("3")) {
                bl = true;
                continue;
            }
            TTYDisplay.showText((String)wbResource.getString((String)(String.valueOf(this.getName()) + "-InvalidOptionMsg")));
        }
        if (string2.trim().equals("3")) {
            this.getTreeManager().exit(0);
        }
        if (string2.trim().equals("1")) {
            if (System.getProperty("os.name").indexOf("Linux") != -1) {
                if (this.jdkinstallType != "PREINSTALLED") {
                    this.installJDK = true;
                } else {
                    TTYDisplay.showText((String)wbResource.getString((String)(String.valueOf(this.getName()) + "-preinstalledjdkmsg-Text")));
                }
            } else {
                this.installJDK = true;
            }
        }
        if (string2.trim().equals("2")) {
            this.installJDK = false;
            bl = false;
            string = " ";
            while (!bl) {
                string = System.getProperty("os.name").indexOf("Linux") != -1 ? TTYDisplay.queryValue((String)wbResource.getString((String)(String.valueOf(this.getName()) + "-AskJDKPath-LinuxText")), (String)this.jdkdirectory, (String)"") : TTYDisplay.queryValue((String)wbResource.getString((String)(String.valueOf(this.getName()) + "-AskJDKPath")), (String)this.jdkdirectory, (String)"");
                if (string.trim().length() == 0) {
                    TTYDisplay.showText((String)wbResource.getString((String)(String.valueOf(this.getName()) + "-JDKPathNullMsg")));
                    continue;
                }
                bl = true;
            }
            if (string.equals(TTYDisplay.backOption)) {
                this.getTreeManager().backButtonPressed();
                return;
            }
            this.jdkdirectory = string;
        }
    }

    public void createUI() {
        this.installJDK = true;
        super.createUI();
        if (System.getProperty("os.name").indexOf("SunOS") != -1) {
            this.validateSolarisPackages();
        }
        if (System.getProperty("os.name").indexOf("Linux") != -1) {
            this.validateLinuxRpm();
        }
        if (!this.installType.equals("GUI")) {
            return;
        }
        Panel panel = new Panel(new FlowLayout());
        FlowLabel flowLabel = System.getProperty("os.name").indexOf("Linux") != -1 ? new FlowLabel(wbResource.getString((String)(String.valueOf(this.getName()) + "-ConsoleInteraction1-LinuxText"))) : new FlowLabel(wbResource.getString((String)(String.valueOf(this.getName()) + "-ConsoleInteraction1")));
        panel.add((Component)flowLabel);
        Panel panel2 = new Panel(new GridBagLayout());
        panel.add(panel2);
        this.addradiogroup(panel2);
        this.addjdkpath(panel2);
        ((Container)((Object)this)).add(panel);
    }

    public static String getJDKVersion(String string) {
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        try {
            process = runtime.exec(String.valueOf(string) + " -version");
            process.waitFor();
            if (process.exitValue() != 0) {
                return "0";
            }
        }
        catch (Exception exception) {
            System.out.println("Error in running java");
            return "0";
        }
        Object object = nLock;
        synchronized (object) {
            eStream = process.getErrorStream();
            err = new BufferedReader(new InputStreamReader(eStream));
        }
        try {
            object = err.readLine();
            return ((String)object).substring(((String)object).indexOf("\"") + 1, ((String)object).length() - 1);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "0";
        }
    }

    public boolean isDisplayComplete() {
        String string = "/bin/java";
        WizardTreeManager wizardTreeManager = this.getTreeManager();
        this.resetSelectedComponent();
        if (this.installType.equals("GUI")) {
            this.jdkinputDirectory = this.jdkpath.getText();
        }
        if (this.installType.equals("SILENT")) {
            this.readStatefile();
        }
        if (this.installType.equals("COMMANDLINE")) {
            this.jdkinputDirectory = this.jdkdirectory;
        }
        this.installDir = (String)this.getValue("currentInstallDirectory");
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.setValue("JDK_INSTALLTYPE", this.jdkinstallType);
        ValidateOS.init();
        if (ValidateOS.OSName.indexOf("Windows") != -1) {
            bl = true;
        }
        if (ValidateOS.OSName.indexOf("SunOS") != -1) {
            bl2 = true;
        }
        if (ValidateOS.OSName.indexOf("Linux") != -1) {
            bl3 = true;
        }
        if (this.installJDK) {
            this.setValue("USE_BUNDLED_JDK", "TRUE");
            if (bl2 || bl3) {
                if (bl3) {
                    this.setValue("JDK_LOCATION", "/usr/java/j2sdk1.4.1");
                    this.validateLinuxRpm();
                } else {
                    this.setValue("JDK_LOCATION", "/usr/j2se");
                    this.validateSolarisPackages();
                }
                this.setValue("JDK_INSTALLTYPE", this.jdkinstallType);
                if (this.jdkinstallType.equals("PREINSTALLED")) {
                    this.removeComponentSelected(wbResource.getString((String)(String.valueOf(this.getName()) + "-JDKComponentName")));
                    return true;
                }
                if (this.jdkinstallType.equals("CANNOTUPGRADE")) {
                    if (bl3) {
                        if (this.installType.equals("GUI")) {
                            QandA.oneButton((WizardTreeManager)wizardTreeManager, (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-Error")), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-Gui-cannotupgrade-LinuxText")), (String)wbResource.getString((String)"Common-OK"));
                        } else {
                            System.out.println(wbResource.getString((String)(String.valueOf(this.getName()) + "-cui-cannotupgrade-LinuxText")));
                        }
                    } else if (this.installType.equals("GUI")) {
                        QandA.oneButton((WizardTreeManager)wizardTreeManager, (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-Error")), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-Gui-cannotupgrade-Text")), (String)wbResource.getString((String)"Common-OK"));
                    } else {
                        System.out.println(wbResource.getString((String)(String.valueOf(this.getName()) + "-cui-cannotupgrade-Text")));
                    }
                    if (this.installType.equals("SILENT")) {
                        this.getTreeManager().exit(48);
                    }
                    return false;
                }
                if (this.jdkinstallType.equals("UPGRADABLE")) {
                    if (this.installType.equals("SILENT")) {
                        System.out.println(wbResource.getString((String)(String.valueOf(this.getName()) + "-silent-cannotupgrade-Text")));
                        this.getTreeManager().exit(49);
                    }
                    if (this.installType.equals("GUI")) {
                        int n = 0;
                        if (bl2) {
                            n = QandA.twoButtons((WizardTreeManager)this.getTreeManager(), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-upgrade-Title")), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-Gui-askupgrade-Text")), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-upgrade")), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-cancel")));
                        } else if (bl3) {
                            n = QandA.twoButtons((WizardTreeManager)this.getTreeManager(), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-upgrade-Title")), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-Gui-askupgrade-LinuxText")), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-upgrade")), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-cancel")));
                        }
                        return n == 1;
                    }
                    String string2 = "1";
                    boolean bl4 = false;
                    while (!bl4) {
                        TTYDisplay.showNewline();
                        if (bl2) {
                            TTYDisplay.showText((String)wbResource.getString((String)(String.valueOf(this.getName()) + "-cui-askupgrade-Text")));
                        } else if (bl3) {
                            TTYDisplay.showText((String)wbResource.getString((String)(String.valueOf(this.getName()) + "-cui-askupgrade-LinuxText")));
                        }
                        TTYDisplay.showText((String)("1. " + wbResource.getString((String)(String.valueOf(this.getName()) + "-upgrade"))));
                        TTYDisplay.showText((String)("2. " + wbResource.getString((String)(String.valueOf(this.getName()) + "-cancel"))));
                        TTYDisplay.showNewline();
                        String string3 = TTYDisplay.queryValue((String)wbResource.getString((String)(String.valueOf(this.getName()) + "-AskOption")), (String)string2, (String)"");
                        TTYDisplay.showNewline();
                        if (string3 != null && string3.equals(TTYDisplay.backOption)) {
                            this.getTreeManager().backButtonPressed();
                            bl4 = true;
                            return false;
                        }
                        string2 = string3;
                        if (string2.trim().equals("1") || string2.trim().equals("2")) {
                            bl4 = true;
                            continue;
                        }
                        TTYDisplay.showText((String)wbResource.getString((String)(String.valueOf(this.getName()) + "-InvalidUpgradeOptionMsg")));
                    }
                    return string2.trim().equals("1");
                }
            }
            return true;
        }
        if (!this.installJDK) {
            this.setValue("USE_BUNDLED_JDK", "FALSE");
            if (this.jdkinputDirectory == null || this.jdkinputDirectory.trim().length() == 0) {
                if (bl3) {
                    if (wizardTreeManager.getWizardState().hasGUI()) {
                        QandA.oneButton((WizardTreeManager)wizardTreeManager, (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-Error")), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-invalidjdkpathdetail-LinuxText")), (String)wbResource.getString((String)"Common-OK"));
                    } else {
                        System.out.println(wbResource.getString((String)(String.valueOf(this.getName()) + "-invalidjdkpathdetail-LinuxText")));
                    }
                } else if (wizardTreeManager.getWizardState().hasGUI()) {
                    QandA.oneButton((WizardTreeManager)wizardTreeManager, (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-Error")), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-invalidjdkpathdetail-Text")), (String)wbResource.getString((String)"Common-OK"));
                } else {
                    System.out.println(wbResource.getString((String)(String.valueOf(this.getName()) + "-invalidjdkpathdetail-Text")));
                }
                if (this.installType.equals("SILENT")) {
                    this.getTreeManager().exit(3);
                }
                return false;
            }
            if (bl2 || bl3) {
                string = this.jdkinputDirectory.endsWith("/") ? "bin/java" : "/bin/java";
            }
            if (bl) {
                string = this.jdkinputDirectory.endsWith("\\") ? "bin\\java.exe" : "\\bin\\java.exe";
            }
            if (!this.isJDKAvailable(String.valueOf(this.jdkinputDirectory.trim()) + string)) {
                if (bl3) {
                    if (wizardTreeManager.getWizardState().hasGUI()) {
                        QandA.oneButton((WizardTreeManager)wizardTreeManager, (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-Error")), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-invalidjdkpathdetail-LinuxText")), (String)wbResource.getString((String)"Common-OK"));
                    } else {
                        System.out.println(wbResource.getString((String)(String.valueOf(this.getName()) + "-invalidjdkpathdetail-LinuxText")));
                    }
                } else if (wizardTreeManager.getWizardState().hasGUI()) {
                    QandA.oneButton((WizardTreeManager)wizardTreeManager, (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-Error")), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-invalidjdkpathdetail-Text")), (String)wbResource.getString((String)"Common-OK"));
                } else {
                    System.out.println(wbResource.getString((String)(String.valueOf(this.getName()) + "-invalidjdkpathdetail-Text")));
                }
                if (this.installType.equals("SILENT")) {
                    this.getTreeManager().exit(4);
                }
                return false;
            }
            if (JDKCheckPanel.getJDKVersion(String.valueOf(this.jdkinputDirectory.trim()) + string).compareTo(wbResource.getString((String)(String.valueOf(this.getName()) + "-minJDKVersionToCheck"))) < 0) {
                if (wizardTreeManager.getWizardState().hasGUI()) {
                    QandA.oneButton((WizardTreeManager)wizardTreeManager, (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-Error")), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-Gui-invalidversion-Text")), (String)wbResource.getString((String)"Common-OK"));
                } else {
                    System.out.println(wbResource.getString((String)(String.valueOf(this.getName()) + "-cui-invalidversion-Text")));
                }
                if (this.installType.equals("SILENT")) {
                    this.getTreeManager().exit(4);
                }
                return false;
            }
            this.removeComponentSelected(wbResource.getString((String)(String.valueOf(this.getName()) + "-JDKComponentName")));
        }
        this.setValue("JDK_LOCATION", this.jdkinputDirectory.trim());
        return true;
    }

    public boolean isJDKAvailable(String string) {
        wbServerObject wbServerObject2 = new wbServerObject();
        return wbServerObject2.verifyEntity(3, string);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getItem();
        if (object != null && object == this.useBundled.getLabel()) {
            this.installJDK = true;
            this.jdkpath.setEditable(false);
            this.jdkpath.setText(null);
            this.browseButton.setEnabled(false);
        }
        if (object != null && object == this.usepreInstalled.getLabel()) {
            this.installJDK = false;
            this.jdkpath.setEditable(true);
            this.browseButton.setEnabled(true);
            this.jdkpath.requestFocus();
        }
    }

    public void readStatefile() {
        String string = (String)this.getValue("USE_BUNDLED_JDK");
        if (string.equals("TRUE")) {
            this.installJDK = System.getProperty("os.name").indexOf("Linux") != -1 ? this.jdkinstallType != "PREINSTALLED" : true;
        } else {
            this.installJDK = false;
            this.jdkinputDirectory = (String)this.getValue("JDK_LOCATION");
        }
    }

    protected void removeComponentSelected(String string) {
        WizardTreeManager wizardTreeManager = this.getTreeManager();
        Vector vector = (Vector)wizardTreeManager.getWizardState().getData("selectedComponents");
        int n = 0;
        while (n < vector.size()) {
            String string2 = (String)vector.get(n);
            if (string2.equalsIgnoreCase(string)) {
                vector.remove(n);
            }
            ++n;
        }
        wizardTreeManager.getWizardState().setData("selectedComponents", (Object)vector);
    }

    protected void resetSelectedComponent() {
        String string = wbResource.getString((String)(String.valueOf(this.getName()) + "-JDKComponentName"));
        WizardTreeManager wizardTreeManager = this.getTreeManager();
        Vector vector = (Vector)wizardTreeManager.getWizardState().getData("selectedComponents");
        boolean bl = false;
        int n = 0;
        while (n < vector.size()) {
            String string2 = (String)vector.get(n);
            if (string2.equalsIgnoreCase(string)) {
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            vector.add(0, string);
        }
        wizardTreeManager.getWizardState().setData("selectedComponents", (Object)vector);
    }

    public boolean skip() {
        this.installType = this.getTreeManager().getWizardState().hasGUI() ? "GUI" : "COMMANDLINE";
        if (System.getProperty("wizard.statefile") != null) {
            this.installType = "SILENT";
        }
        return false;
    }

    public void validateLinuxRpm() {
        this.installable = false;
        this.upgradable = true;
        this.preinstalled = false;
        this.jdkinstallType = "CANNOTUPGRADE";
        this.changecursorShape("BUSY");
        String string = LinuxRoutines.findRpmVersion((String)"j2sdk");
        if (string != null) {
            if (string.indexOf(wbResource.getString((String)(String.valueOf(this.getName()) + "-JDKVersionToCheck"))) != -1) {
                this.jdkinstallType = "PREINSTALLED";
                this.jdkRpmLocation = LinuxRoutines.findJ2sdkRpmLocation((String)"j2sdk");
                this.changecursorShape("NORMAL");
                return;
            }
            if ((string.indexOf("1.3") != -1 || string.indexOf("1.4") != -1) && string.compareTo(wbResource.getString((String)(String.valueOf(this.getName()) + "-JDKVersionToCheck"))) <= 0) {
                this.jdkinstallType = "UPGRADABLE";
                this.changecursorShape("NORMAL");
                return;
            }
        } else {
            string = "1.4.1";
            this.jdkinstallType = "CLEANINSTALL";
        }
        this.changecursorShape("NORMAL");
    }

    public void validateSolarisPackages() {
        boolean bl = false;
        this.installable = false;
        this.upgradable = true;
        this.preinstalled = false;
        int n = 0;
        this.jdkinstallType = "CLEANINSTALL";
        this.changecursorShape("BUSY");
        String[] stringArray = new String[]{"SUNWj3rt", "SUNWj3dev", "SUNWj3dmo", "SUNWj3man"};
        SolarisRoutines solarisRoutines = new SolarisRoutines();
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (SolarisRoutines.findPackage((String)stringArray[n2])) {
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            if (this.isJDKAvailable("/usr/j2se/bin/java")) {
                this.jdkinstallType = "CANNOTUPGRADE";
            } else {
                this.jdkinstallType = "CLEANINSTALL";
                this.changecursorShape("NORMAL");
                return;
            }
        }
        if (this.isJDKAvailable("/usr/j2se/bin/java")) {
            String string = JDKCheckPanel.getJDKVersion("/usr/j2se/bin/java");
            if (string.indexOf(wbResource.getString((String)(String.valueOf(this.getName()) + "-JDKVersionToCheck"))) != -1) {
                this.jdkinstallType = n == 4 ? "PREINSTALLED" : "UPGRADABLE";
                this.changecursorShape("NORMAL");
                return;
            }
            if ((string.indexOf("1.3") != -1 || string.indexOf("1.4") != -1) && string.compareTo(wbResource.getString((String)(String.valueOf(this.getName()) + "-JDKVersionToCheck"))) <= 0) {
                this.jdkinstallType = "UPGRADABLE";
                this.changecursorShape("NORMAL");
                return;
            }
        }
        this.changecursorShape("NORMAL");
    }
}

