/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.installer.core;

import com.iplanet.ias.admin.common.domains.registry.DomainRegistryException;
import com.iplanet.ias.installer.core.ServerConfig;
import com.iplanet.ias.installer.core.installConfig;
import java.net.InetAddress;

public class InstallConfigTest {
    private ServerConfig mServerConfig;
    public static final String ADMIN_ID = "admin-server";
    public static final String FILE_SEP = "/";
    private static final String WIN_OS = "Windows";
    private boolean isWindows = false;

    private void execute(ServerConfig serverConfig) throws Exception {
        installConfig installConfig2 = new installConfig();
        String string = null;
        string = serverConfig.serverID.equals(ADMIN_ID) ? installConfig2.createAdminInstance(serverConfig) : installConfig2.createServerInstance(serverConfig);
        if (string != null) {
            throw new Exception("Could not create the instance...");
        }
    }

    private void initServerConfig() throws Exception {
        this.mServerConfig = new ServerConfig();
        this.mServerConfig.serverRoot = System.getProperty("com.sun.aas.installRoot");
        this.mServerConfig.domainRoot = System.getProperty("com.sun.aas.instanceRoot");
        this.mServerConfig.serverName = InetAddress.getLocalHost().getHostName();
        if (System.getProperty("os.name").indexOf(WIN_OS) != -1) {
            this.isWindows = true;
            this.mServerConfig.serverUser = System.getProperty("user.name");
        }
        this.mServerConfig.javaHome = System.getProperty("java.home");
    }

    public static void main(String[] stringArray) throws Exception {
        InstallConfigTest installConfigTest = new InstallConfigTest();
        if (stringArray.length == 0) {
            installConfigTest.test();
        } else if (stringArray.length != 3) {
            installConfigTest.showUsage();
        } else {
            String string = null;
            String string2 = null;
            int n = -1;
            System.out.println("Creating admin instance");
            string2 = stringArray[0];
            n = Integer.parseInt(string2);
            installConfigTest.testAdmin(n);
            System.out.println("Creating non-admin instance");
            string = stringArray[1];
            string2 = stringArray[2];
            n = Integer.parseInt(string2);
            installConfigTest.testInstance(string, n);
        }
    }

    private void showUsage() {
        System.out.println("Usage: java com.iplanet.ias.installer.core.InstallConfigTest admin-port instanceid httport");
        System.out.println("This creates the admin and non-admin instances at once");
    }

    private void test() throws DomainRegistryException {
        boolean bl = false;
        Object var2_2 = null;
        String string = System.getProperty("com.sun.aas.instanceRoot");
        String string2 = System.getProperty("com.sun.aas.installRoot");
        String string3 = String.valueOf(string) + System.getProperty("file.separator") + "docs";
        installConfig installConfig2 = new installConfig();
        String string4 = null;
        Object var8_8 = null;
        Object var9_9 = null;
        Object var10_10 = null;
        Object var11_11 = null;
        ServerConfig serverConfig = new ServerConfig();
        serverConfig.serverID = "pkota";
        serverConfig.serverUser = "niru";
        serverConfig.serverName = "pkota";
        serverConfig.javaHome = System.getProperty("jdk.home");
        serverConfig.imqBin = String.valueOf(string2) + "../imq/bin";
        serverConfig.imqLib = String.valueOf(string2) + "../imq/lib";
        serverConfig.domainRoot = string;
        serverConfig.serverRoot = string2;
        serverConfig.adminName = "admin";
        serverConfig.domainName = "domain1";
        serverConfig.adminPasswd = "adminadmin";
        serverConfig.docRoot = string3;
        serverConfig.jmsUser = "admin";
        serverConfig.jmsPasswd = "adminadmin";
        serverConfig.webServicesLib = String.valueOf(string2) + "../share/lib";
        serverConfig.perlRoot = String.valueOf(string2) + "/lib/perl";
        serverConfig.jmsPort = 7676;
        serverConfig.configRoot = String.valueOf(string2) + System.getProperty("file.separator") + "config";
        serverConfig.icuLib = this.isWindows ? String.valueOf(string2) + System.getProperty("file.separator") + "bin" : String.valueOf(string2) + System.getProperty("file.separator") + "lib";
        serverConfig.defaultLocale = "en_US";
        serverConfig.serverPort = 8888;
        string4 = installConfig2.createDomain(serverConfig);
        System.out.println("createAdminInstance done \n" + string4 + "\n \n \n \n");
        serverConfig.serverPort = 8080;
        string4 = installConfig2.createServerInstance(serverConfig);
        System.out.println("createServerInstance done \n" + string4 + "errormsg" + serverConfig.errorMsg);
    }

    private void testAdmin(int n) throws Exception {
        this.initServerConfig();
        this.mServerConfig.serverID = ADMIN_ID;
        this.mServerConfig.serverPort = n;
        this.mServerConfig.adminName = System.getProperty("user.name");
        this.mServerConfig.adminPasswd = System.getProperty("user.name");
        this.mServerConfig.docRoot = String.valueOf(this.mServerConfig.domainRoot) + FILE_SEP + ADMIN_ID + FILE_SEP + "docroot";
        this.mServerConfig.configRoot = String.valueOf(System.getProperty("INS_ROOT")) + System.getProperty("file.separator") + "config";
        this.execute(this.mServerConfig);
    }

    private void testInstance(String string, int n) throws Exception {
        this.initServerConfig();
        this.mServerConfig.serverID = string;
        this.mServerConfig.serverPort = n;
        this.mServerConfig.docRoot = String.valueOf(this.mServerConfig.domainRoot) + FILE_SEP + string + FILE_SEP + "docroot";
        this.execute(this.mServerConfig);
    }
}

