/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment.backend;

import com.iplanet.ias.deployment.backend.IASDeploymentException;
import com.iplanet.ias.util.i18n.StringManager;
import com.iplanet.ias.util.io.FileUtils;
import com.iplanet.ias.util.zip.ZipFileException;
import com.iplanet.ias.util.zip.ZipItem;
import com.iplanet.ias.util.zip.ZipWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public abstract class JarMaker {
    private String jarName;
    protected String rootDir;
    protected ZipItem[] extraFiles = null;
    private static final String META_INF = "META-INF";
    private static final String META_INF_SEP = "META-INF/";
    private static StringManager localStrings = StringManager.getManager(class$com$iplanet$ias$deployment$backend$JarMaker == null ? (class$com$iplanet$ias$deployment$backend$JarMaker = JarMaker.class$("com.iplanet.ias.deployment.backend.JarMaker")) : class$com$iplanet$ias$deployment$backend$JarMaker);
    static /* synthetic */ Class class$com$iplanet$ias$deployment$backend$JarMaker;

    protected abstract void addClassFiles(List var1) throws IASDeploymentException;

    public JarMaker(File file, File file2, ZipItem[] zipItemArray) throws IASDeploymentException {
        this.jarName = file.getPath();
        this.rootDir = file2.getPath();
        this.extraFiles = zipItemArray;
    }

    protected void create() throws IASDeploymentException {
        this.verify();
        ArrayList<ZipItem> arrayList = new ArrayList<ZipItem>();
        if (this.extraFiles != null) {
            int n = 0;
            while (n < this.extraFiles.length) {
                arrayList.add(this.extraFiles[n]);
                ++n;
            }
        }
        this.addMetaFiles(arrayList);
        this.addClassFiles(arrayList);
        ZipItem[] zipItemArray = new ZipItem[arrayList.size()];
        zipItemArray = arrayList.toArray(zipItemArray);
        try {
            ZipWriter zipWriter = new ZipWriter(this.jarName, this.rootDir, zipItemArray);
            zipWriter.safeWrite();
        }
        catch (ZipFileException zipFileException) {
            String string = localStrings.getString("enterprise.deployment.backend.error_writing_ejb_jar_with_meta_files", zipFileException);
            throw new IASDeploymentException(string, zipFileException);
        }
    }

    private void addMetaFiles(List list) throws IASDeploymentException {
        File file = new File(this.rootDir, META_INF);
        if (!FileUtils.safeIsDirectory(file)) {
            String string = localStrings.getString("enterprise.deployment.backend.no_meta_inf_under_module_root");
            throw new IASDeploymentException(string);
        }
        String[] stringArray = file.list();
        if (stringArray.length <= 0) {
            String string = localStrings.getString("enterprise.deployment.backend.no_files_in_meta_inf");
            throw new IASDeploymentException(string);
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = META_INF_SEP + stringArray[n];
            File file2 = new File(file, stringArray[n]);
            try {
                list.add(new ZipItem(file2, string));
            }
            catch (ZipFileException zipFileException) {
                String string2 = localStrings.getString("enterprise.deployment.backend.error_creating_zipitem", string);
                throw new IASDeploymentException(string2, zipFileException);
            }
            ++n;
        }
    }

    private void verify() throws IASDeploymentException {
        if (!FileUtils.safeIsDirectory(this.rootDir)) {
            String string = localStrings.getString("enterprise.deployment.backend.directory_does_exist", this.rootDir);
            throw new IASDeploymentException(string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

