/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment.backend;

import com.iplanet.ias.deployment.backend.IASDeploymentException;
import com.iplanet.ias.util.io.FileUtils;
import java.io.CharArrayWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jasper.JspC;

class JSPCompiler {
    private File inWebDir;
    private File outWebDir;
    private String classpath = null;

    JSPCompiler(File file, File file2) {
        this.inWebDir = file;
        this.outWebDir = file2;
    }

    JSPCompiler(File file, File file2, List list) {
        this.inWebDir = file;
        this.outWebDir = file2;
        this.setClasspath(list);
    }

    void compile() throws IASDeploymentException {
        this.verify();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.classpath != null) {
            arrayList.add("-classpath");
            arrayList.add(this.classpath);
        }
        arrayList.add("-d");
        arrayList.add(this.outWebDir.getAbsolutePath());
        arrayList.add("-genclass");
        arrayList.add("-webapp");
        arrayList.add(this.inWebDir.getAbsolutePath());
        String[] stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        int n = 0;
        try {
            JspC jspC = new JspC(stringArray, charArrayWriter);
            n = jspC.parseFiles();
        }
        catch (Throwable throwable) {
            throw new IASDeploymentException("JSP Compilation Error: " + throwable, throwable);
        }
        if (n > 0) {
            throw new IASDeploymentException("JSP compiler reported " + n + " errors: " + charArrayWriter.toString());
        }
    }

    private void verify() throws IASDeploymentException {
        if (!FileUtils.safeIsDirectory(this.inWebDir)) {
            throw new IASDeploymentException("inWebDir is not a directory: " + this.inWebDir);
        }
        if (!FileUtils.safeIsDirectory(this.outWebDir)) {
            this.outWebDir.mkdirs();
            if (!FileUtils.safeIsDirectory(this.outWebDir)) {
                throw new IASDeploymentException("outWebDir is not a directory, and it can't be created: " + this.outWebDir);
            }
        }
    }

    private void setClasspath(List list) {
        if (list == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(File.pathSeparatorChar);
            }
            stringBuffer.append(string);
        }
        this.classpath = stringBuffer.toString();
        if (this.classpath.length() <= 0) {
            this.classpath = null;
        }
    }
}

