/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment.backend;

import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.deployment.AppConfigEnvImpl;
import com.iplanet.ias.deployment.AppConfigException;
import com.iplanet.ias.deployment.ApplicationXmlReader;
import com.iplanet.ias.deployment.EjbBundleXmlReader;
import com.iplanet.ias.deployment.EjbModuleConfigEnv;
import com.iplanet.ias.deployment.backend.DeploymentLogger;
import com.iplanet.ias.deployment.backend.DeploymentRequest;
import com.iplanet.ias.deployment.backend.DeploymentUtils;
import com.iplanet.ias.deployment.backend.EjbcContextImpl;
import com.iplanet.ias.deployment.backend.IASDeploymentException;
import com.iplanet.ias.ejb.codegen.IASEJBC;
import com.iplanet.ias.ejb.codegen.IASEJBCTimes;
import com.iplanet.ias.instance.AppsManager;
import com.iplanet.ias.instance.BaseManager;
import com.iplanet.ias.instance.EjbModulesManager;
import com.iplanet.ias.instance.UniqueIdGenerator;
import com.iplanet.ias.loader.EJBClassLoader;
import com.iplanet.ias.loader.EJBClassPathUtils;
import com.iplanet.ias.util.StringUtils;
import com.iplanet.ias.util.i18n.StringManager;
import com.iplanet.ias.util.io.FileUtils;
import com.iplanet.ias.util.zip.ZipItem;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.security.acl.RoleMapper;
import com.sun.enterprise.tools.deployment.backend.DeploymentSession;
import com.sun.enterprise.tools.deployment.backend.DeploymentSessionImpl;
import com.sun.enterprise.tools.verifier.ResultsReport;
import com.sun.enterprise.tools.verifier.Verifier;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EJBCompiler {
    private String name;
    private File clientDstJar;
    private DeploymentSession session;
    private EjbModulesManager moduleManager;
    private AppsManager appManager;
    private DeploymentRequest request;
    private EjbcContextImpl ejbcContext;
    private static final Logger _logger;
    private static StringManager localStrings;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$iplanet$ias$deployment$backend$EJBCompiler;

    public EJBCompiler(String string, File file, File file2, File file3, File file4, File file5, BaseManager baseManager, DeploymentRequest deploymentRequest, IASEJBCTimes iASEJBCTimes) throws IASDeploymentException {
        if (!$assertionsDisabled && !StringUtils.ok((String)string)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !FileUtils.safeIsDirectory(file)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !FileUtils.safeIsDirectory(file2)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !FileUtils.safeIsDirectory(file4)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !FileUtils.safeIsDirectory(file5)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || file3 != null && file3.getPath().length() > 0)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && baseManager == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && deploymentRequest == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && iASEJBCTimes == null) {
            throw new AssertionError();
        }
        try {
            this.name = string;
            this.clientDstJar = file3;
            this.request = deploymentRequest;
            this.session = new DeploymentSessionImpl();
            this.ejbcContext = new EjbcContextImpl();
            this.ejbcContext.setSrcDir(file);
            this.ejbcContext.setOldSrcDir(file2);
            this.ejbcContext.setStubsDir(file4);
            this.ejbcContext.setOldStubsDir(file5);
            this.ejbcContext.setTiming(iASEJBCTimes);
            this.ejbcContext.setSession(this.session);
            this.ejbcContext.setRmicOptions(baseManager.getRmicOptions());
            this.ejbcContext.setJavacOptions(baseManager.getJavacOptions());
            if (baseManager instanceof EjbModulesManager) {
                this.moduleManager = (EjbModulesManager)baseManager;
                this.appManager = null;
            } else if (baseManager instanceof AppsManager) {
                this.appManager = (AppsManager)baseManager;
                this.moduleManager = null;
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
        catch (Throwable throwable) {
            throw this.wrapException(throwable);
        }
    }

    public ZipItem[] compile() throws IASDeploymentException {
        ZipItem[] zipItemArray = null;
        try {
            if (this.request.getNoEJBC()) {
                _logger.info("**********  EJBC Skipped! ************");
                ZipItem[] zipItemArray2 = new ZipItem[]{};
                return zipItemArray2;
            }
            zipItemArray = this.appManager != null ? this.preDeployApp() : this.preDeployModule();
        }
        catch (Throwable throwable) {
            throw this.wrapException(throwable);
        }
        finally {
            if (this.request != null && this.request.amIAnAdminServer()) {
                RoleMapper roleMapper;
                Serializable serializable;
                Application application = this.ejbcContext.getDescriptor();
                if (application != null && (serializable = application.getRoleMapper()) != null) {
                    RoleMapper.removeRoleMapper(((RoleMapper)serializable).getName());
                }
                if ((serializable = (Application)this.ejbcContext.getOldDescriptor()) != null && (roleMapper = ((Application)serializable).getRoleMapper()) != null) {
                    RoleMapper.removeRoleMapper(roleMapper.getName());
                }
            }
        }
        return zipItemArray;
    }

    private ZipItem[] preDeployApp() throws Exception {
        Object object;
        String[] stringArray;
        ZipItem[] zipItemArray = null;
        List list = this.request.getParentClasspath();
        ClassLoader classLoader = this.request.getParentClassLoader();
        List list2 = EJBClassPathUtils.getEjbClasspathList(this.name, this.appManager);
        this.setEjbClasspath(list2);
        list.addAll(list2);
        EJBClassLoader eJBClassLoader = DeploymentUtils.getClassLoader(list2, classLoader, this.ejbcContext.getStubsDir());
        this.request.setEjbClassLoader(eJBClassLoader);
        this.request.setEjbClasspath(list);
        Application application = null;
        if (this.ejbcContext.isRedeploy()) {
            stringArray = this.ejbcContext.getOldSrcDir().getCanonicalPath();
            object = EJBClassPathUtils.getApplicationClassPath((String)stringArray, this.name);
            EJBClassLoader eJBClassLoader2 = DeploymentUtils.getClassLoader((List)object, classLoader, this.ejbcContext.getOldStubsDir());
            Application application2 = this.getOldAppDescriptor((String)stringArray, this.name, eJBClassLoader2);
            this.ejbcContext.setOldDescriptor(application2);
        }
        if (this.request.isVerifying()) {
            application = this.appManager.getAppDescriptor(this.name, eJBClassLoader, true, true);
            stringArray = new Verifier();
            object = stringArray.verifyEar(application, this.ejbcContext.getSrcDir().getCanonicalPath());
            int n = ((ResultsReport)object).getFailedCount();
            int n2 = ((ResultsReport)object).getWarningCount();
            int n3 = ((ResultsReport)object).getErrorCount();
            _logger.log(Level.INFO, "enterprise.deployment_verifier_result", new Object[]{String.valueOf(n), String.valueOf(n2), String.valueOf(n3)});
            if (n > 0) {
                String string = localStrings.getString("enterprise.deployment.backend.verifier_error", String.valueOf(n));
                throw new IASDeploymentException(string);
            }
        } else {
            application = this.appManager.getAppDescriptor(this.name, eJBClassLoader);
        }
        this.ejbcContext.setDescriptor(application);
        stringArray = new String[list.size()];
        stringArray = list.toArray(stringArray);
        this.ejbcContext.setClasspathUrls(stringArray);
        this.verifyContext();
        zipItemArray = IASEJBC.ejbc(this.ejbcContext);
        if (!this.session.isCancelled()) {
            object = UniqueIdGenerator.getInstance();
            long l = ((UniqueIdGenerator)object).getNextUniqueId();
            application.setUniqueId(l);
            this.appManager.saveAppDescriptor(this.name, application);
        }
        return zipItemArray;
    }

    private void setEjbClasspath(List list) {
        String[] stringArray = new String[list.size()];
        stringArray = list.toArray(stringArray);
        this.ejbcContext.setEjbClasspathUrls(stringArray);
    }

    private ZipItem[] preDeployModule() throws Exception {
        Object object;
        Object object2;
        Object object3;
        String[] stringArray;
        ZipItem[] zipItemArray = null;
        List list = this.request.getParentClasspath();
        ClassLoader classLoader = this.request.getParentClassLoader();
        List list2 = EJBClassPathUtils.getEjbModuleClasspathList(this.name, this.moduleManager);
        this.setEjbClasspath(list2);
        list.addAll(list2);
        EJBClassLoader eJBClassLoader = DeploymentUtils.getClassLoader(list2, classLoader, this.ejbcContext.getStubsDir());
        Application application = null;
        if (this.ejbcContext.isRedeploy()) {
            stringArray = this.ejbcContext.getOldSrcDir().getCanonicalPath();
            object3 = new ArrayList<String>();
            object3.add(stringArray);
            object2 = DeploymentUtils.getClassLoader(object3, classLoader, this.ejbcContext.getOldStubsDir());
            object = this.getOldModuleDescriptor((String)stringArray, this.name, (ClassLoader)object2);
            this.ejbcContext.setOldDescriptor(object);
        }
        if (this.request.isVerifying()) {
            application = this.moduleManager.getDescriptor(this.name, eJBClassLoader, true, true);
            stringArray = new Verifier();
            object3 = application.getEjbBundleDescriptors().iterator();
            while (object3.hasNext()) {
                object2 = (EjbBundleDescriptor)object3.next();
                object = stringArray.verifyStdAloneJar((EjbBundleDescriptor)object2, this.ejbcContext.getSrcDir().getCanonicalPath());
                int n = ((ResultsReport)object).getFailedCount();
                int n2 = ((ResultsReport)object).getWarningCount();
                int n3 = ((ResultsReport)object).getErrorCount();
                _logger.log(Level.INFO, "enterprise.deployment_verifier_result", new Object[]{String.valueOf(n), String.valueOf(n2), String.valueOf(n3)});
                if (n <= 0) continue;
                String string = localStrings.getString("enterprise.deployment.backend.verifier_error", String.valueOf(n));
                throw new IASDeploymentException(string);
            }
        } else {
            application = this.moduleManager.getDescriptor(this.name, eJBClassLoader);
        }
        this.ejbcContext.setDescriptor(application);
        stringArray = new String[list.size()];
        stringArray = list.toArray(stringArray);
        this.ejbcContext.setClasspathUrls(stringArray);
        this.verifyContext();
        zipItemArray = IASEJBC.ejbc(this.ejbcContext);
        if (!this.session.isCancelled()) {
            object3 = UniqueIdGenerator.getInstance();
            long l = ((UniqueIdGenerator)object3).getNextUniqueId();
            Iterator iterator = application.getEjbBundleDescriptors().iterator();
            while (iterator.hasNext()) {
                EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)iterator.next();
                ejbBundleDescriptor.setUniqueId(l);
            }
            this.moduleManager.saveDescriptor(this.name, application);
        }
        return zipItemArray;
    }

    void verifyContext() throws IASDeploymentException {
        if (this.ejbcContext.getSrcDir() == null || this.ejbcContext.getStubsDir() == null || this.ejbcContext.getDescriptor() == null || this.ejbcContext.getClasspathUrls() == null || this.ejbcContext.getRmicOptions() == null || this.ejbcContext.getJavacOptions() == null || this.ejbcContext.getTiming() == null || this.ejbcContext.getSession() == null) {
            String string = localStrings.getString("enterprise.deployment.backend.bad_ejbc_ctx");
            throw new IASDeploymentException(string);
        }
    }

    public Application getOldAppDescriptor(String string, String string2, ClassLoader classLoader) throws ConfigException, AppConfigException, IOException {
        AppConfigEnvImpl appConfigEnvImpl = new AppConfigEnvImpl(string, string2, false);
        appConfigEnvImpl.setVerifying(false);
        appConfigEnvImpl.setEjbModulesOnly(true);
        ApplicationXmlReader applicationXmlReader = new ApplicationXmlReader(appConfigEnvImpl);
        Application application = applicationXmlReader.load(classLoader);
        return application;
    }

    public Application getOldModuleDescriptor(String string, String string2, ClassLoader classLoader) throws ConfigException, AppConfigException, IOException {
        EjbModuleConfigEnv ejbModuleConfigEnv = new EjbModuleConfigEnv(string, string2, false);
        ejbModuleConfigEnv.setVerifying(false);
        Application application = EjbBundleXmlReader.loadStdAloneModule(ejbModuleConfigEnv, classLoader);
        return application;
    }

    IASDeploymentException wrapException(Throwable throwable) {
        String string = localStrings.getString("enterprise.deployment.backend.fatal_ejbc_error");
        if (throwable instanceof RemoteException) {
            string = string + localStrings.getString("enterprise.deployment.backend.ejbc_remoteexception", throwable);
        }
        return new IASDeploymentException(string, throwable);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$iplanet$ias$deployment$backend$EJBCompiler == null ? (class$com$iplanet$ias$deployment$backend$EJBCompiler = EJBCompiler.class$("com.iplanet.ias.deployment.backend.EJBCompiler")) : class$com$iplanet$ias$deployment$backend$EJBCompiler).desiredAssertionStatus();
        _logger = DeploymentLogger.get();
        localStrings = StringManager.getManager(class$com$iplanet$ias$deployment$backend$EJBCompiler == null ? (class$com$iplanet$ias$deployment$backend$EJBCompiler = EJBCompiler.class$("com.iplanet.ias.deployment.backend.EJBCompiler")) : class$com$iplanet$ias$deployment$backend$EJBCompiler);
    }
}

