/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

abstract class ArchiveInfo {
    private File rootPath;
    private File archive;
    private ArrayList relativeFileNames = new ArrayList();
    private ArrayList files = new ArrayList();

    ArchiveInfo(File file, File file2) {
        this.archive = file;
        this.rootPath = file2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("*********** Archive Info Dump ***********\n");
        stringBuffer.append("Original Archive: " + this.getArchive() + '\n');
        stringBuffer.append("Root Path:         " + this.getRootPath() + '\n');
        stringBuffer.append("Total of " + this.getFiles().size() + " files: \n\n");
        Iterator iterator = this.getFiles().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString() + "\n");
        }
        return stringBuffer.toString();
    }

    public File getRootPath() {
        return this.rootPath;
    }

    public abstract File[] getAllPaths();

    void setFiles(ArrayList arrayList) {
        this.relativeFileNames = arrayList;
        this.files = new ArrayList();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.files.add(new File(this.rootPath, (String)iterator.next()));
        }
    }

    void addFiles(Collection collection) {
        this.relativeFileNames.addAll(collection);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.files.add(new File(this.rootPath, (String)iterator.next()));
        }
    }

    List getRelativeFileNames() {
        return this.relativeFileNames;
    }

    List getFiles() {
        return this.files;
    }

    File getArchive() {
        return this.archive;
    }
}

