/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.cis.channel.tcp;

import com.iplanet.ias.cis.channel.ChannelException;
import com.iplanet.ias.cis.channel.tcp.TCPChannel;
import com.iplanet.ias.cis.channel.tcp.TCPNativeException;
import com.iplanet.ias.cis.connection.EndPoint;
import java.nio.ByteBuffer;

public class TCPNonBlockingChannel
extends TCPChannel {
    protected static final int defaultTimeout_msec = 10000;
    protected static final int defaultWriteBuffSize = 8192;
    protected static final int defaultReadBuffSize = 8192;
    private int updatedPort;

    public TCPNonBlockingChannel(EndPoint endPoint, EndPoint endPoint2, int n, int n2, int n3) throws ChannelException {
        this.sendBuffer = ByteBuffer.allocateDirect(n3);
        this.recvBuffer = ByteBuffer.allocateDirect(n2);
        this.recvBuffer.limit(0);
        if (endPoint2 != null || endPoint != null) {
            this.doConnect(endPoint, endPoint2, n);
        }
    }

    public TCPNonBlockingChannel(EndPoint endPoint, int n) throws ChannelException {
        this(null, endPoint, n, 8192, 8192);
    }

    protected TCPNonBlockingChannel() throws ChannelException {
        this(null, null, 10000, 8192, 8192);
    }

    public boolean isBlockingChannel() {
        return false;
    }

    public int send(int n, int n2) throws ChannelException {
        return this.doSend(n, n2);
    }

    public int send(byte[] byArray, int n, int n2) throws ChannelException {
        return this.sendBANative(byArray, n, n2);
    }

    public int send(ByteBuffer byteBuffer, int n) throws ChannelException {
        return this.doSend(byteBuffer, n);
    }

    public int sendFully(int n, int n2) throws ChannelException {
        return this.doSendFully(n, n2);
    }

    public int sendFully(byte[] byArray, int n, int n2) throws ChannelException {
        return this.sendBAFullyNative(byArray, n, n2);
    }

    public int recv(int n, int n2, int n3) throws ChannelException {
        return this.doRecv(n, n2, n3);
    }

    public int recv(byte[] byArray, int n, int n2, int n3) throws ChannelException {
        return this.recvBANative(byArray, n, n2, n3);
    }

    public int recv(ByteBuffer byteBuffer, int n) throws ChannelException {
        return this.doRecv(byteBuffer, n);
    }

    public int recvFully(int n, int n2) throws ChannelException {
        return this.doRecvFully(n, n2);
    }

    public int recvFully(byte[] byArray, int n, int n2) throws ChannelException {
        return this.recvBAFullyNative(byArray, n, n2);
    }

    public void close() throws ChannelException {
        this.doClose();
    }

    private void doClose() throws ChannelException {
        this.closeNative();
        this.fd = 0;
    }

    private void doConnect(EndPoint endPoint, EndPoint endPoint2, int n) throws ChannelException {
        String string = null;
        int n2 = -1;
        boolean bl = false;
        String string2 = endPoint2.getHostIP();
        int n3 = endPoint2.getPort();
        boolean bl2 = endPoint2.isIPv6();
        if (endPoint != null) {
            string = endPoint.getHostIP();
            n2 = endPoint.getPort();
            bl = endPoint.isIPv6();
        }
        this.connectNative(string, n2, bl, string2, n3, bl2, n, this.sendBuffer, this.recvBuffer);
        if (endPoint != null && n2 == 0) {
            endPoint.updatePort(this.updatedPort);
        }
    }

    private int doSend(int n, int n2) throws ChannelException {
        return this.sendNative(this.sendBuffer, n, n2);
    }

    private int doSend(ByteBuffer byteBuffer, int n) throws ChannelException {
        return this.sendByteBufferNative(byteBuffer, n);
    }

    private int doSendFully(int n, int n2) throws ChannelException {
        return this.sendFullyNative(this.sendBuffer, n, n2);
    }

    private int doRecv(int n, int n2, int n3) throws ChannelException {
        return this.recvNative(this.recvBuffer, n, n2, n3);
    }

    private int doRecv(ByteBuffer byteBuffer, int n) throws ChannelException {
        return this.recvByteBufferNative(byteBuffer, n);
    }

    private int doRecvFully(int n, int n2) throws ChannelException {
        return this.recvFullyNative(this.recvBuffer, n, n2);
    }

    private native void connectNative(String var1, int var2, boolean var3, String var4, int var5, boolean var6, int var7, ByteBuffer var8, ByteBuffer var9) throws TCPNativeException;

    private native int sendNative(ByteBuffer var1, int var2, int var3) throws TCPNativeException;

    private native int sendByteBufferNative(ByteBuffer var1, int var2) throws TCPNativeException;

    private native int sendFullyNative(ByteBuffer var1, int var2, int var3) throws TCPNativeException;

    private native int recvNative(ByteBuffer var1, int var2, int var3, int var4) throws TCPNativeException;

    private native int recvByteBufferNative(ByteBuffer var1, int var2) throws TCPNativeException;

    private native int recvFullyNative(ByteBuffer var1, int var2, int var3) throws TCPNativeException;

    private native int sendBANative(byte[] var1, int var2, int var3) throws TCPNativeException;

    private native int sendBAFullyNative(byte[] var1, int var2, int var3) throws TCPNativeException;

    private native int recvBANative(byte[] var1, int var2, int var3, int var4) throws TCPNativeException;

    private native int recvBAFullyNative(byte[] var1, int var2, int var3) throws TCPNativeException;

    private native void closeNative() throws TCPNativeException;

    private static native void initNative();

    static {
        System.loadLibrary("cis");
        TCPNonBlockingChannel.initNative();
    }
}

