/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.cis.channel.tcp;

import com.iplanet.ias.cis.channel.ChannelException;
import com.iplanet.ias.cis.channel.ChannelOptions;
import com.iplanet.ias.cis.channel.tcp.TCPNativeException;

public final class TCPChannelOptions
implements ChannelOptions {
    private static final int NO_DELAY = 1;
    private static final int LINGER = 2;
    private static final int KEEP_ALIVE = 3;
    private static final int SEND_BUF_SIZE = 4;
    private static final int RECV_BUF_SIZE = 5;
    private int fd;
    private int nonBlocking;
    private int noDelay;
    private int linger;
    private int keepAlive;
    private int sendBufSize;
    private int recvBufSize;

    protected TCPChannelOptions(int n) throws ChannelException {
        this.fd = n;
        this.loadNative();
    }

    public boolean isNonBlocking() {
        return this.nonBlocking != 0;
    }

    public void setNoDelay(boolean bl) throws ChannelException {
        int n = bl ? 1 : 0;
        this.setOptionNative(1, n);
        this.noDelay = n;
    }

    public boolean isNoDelay() {
        return this.noDelay != 0;
    }

    public void setLinger(boolean bl, int n) throws ChannelException {
        if (!bl) {
            this.setOptionNative(2, -1);
            this.linger = -1;
        } else {
            if (n < 0) {
                throw new ChannelException("Invalid Value For LINGER");
            }
            if (n > 65535) {
                n = 65535;
            }
            this.setOptionNative(2, n);
            this.linger = n;
        }
    }

    public int getLinger() {
        return this.linger;
    }

    public void setKeepAlive(boolean bl) throws ChannelException {
        int n = bl ? 1 : 0;
        this.setOptionNative(3, n);
        this.keepAlive = n;
    }

    public boolean isKeepAlive() {
        return this.keepAlive != 0;
    }

    public void setSendBufSize(int n) throws ChannelException {
        if (n < 0) {
            throw new ChannelException("Invalid Value For SEND BUF SIZE");
        }
        if (n > 65535) {
            n = 65535;
        }
        this.setOptionNative(4, n);
        this.sendBufSize = n;
    }

    public int getSendBufSize() {
        return this.sendBufSize;
    }

    public void setRecvBufSize(int n) throws ChannelException {
        if (n < 0) {
            throw new ChannelException("Invalid Value For RECV BUF SIZE");
        }
        if (n > 65535) {
            n = 65535;
        }
        this.setOptionNative(5, n);
        this.recvBufSize = n;
    }

    public int getRecvBufSize() {
        return this.recvBufSize;
    }

    private native void setOptionNative(int var1, int var2) throws TCPNativeException;

    private native void loadNative() throws TCPNativeException;

    private static native void initNative();

    static {
        System.loadLibrary("cis");
        TCPChannelOptions.initNative();
    }
}

