/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.cis.channel.tcp;

import com.iplanet.ias.cis.channel.Channel;
import com.iplanet.ias.cis.channel.ChannelException;
import com.iplanet.ias.cis.channel.ServerChannel;
import com.iplanet.ias.cis.channel.tcp.AcceptTimedoutException;
import com.iplanet.ias.cis.channel.tcp.TCPBlockingChannel;
import com.iplanet.ias.cis.channel.tcp.TCPNativeException;
import com.iplanet.ias.cis.connection.EndPoint;

public class TCPBlockingServerChannel
implements ServerChannel {
    private int fd;
    private int sPort;
    protected EndPoint local = null;
    protected String type;

    public TCPBlockingServerChannel(EndPoint endPoint, int n) throws ChannelException {
        this.local = endPoint;
        this.type = endPoint.getType();
        this.createTCPChannel(n);
    }

    public TCPBlockingServerChannel(EndPoint endPoint) throws ChannelException {
        this(endPoint, 50);
    }

    public Channel accept(long l) throws ChannelException {
        try {
            TCPBlockingChannel tCPBlockingChannel = new TCPBlockingChannel();
            tCPBlockingChannel.setType("IIOP_CLEAR_TEXT");
            this.doAccept(tCPBlockingChannel, l);
            return tCPBlockingChannel;
        }
        catch (AcceptTimedoutException acceptTimedoutException) {
            return null;
        }
        catch (ChannelException channelException) {
            return null;
        }
    }

    public Channel accept() throws ChannelException {
        return this.accept(-1L);
    }

    public EndPoint getEndPoint() throws ChannelException {
        if (this.local == null) {
            throw new ChannelException("EndPoint in the server channel is null");
        }
        return this.local;
    }

    public void close() throws ChannelException {
        this.doClose();
        this.fd = 0;
    }

    private void doAccept(TCPBlockingChannel tCPBlockingChannel, long l) throws ChannelException {
        this.acceptNative(this.fd, tCPBlockingChannel, l);
    }

    private void doClose() throws ChannelException {
        this.closeNative();
    }

    private void createTCPChannel(int n) throws ChannelException {
        String string = this.local.getHostIP();
        int n2 = this.local.getPort();
        boolean bl = this.local.isIPv6();
        this.createTCPChannelNative(string, n2, bl, n);
        if (n2 == 0) {
            this.local.updatePort(this.sPort);
        }
    }

    private native void createTCPChannelNative(String var1, int var2, boolean var3, int var4) throws TCPNativeException;

    private native void acceptNative(int var1, TCPBlockingChannel var2, long var3) throws TCPNativeException;

    private native void closeNative() throws TCPNativeException;

    private static native void initNative();

    static {
        System.loadLibrary("cis");
        TCPBlockingServerChannel.initNative();
    }
}

