/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.core.servlet;

import com.iplanet.ias.admin.common.AdminRequest;
import com.iplanet.ias.admin.common.AdminRequestConfigurator;
import com.iplanet.ias.admin.common.AdminResponse;
import com.iplanet.ias.admin.common.AdminResponseConfigurator;
import com.iplanet.ias.admin.common.MBeanServerFactory;
import com.iplanet.ias.admin.common.exception.AFRuntimeException;
import com.iplanet.ias.admin.common.exception.LicenseException;
import com.iplanet.ias.license.IASLicense;
import com.iplanet.ias.license.IASLicenseException;
import com.iplanet.ias.util.i18n.StringManager;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AdminAPIEntryServlet
extends HttpServlet {
    private static StringManager localStrings = StringManager.getManager(class$com$iplanet$ias$admin$server$core$servlet$AdminAPIEntryServlet == null ? (class$com$iplanet$ias$admin$server$core$servlet$AdminAPIEntryServlet = AdminAPIEntryServlet.class$("com.iplanet.ias.admin.server.core.servlet.AdminAPIEntryServlet")) : class$com$iplanet$ias$admin$server$core$servlet$AdminAPIEntryServlet);
    private MBeanServer mMBeanServer = null;
    private Logger mLogger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private final int SUPPORTED_CLIENT_MAJOR_VERSION = 1;
    private final int SUPPORTED_CLIENT_MINOR_VERSION = 1;
    static /* synthetic */ Class class$com$iplanet$ias$admin$server$core$servlet$AdminAPIEntryServlet;

    public void init() throws ServletException {
        super.init();
        this.mMBeanServer = MBeanServerFactory.getMBeanServer();
        this.mLogger.log(Level.INFO, "comm.init_ok");
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGet(httpServletRequest, httpServletResponse);
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = "TEST";
        try {
            this.mLogger.log(Level.INFO, "comm.recd_request");
            ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)httpServletRequest.getInputStream());
            Object object = objectInputStream.readObject();
            AdminRequest adminRequest = (AdminRequest)object;
            string = this.clientVersionCheck(adminRequest);
            if (string == null) {
                string = this.remoteAdminLicenseCheck(httpServletRequest.getRemoteAddr());
            }
            if (string == null) {
                string = this.callMBean(adminRequest);
            }
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream((OutputStream)httpServletResponse.getOutputStream()));
            httpServletResponse.setHeader("Content-type", "application/octet-stream");
            int n = this.getContentLength((Serializable)((Object)string));
            httpServletResponse.setContentLength(n);
            httpServletResponse.setStatus(200);
            objectOutputStream.writeObject(string);
            objectOutputStream.flush();
        }
        catch (Exception exception) {
            throw new ServletException(exception.getMessage());
        }
    }

    private AdminResponse clientVersionCheck(AdminRequest adminRequest) {
        AdminRequestConfigurator adminRequestConfigurator = new AdminRequestConfigurator(adminRequest);
        String string = null;
        try {
            string = adminRequestConfigurator.getClientVersion();
            int n = string.indexOf(46);
            int n2 = Integer.valueOf(string.substring(0, n));
            int n3 = Integer.valueOf(string.substring(n + 1));
            if (n2 == 1 && n3 <= 1) {
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        AdminResponse adminResponse = new AdminResponse();
        AdminResponseConfigurator adminResponseConfigurator = new AdminResponseConfigurator(adminResponse);
        String string2 = string == null ? localStrings.getString("admin.server.core.servlet.no_client_version") : localStrings.getString("admin.server.core.servlet.nonsupported_client_version", string);
        adminResponseConfigurator.setException((Throwable)new AFRuntimeException(string2));
        return adminResponse;
    }

    private AdminResponse remoteAdminLicenseCheck(String string) {
        try {
            IASLicense.checkAllowRemoteAdmin(string);
            return null;
        }
        catch (IASLicenseException iASLicenseException) {
            AdminResponse adminResponse = new AdminResponse();
            AdminResponseConfigurator adminResponseConfigurator = new AdminResponseConfigurator(adminResponse);
            adminResponseConfigurator.setException((Throwable)new LicenseException(iASLicenseException));
            return adminResponse;
        }
    }

    private synchronized AdminResponse callMBean(AdminRequest adminRequest) {
        String string = adminRequest.getRequestType();
        AdminResponse adminResponse = null;
        if (string.equals("invoke")) {
            adminResponse = this.callInvoke(adminRequest);
        } else if (string.equals("getAttribute")) {
            adminResponse = this.callGetAttribute(adminRequest);
        } else if (string.equals("setAttribute")) {
            adminResponse = this.callSetAttribute(adminRequest);
        } else if (string.equals("getAttributes")) {
            adminResponse = this.callGetAttributes(adminRequest);
        } else if (string.equals("setAttributes")) {
            adminResponse = this.callSetAttributes(adminRequest);
        } else {
            adminResponse = new AdminResponse();
            AdminResponseConfigurator adminResponseConfigurator = new AdminResponseConfigurator(adminResponse);
            adminResponseConfigurator.setException((Throwable)new Exception("No Such Type"));
        }
        return adminResponse;
    }

    private synchronized AdminResponse callInvoke(AdminRequest adminRequest) {
        Object object = null;
        AdminResponse adminResponse = new AdminResponse();
        AdminResponseConfigurator adminResponseConfigurator = new AdminResponseConfigurator(adminResponse);
        AdminRequestConfigurator adminRequestConfigurator = new AdminRequestConfigurator(adminRequest);
        ObjectName objectName = adminRequestConfigurator.getObjectName();
        String string = adminRequestConfigurator.getOperationName();
        Object[] objectArray = adminRequestConfigurator.getOperationParams();
        String[] stringArray = adminRequestConfigurator.getOperationSignature();
        try {
            object = this.mMBeanServer.invoke(objectName, string, objectArray, stringArray);
            adminResponseConfigurator.setReturnValue((Serializable)object);
            this.mLogger.log(Level.FINE, "comm.remote_invoke_ok", objectName);
        }
        catch (Exception exception) {
            this.mLogger.log(Level.WARNING, "comm.remote_invoke_failed", this.unwrapMBeanException(exception));
            adminResponseConfigurator.setException((Throwable)exception);
        }
        return adminResponse;
    }

    private synchronized AdminResponse callGetAttribute(AdminRequest adminRequest) {
        Object object = null;
        AdminResponse adminResponse = new AdminResponse();
        AdminResponseConfigurator adminResponseConfigurator = new AdminResponseConfigurator(adminResponse);
        AdminRequestConfigurator adminRequestConfigurator = new AdminRequestConfigurator(adminRequest);
        ObjectName objectName = adminRequestConfigurator.getObjectName();
        String string = adminRequestConfigurator.getAttributeName();
        try {
            object = this.mMBeanServer.getAttribute(objectName, string);
            adminResponseConfigurator.setReturnValue((Serializable)object);
            this.mLogger.log(Level.FINE, "comm.get_attr_ok", objectName);
        }
        catch (Exception exception) {
            this.mLogger.log(Level.WARNING, "comm.get_attr_failed", this.unwrapMBeanException(exception));
            adminResponseConfigurator.setException((Throwable)exception);
        }
        return adminResponse;
    }

    private synchronized AdminResponse callSetAttribute(AdminRequest adminRequest) {
        Object var2_2 = null;
        AdminResponse adminResponse = new AdminResponse();
        AdminResponseConfigurator adminResponseConfigurator = new AdminResponseConfigurator(adminResponse);
        AdminRequestConfigurator adminRequestConfigurator = new AdminRequestConfigurator(adminRequest);
        ObjectName objectName = adminRequestConfigurator.getObjectName();
        Attribute attribute = adminRequestConfigurator.getAttribute();
        try {
            this.mMBeanServer.setAttribute(objectName, attribute);
            String string = "value set: " + attribute.getValue();
            adminResponseConfigurator.setReturnValue((Serializable)((Object)string));
            this.mLogger.log(Level.FINE, "comm.set_attr_ok", objectName);
        }
        catch (Exception exception) {
            this.mLogger.log(Level.WARNING, "comm.set_attr_failed", this.unwrapMBeanException(exception));
            adminResponseConfigurator.setException((Throwable)exception);
        }
        return adminResponse;
    }

    private synchronized AdminResponse callGetAttributes(AdminRequest adminRequest) {
        Object var2_2 = null;
        AdminResponse adminResponse = new AdminResponse();
        AdminResponseConfigurator adminResponseConfigurator = new AdminResponseConfigurator(adminResponse);
        AdminRequestConfigurator adminRequestConfigurator = new AdminRequestConfigurator(adminRequest);
        ObjectName objectName = adminRequestConfigurator.getObjectName();
        String[] stringArray = adminRequestConfigurator.getAttributeNames();
        try {
            AttributeList attributeList = this.mMBeanServer.getAttributes(objectName, stringArray);
            adminResponseConfigurator.setReturnValue((Serializable)attributeList);
            this.mLogger.log(Level.FINE, "comm.get_attrs_ok", objectName);
        }
        catch (Exception exception) {
            this.mLogger.log(Level.WARNING, "comm.get_attrs_failed", this.unwrapMBeanException(exception));
            adminResponseConfigurator.setException((Throwable)exception);
        }
        return adminResponse;
    }

    private synchronized AdminResponse callSetAttributes(AdminRequest adminRequest) {
        Object var2_2 = null;
        AdminResponse adminResponse = new AdminResponse();
        AdminResponseConfigurator adminResponseConfigurator = new AdminResponseConfigurator(adminResponse);
        AdminRequestConfigurator adminRequestConfigurator = new AdminRequestConfigurator(adminRequest);
        ObjectName objectName = adminRequestConfigurator.getObjectName();
        AttributeList attributeList = adminRequestConfigurator.getAttributeList();
        try {
            AttributeList attributeList2 = this.mMBeanServer.setAttributes(objectName, attributeList);
            adminResponseConfigurator.setReturnValue((Serializable)attributeList2);
            this.mLogger.log(Level.FINE, "comm.set_attrs_ok", objectName);
        }
        catch (Exception exception) {
            this.mLogger.log(Level.WARNING, "comm.set_attrs_failed", this.unwrapMBeanException(exception));
            adminResponseConfigurator.setException((Throwable)exception);
        }
        return adminResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int getContentLength(Serializable serializable) {
        int n;
        block11: {
            n = 0;
            ObjectOutputStream objectOutputStream = null;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(serializable);
            n = byteArrayOutputStream.size();
            Object var6_6 = null;
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
                break block11;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break block11;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var6_7 = null;
                    try {
                        if (objectOutputStream != null) {
                            objectOutputStream.close();
                        }
                        break block11;
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    if (objectOutputStream != null) {
                        objectOutputStream.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                throw throwable;
            }
        }
        return n;
    }

    private Exception unwrapMBeanException(Exception exception) {
        while (exception instanceof MBeanException) {
            exception = ((MBeanException)exception).getTargetException();
        }
        return exception;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

