/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.core.mbean.config;

import com.iplanet.ias.admin.common.CombinedPatternMatcher;
import com.iplanet.ias.admin.common.MBeanServerFactory;
import com.iplanet.ias.admin.common.MalformedNameException;
import com.iplanet.ias.admin.common.Name;
import com.iplanet.ias.admin.common.exception.MBeanConfigException;
import com.iplanet.ias.admin.event.AdminEventMulticaster;
import com.iplanet.ias.admin.event.AdminEventResult;
import com.iplanet.ias.admin.event.MonitoringEvent;
import com.iplanet.ias.admin.monitor.CommandMapper;
import com.iplanet.ias.admin.monitor.MonitorGetCommand;
import com.iplanet.ias.admin.monitor.MonitorListCommand;
import com.iplanet.ias.admin.monitor.MonitorSetCommand;
import com.iplanet.ias.admin.server.core.mbean.config.AdminBase;
import com.iplanet.ias.admin.server.core.mbean.config.ConfigMBeanBase;
import com.iplanet.ias.admin.server.core.mbean.config.naming.ConfigMBeanNamingInfo;
import com.iplanet.ias.admin.server.core.mbean.config.naming.ConfigMBeansNaming;
import com.iplanet.ias.admin.server.core.mbean.meta.MBeanEasyConfig;
import com.iplanet.ias.util.i18n.StringManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMRuntimeException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.ServiceNotFoundException;

public class GenericConfigurator
extends AdminBase {
    public static final Logger sLogger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final String MSG_ATTR_NOT_FOUND = "mbean.config.attribute_not_found";
    private static final String MSG_GETMBEANINFO_FAILED = "mbean.config.getmbeaninfo_failed";
    private static final String MSG_GET_ATTRIBUTE = "mbean.config.get_attribute";
    private static final String MSG_GET_ATTRIBUTE_DEFAULT = "mbean.config.get_attribute_default";
    private static final String MSG_SET_ATTRIBUTE = "mbean.config.set_attribute";
    private static final String MSG_LIST_NAMES_CONTS = "mbean.config.list_names_continuations";
    private static StringManager localStrings = StringManager.getManager(class$com$iplanet$ias$admin$server$core$mbean$config$GenericConfigurator == null ? (class$com$iplanet$ias$admin$server$core$mbean$config$GenericConfigurator = GenericConfigurator.class$("com.iplanet.ias.admin.server.core.mbean.config.GenericConfigurator")) : class$com$iplanet$ias$admin$server$core$mbean$config$GenericConfigurator);
    MBeanServer mServer = null;
    static String[] mAttrs = new String[0];
    static String[] mOpers = new String[]{"getGenericAttribute(String name), INFO", "getGenericAttributes(String[] attributeNames),   INFO", "setGenericAttribute(String name, Object objValue),  ACTION_INFO", "setGenericAttributes(javax.management.AttributeList al),          ACTION_INFO", "getMonitor(String[] name), INFO", "setMonitor(javax.management.AttributeList al), ACTION", "listMonitor(String name), INFO", "listGenericDottedNameContinuiations(String dottedName), INFO"};
    static /* synthetic */ Class class$com$iplanet$ias$admin$server$core$mbean$config$GenericConfigurator;

    public AttributeList getGenericAttribute(String string) throws InstanceNotFoundException, AttributeNotFoundException, MBeanException, ReflectionException, MalformedNameException, MalformedObjectNameException, IntrospectionException, MBeanConfigException {
        sLogger.log(Level.FINEST, MSG_GET_ATTRIBUTE, string);
        if (this.mServer == null) {
            this.mServer = MBeanServerFactory.getMBeanServer();
        }
        string = string.trim();
        String string2 = this.extractAttrNameFromDotted(string);
        int n = string.length() - string2.length();
        String string3 = null;
        if (n > 0) {
            string3 = string.substring(0, n);
        }
        ArrayList arrayList = this.getMBeanNamesFromDottedPattern(string);
        AttributeList attributeList = new AttributeList();
        int n2 = 0;
        while (n2 < arrayList.size()) {
            this.addAttributeToList(attributeList, (ObjectName)arrayList.get(n2), string2);
            ++n2;
        }
        if (string3 != null && attributeList != null) {
            int n3 = 0;
            while (n3 < attributeList.size()) {
                Attribute attribute = (Attribute)attributeList.get(n3);
                attributeList.set(n3, new Attribute(string3 + attribute.getName(), attribute.getValue()));
                ++n3;
            }
        }
        return attributeList;
    }

    public AttributeList getGenericAttributeDefaultValues(String string, String string2, String[] stringArray) throws MBeanConfigException {
        sLogger.log(Level.FINEST, MSG_GET_ATTRIBUTE_DEFAULT, new String[]{string, string2});
        ConfigMBeanNamingInfo configMBeanNamingInfo = new ConfigMBeanNamingInfo(string2, new String[]{string}, false);
        ConfigMBeanBase configMBeanBase = configMBeanNamingInfo.constructConfigMBean();
        AttributeList attributeList = new AttributeList();
        int n = 0;
        while (n < stringArray.length) {
            Object object;
            try {
                object = configMBeanBase.getDefaultAttributeValue(stringArray[n]);
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                object = null;
            }
            catch (MBeanConfigException mBeanConfigException) {
                object = null;
            }
            if (object != null) {
                attributeList.add(new Attribute(stringArray[n], object));
            }
            ++n;
        }
        return attributeList;
    }

    public String[] listGenericDottedNameContinuiations(String string) throws MalformedNameException {
        sLogger.log(Level.FINEST, MSG_LIST_NAMES_CONTS, string);
        string = string.trim();
        String string2 = this.extractInstanceNameFromDotted(string);
        return ConfigMBeansNaming.findNameContinuation(string2, string);
    }

    public AttributeList getGenericAttributes(String[] stringArray) throws InstanceNotFoundException, AttributeNotFoundException, MBeanException, ReflectionException, MalformedNameException, MalformedObjectNameException, IntrospectionException, MBeanConfigException {
        AttributeList attributeList = new AttributeList();
        int n = 0;
        while (n < stringArray.length) {
            attributeList.addAll(this.getGenericAttribute(stringArray[n]));
            ++n;
        }
        return attributeList;
    }

    public AttributeList setGenericAttribute(String string, Object object) throws MBeanConfigException, InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, MalformedNameException, MalformedObjectNameException, IntrospectionException {
        sLogger.log(Level.FINEST, MSG_SET_ATTRIBUTE, new Object[]{string, object});
        if (this.mServer == null) {
            this.mServer = MBeanServerFactory.getMBeanServer();
        }
        String string2 = this.extractAttrNameFromDotted(string);
        ArrayList arrayList = this.getMBeanNamesFromDottedPattern(string);
        AttributeList attributeList = new AttributeList();
        int n = 0;
        while (n < arrayList.size()) {
            this.setMatchedAttributesToValue(attributeList, (ObjectName)arrayList.get(n), string2, object);
            ++n;
        }
        return attributeList;
    }

    public AttributeList setGenericAttributes(AttributeList attributeList) throws InvalidAttributeValueException, InstanceNotFoundException, InvalidAttributeValueException, MBeanConfigException, MBeanException, ReflectionException, MalformedNameException, MalformedObjectNameException, IntrospectionException {
        AttributeList attributeList2 = new AttributeList();
        Iterator iterator = attributeList.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            String string = attribute.getName();
            Object object = attribute.getValue();
            try {
                attributeList2.addAll(this.setGenericAttribute(string, object));
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                sLogger.log(Level.FINE, MSG_ATTR_NOT_FOUND, string);
            }
        }
        return attributeList2;
    }

    public AttributeList getMonitor(String string) throws Exception {
        Name name = new Name(string);
        String string2 = name.getNamePart(0).toString();
        CommandMapper commandMapper = CommandMapper.getInstance(string2);
        MonitorGetCommand monitorGetCommand = commandMapper.mapGetCommand(string);
        MonitoringEvent monitoringEvent = new MonitoringEvent(string2, string, "get_monitoring", monitorGetCommand);
        AdminEventResult adminEventResult = AdminEventMulticaster.multicastEvent(monitoringEvent);
        if (!adminEventResult.getResultCode().equals("success")) {
            this.handleMonitoringError(adminEventResult, string2, string);
        }
        return (AttributeList)adminEventResult.getAttribute("monitor.result");
    }

    public AttributeList getMonitor(String[] stringArray) throws Exception {
        AttributeList attributeList = new AttributeList();
        int n = 0;
        while (n < stringArray.length) {
            attributeList.addAll(this.getMonitor(stringArray[n]));
            ++n;
        }
        return attributeList;
    }

    public String[] listMonitor(String string) throws Exception {
        Name name = new Name(string);
        String string2 = name.getNamePart(0).toString();
        CommandMapper commandMapper = CommandMapper.getInstance(string2);
        MonitorListCommand monitorListCommand = commandMapper.mapListCommand(string);
        MonitoringEvent monitoringEvent = new MonitoringEvent(string2, string, "list_monitorable", monitorListCommand);
        AdminEventResult adminEventResult = AdminEventMulticaster.multicastEvent(monitoringEvent);
        if (!adminEventResult.getResultCode().equals("success")) {
            this.handleMonitoringError(adminEventResult, string2, string);
        }
        return (String[])adminEventResult.getAttribute("monitor.result");
    }

    public AttributeList setMonitor(AttributeList attributeList) throws Exception {
        AttributeList attributeList2 = new AttributeList();
        Iterator iterator = attributeList.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            String string = attribute.getName();
            Object object = attribute.getValue();
            try {
                attributeList2.addAll(this.setMonitor(string, object));
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                sLogger.log(Level.FINE, MSG_ATTR_NOT_FOUND, string);
            }
        }
        return attributeList2;
    }

    public AttributeList setMonitor(String string, Object object) throws Exception {
        Name name = new Name(string);
        String string2 = name.getNamePart(0).toString();
        CommandMapper commandMapper = CommandMapper.getInstance(string2);
        MonitorSetCommand monitorSetCommand = commandMapper.mapSetCommand(string, object);
        MonitoringEvent monitoringEvent = new MonitoringEvent(string2, string, "set_monitoring", monitorSetCommand);
        AdminEventResult adminEventResult = AdminEventMulticaster.multicastEvent(monitoringEvent);
        if (!adminEventResult.getResultCode().equals("success")) {
            this.handleMonitoringError(adminEventResult, string2, string);
        }
        AttributeList attributeList = null;
        AttributeList attributeList2 = (AttributeList)adminEventResult.getAttribute("monitor.result");
        Iterator iterator = attributeList2.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            attributeList = (AttributeList)attribute.getValue();
        }
        return attributeList;
    }

    private int setMatchedAttributesToValue(AttributeList attributeList, ObjectName objectName, String string, Object object) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, MalformedNameException, IntrospectionException {
        ArrayList arrayList = this.getAttrNames(objectName, string);
        if (arrayList.size() == 0) {
            String string2 = localStrings.getString("admin.server.core.mbean.config.no_attributes_matched_to_pattern", string);
            throw new AttributeNotFoundException(string2);
        }
        int n = 0;
        while (n < arrayList.size()) {
            String string3 = (String)arrayList.get(n);
            Object object2 = this.convertValueToAttributeType(objectName, string3, object);
            this.mServer.setAttribute(objectName, new Attribute(string3, object2));
            attributeList.add(new Attribute(string3, object2));
            ++n;
        }
        return arrayList.size();
    }

    private void addAttributeToList(AttributeList attributeList, ObjectName objectName, String string) throws InstanceNotFoundException, AttributeNotFoundException, MBeanException, ReflectionException, MalformedNameException, IntrospectionException {
        AttributeList attributeList2 = null;
        if (string.equals("*")) {
            attributeList2 = this.mServer.getAttributes(objectName, new String[]{""});
            if (attributeList2 != null) {
                attributeList.addAll(attributeList2);
            }
        } else if (string.equals("property.*")) {
            attributeList2 = this.mServer.getAttributes(objectName, new String[]{"property."});
            if (attributeList2 != null) {
                attributeList.addAll(attributeList2);
            }
        } else {
            Object object = this.mServer.getAttribute(objectName, string);
            attributeList.add(new Attribute(string, object));
        }
    }

    private void handleMonitoringError(AdminEventResult adminEventResult, String string, String string2) throws AttributeNotFoundException, InstanceNotFoundException, ServiceNotFoundException {
        String string3 = adminEventResult.getResultCode();
        if ("transmission_error".equals(string3)) {
            String string4 = localStrings.getString("admin.server.core.mbean.config.failed_to_connect_instance", string);
            throw new ServiceNotFoundException(string4);
        }
        if ("mbean_not_found".equals(string3)) {
            String string5 = localStrings.getString("admin.server.core.mbean.config.unmatched_mbean", string2);
            throw new InstanceNotFoundException(string5);
        }
        if ("mbean_attr_not_found".equals(string3)) {
            String string6 = localStrings.getString("admin.server.core.mbean.config.unmatched_attribute", string2);
            throw new AttributeNotFoundException(string6);
        }
        if (!"success".equals(string3)) {
            String string7 = localStrings.getString("admin.server.core.mbean.config.other_monitoring_error", string3);
            throw new JMRuntimeException(string7);
        }
    }

    private ArrayList getAttrNames(ObjectName objectName, String string) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null) {
            return arrayList;
        }
        if (string.indexOf(42) >= 0 || string.indexOf(63) >= 0) {
            MBeanAttributeInfo[] mBeanAttributeInfoArray;
            MBeanInfo mBeanInfo = this.mServer.getMBeanInfo(objectName);
            if (mBeanInfo != null && (mBeanAttributeInfoArray = mBeanInfo.getAttributes()) != null) {
                int n = 0;
                while (n < mBeanAttributeInfoArray.length) {
                    String string2 = mBeanAttributeInfoArray[n].getName();
                    try {
                        if (new CombinedPatternMatcher(string, string2).matches()) {
                            arrayList.add(mBeanAttributeInfoArray[n].getName());
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    ++n;
                }
            }
        } else {
            arrayList.add(string);
        }
        return arrayList;
    }

    private String getAttrType(ObjectName objectName, String string) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        return this.getAttrType(string, this.mServer.getMBeanInfo(objectName));
    }

    private String getAttrType(String string, MBeanInfo mBeanInfo) {
        if (string == null && mBeanInfo == null) {
            return null;
        }
        MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
        if (mBeanAttributeInfoArray != null) {
            int n = 0;
            while (n < mBeanAttributeInfoArray.length) {
                String string2 = mBeanAttributeInfoArray[n].getName();
                if (string.equals(mBeanAttributeInfoArray[n].getName())) {
                    return mBeanAttributeInfoArray[n].getType();
                }
                ++n;
            }
        }
        return null;
    }

    private ArrayList getTargetObjectNames(ObjectName objectName) throws MalformedObjectNameException {
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
        if (objectName == null) {
            return arrayList;
        }
        Set<ObjectInstance> set = this.mServer.queryMBeans(objectName, null);
        Iterator<ObjectInstance> iterator = set.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        if (arrayList.size() == 0) {
            arrayList.add(objectName);
        }
        return arrayList;
    }

    String extractAttrNameFromDotted(String string) throws MalformedNameException {
        int n;
        int n2 = string.lastIndexOf(46);
        if (n2 <= 0 || n2 == string.length() - 1) {
            String string2 = localStrings.getString("admin.server.core.mbean.config.cannot_extract_attribute_name_from_dotted_notation", string);
            throw new MalformedNameException(string2);
        }
        if (string.substring(0, n2 + 1).endsWith("property.") && string.charAt(n = n2 - "property.".length()) == '.' && (n2 = n) < 1) {
            String string3 = localStrings.getString("admin.server.core.mbean.config.cannot_extract_attribute_name_from_dotted_notation", string);
            throw new MalformedNameException(string3);
        }
        return string.substring(n2 + 1);
    }

    String extractInstanceNameFromDotted(String string) throws MalformedNameException {
        Name name = new Name(string);
        return name.getNamePart(0).toString();
    }

    ArrayList getMBeanNamesFromDottedPattern(String string) throws MBeanConfigException, MalformedNameException, MalformedObjectNameException {
        String string2 = this.extractAttrNameFromDotted(string);
        int n = string.length() - string2.length() - 1;
        if (n < 1) {
            String string3 = localStrings.getString("admin.server.core.mbean.config.genericconfigurator_cannot_extract_attribute_name_from_dotted_notation", string);
            throw new MalformedNameException(string3);
        }
        ConfigMBeanNamingInfo configMBeanNamingInfo = new ConfigMBeanNamingInfo(string.substring(0, n));
        ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>();
        arrayList.add(configMBeanNamingInfo.getObjectName());
        return arrayList;
    }

    private Object convertValueToAttributeType(ObjectName objectName, String string, Object object) {
        try {
            if (object instanceof String) {
                String string2 = this.getAttrType(objectName, string);
                return MBeanEasyConfig.convertStringValueToProperType((String)object, string2);
            }
        }
        catch (Throwable throwable) {}
        return object;
    }

    public MBeanInfo getMBeanInfo() {
        try {
            return new MBeanEasyConfig(this.getClass(), mAttrs, mOpers, null).getMBeanInfo();
        }
        catch (Throwable throwable) {
            sLogger.log(Level.FINE, MSG_GETMBEANINFO_FAILED, throwable);
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

