/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.monitor;

import com.iplanet.ias.admin.common.MalformedNameException;
import com.iplanet.ias.admin.common.Name;
import com.iplanet.ias.admin.monitor.MonitorCommand;
import com.iplanet.ias.admin.monitor.MonitorGetCommand;
import com.iplanet.ias.admin.monitor.MonitorListCommand;
import com.iplanet.ias.admin.monitor.MonitorSetCommand;
import com.iplanet.ias.admin.monitor.MonitoredObjectType;
import com.iplanet.ias.admin.monitor.ParsedDottedName;
import com.iplanet.ias.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class CommandMapper {
    private static HashMap instanceMap = new HashMap();
    private String instanceName;
    private static StringManager localStrings = StringManager.getManager(class$com$iplanet$ias$admin$monitor$CommandMapper == null ? (class$com$iplanet$ias$admin$monitor$CommandMapper = CommandMapper.class$("com.iplanet.ias.admin.monitor.CommandMapper")) : class$com$iplanet$ias$admin$monitor$CommandMapper);
    public static final String CLI_COMMAND_GET = "GET";
    public static final String CLI_COMMAND_LIST = "LIST";
    public static final String CLI_COMMAND_SET = "SET";
    static /* synthetic */ Class class$com$iplanet$ias$admin$monitor$CommandMapper;

    private CommandMapper() {
    }

    public MonitorCommand mapCliCommand(String string, String string2) throws MalformedNameException {
        MonitorCommand monitorCommand = null;
        if (CLI_COMMAND_GET.equalsIgnoreCase(string)) {
            monitorCommand = this.mapGetCommand(string2);
        } else if (CLI_COMMAND_LIST.equalsIgnoreCase(string)) {
            monitorCommand = this.mapListCommand(string2);
        } else {
            String string3 = localStrings.getString("admin.monitor.unknown_cli_command", string);
            throw new IllegalArgumentException(string3);
        }
        return monitorCommand;
    }

    public MonitorGetCommand mapGetCommand(String string) throws MalformedNameException {
        ParsedDottedName parsedDottedName = this.parseDottedName(string, CLI_COMMAND_GET);
        MonitorGetCommand monitorGetCommand = parsedDottedName.monitoredObjectType != null ? new MonitorGetCommand(parsedDottedName.objectName, parsedDottedName.monitoredObjectType, parsedDottedName.attributeName) : new MonitorGetCommand(parsedDottedName.objectName, parsedDottedName.attributeName);
        return monitorGetCommand;
    }

    public MonitorListCommand mapListCommand(String string) throws MalformedNameException {
        ParsedDottedName parsedDottedName = this.parseDottedName(string, CLI_COMMAND_LIST);
        MonitorListCommand monitorListCommand = parsedDottedName.monitoredObjectType != null ? new MonitorListCommand(parsedDottedName.objectName, parsedDottedName.monitoredObjectType) : new MonitorListCommand(parsedDottedName.objectName);
        return monitorListCommand;
    }

    public MonitorSetCommand mapSetCommand(String string, Object object) throws MalformedNameException {
        ParsedDottedName parsedDottedName = this.parseDottedName(string, CLI_COMMAND_SET);
        MonitorSetCommand monitorSetCommand = null;
        String string2 = (String)object;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        monitorSetCommand = new MonitorSetCommand(parsedDottedName.objectName, parsedDottedName.monitoredObjectType, parsedDottedName.operationName, stringArray);
        return monitorSetCommand;
    }

    public static CommandMapper getInstance(String string) {
        CommandMapper commandMapper = (CommandMapper)instanceMap.get(string);
        if (commandMapper == null) {
            commandMapper = new CommandMapper();
            commandMapper.instanceName = string;
            instanceMap.put(string, commandMapper);
        }
        return commandMapper;
    }

    private ParsedDottedName parseDottedName(String string, String string2) throws MalformedNameException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Name name = new Name(string);
        int n = name.getNumParts();
        if (n < 1) {
            String string3 = localStrings.getString("admin.monitor.name_does_not_contain_any_tokens", string);
            throw new MalformedNameException(string3);
        }
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(name.getNamePart(n2).toString());
            ++n2;
        }
        return this.parseTokens(arrayList, string2, string);
    }

    private ParsedDottedName parseTokens(ArrayList arrayList, String string, String string2) throws MalformedNameException {
        Object object;
        Properties properties = new Properties();
        properties.put("type", "monitor");
        properties.put("name", "root");
        properties.put("mclass", "root");
        properties.put("instance-name", this.instanceName);
        int n = arrayList.size();
        MonitoredObjectType monitoredObjectType = null;
        int n2 = n;
        if (string.equals(CLI_COMMAND_GET) || string.equals(CLI_COMMAND_SET)) {
            n2 = n - 1;
        }
        boolean bl = true;
        int n3 = 1;
        while (n3 < n2) {
            object = (String)arrayList.get(n3);
            if (bl) {
                String string3;
                monitoredObjectType = MonitoredObjectType.getMonitoredObjectTypeOrNull((String)object);
                if (monitoredObjectType == null) {
                    string3 = localStrings.getString("admin.monitor.invalid_entry", string2, object);
                    throw new MalformedNameException(string3);
                }
                string3 = monitoredObjectType.getTypeName();
                if (monitoredObjectType.isSingleton()) {
                    this.swapNameType(properties, string3, string3);
                    bl = true;
                    monitoredObjectType = null;
                } else {
                    bl = false;
                }
            } else {
                this.swapNameType(properties, monitoredObjectType.getTypeName(), (String)object);
                bl = true;
                monitoredObjectType = null;
            }
            ++n3;
        }
        object = new ParsedDottedName();
        try {
            ((ParsedDottedName)object).objectName = new ObjectName("ias", properties);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new MalformedNameException(malformedObjectNameException.getMessage());
        }
        if (monitoredObjectType != null) {
            ((ParsedDottedName)object).monitoredObjectType = monitoredObjectType;
        }
        if (string.equals(CLI_COMMAND_GET)) {
            ((ParsedDottedName)object).attributeName = (String)arrayList.get(n - 1);
        } else if (string.equals(CLI_COMMAND_SET)) {
            ((ParsedDottedName)object).operationName = (String)arrayList.get(n - 1);
        }
        return object;
    }

    private void swapNameType(Properties properties, String string, String string2) {
        String string3 = properties.getProperty("mclass");
        String string4 = properties.getProperty("name");
        properties.put("mclass", string);
        properties.put("name", string2);
        properties.put(string3, string4);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

