/*
 * Decompiled with CFR 0.152.
 */
package javax.ejb.deployment;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.Identity;
import javax.ejb.deployment.SerializableMethod;

public class ControlDescriptor
implements Serializable {
    public static final int TX_NOT_SUPPORTED = 0;
    public static final int TX_BEAN_MANAGED = 1;
    public static final int TX_REQUIRED = 2;
    public static final int TX_SUPPORTS = 3;
    public static final int TX_REQUIRES_NEW = 4;
    public static final int TX_MANDATORY = 5;
    public static final int TRANSACTION_READ_UNCOMMITTED = 1;
    public static final int TRANSACTION_READ_COMMITTED = 2;
    public static final int TRANSACTION_REPEATABLE_READ = 4;
    public static final int TRANSACTION_SERIALIZABLE = 8;
    public static final int CLIENT_IDENTITY = 0;
    public static final int SPECIFIED_IDENTITY = 1;
    public static final int SYSTEM_IDENTITY = 2;
    private int transactionAttribute = 3;
    private int isolationLevel = 2;
    private int runAsMode = 1;
    private Identity runAsIdentity = null;
    private transient Method method = null;
    private SerializableMethod serializableMethod = null;

    public ControlDescriptor() {
    }

    public ControlDescriptor(Method method) {
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method value) {
        this.method = value;
    }

    boolean isMethodLevel() {
        return this.method != null;
    }

    public int getTransactionAttribute() {
        return this.transactionAttribute;
    }

    public void setTransactionAttribute(int value) {
        switch (value) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.transactionAttribute = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal value of transactionAttribute");
            }
        }
    }

    public int getIsolationLevel() {
        return this.isolationLevel;
    }

    public void setIsolationLevel(int value) {
        switch (value) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                this.isolationLevel = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal value of isolationLevel");
            }
        }
    }

    public int getRunAsMode() {
        return this.runAsMode;
    }

    public void setRunAsMode(int value) {
        switch (value) {
            case 0: 
            case 1: 
            case 2: {
                this.runAsMode = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal value of runAsMode");
            }
        }
    }

    public Identity getRunAsIdentity() {
        return this.runAsIdentity;
    }

    public void setRunAsIdentity(Identity value) {
        this.runAsIdentity = value;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.serializableMethod = new SerializableMethod(this.method);
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, NoSuchMethodException {
        in.defaultReadObject();
        this.method = this.serializableMethod.getMethod();
    }

    static {
        TX_NOT_SUPPORTED = 0;
        TX_BEAN_MANAGED = 1;
        TX_REQUIRED = 2;
        TX_SUPPORTS = 3;
        TX_REQUIRES_NEW = 4;
        TX_MANDATORY = 5;
        TRANSACTION_READ_UNCOMMITTED = 1;
        TRANSACTION_READ_COMMITTED = 2;
        TRANSACTION_REPEATABLE_READ = 4;
        TRANSACTION_SERIALIZABLE = 8;
        CLIENT_IDENTITY = 0;
        SPECIFIED_IDENTITY = 1;
        SYSTEM_IDENTITY = 2;
    }
}

