/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.util;

import java.text.MessageFormat;
import java.util.Date;
import java.util.ResourceBundle;

public class LocalStringsManager {
    static final String DEFAULT_PROPERTY_FILE_NAME = "LocalStrings";
    private String m_propertyFileName;
    private String m_basePackage;
    private ResourceBundle m_FixedResourceBundle;

    public LocalStringsManager(String basePackage, String propertyFileName) {
        this.m_basePackage = basePackage;
        this.m_propertyFileName = propertyFileName;
    }

    public LocalStringsManager(String basePackage) {
        this(basePackage, DEFAULT_PROPERTY_FILE_NAME);
    }

    public String getString(String startPackage, String key, String defaultValue) {
        if (this.m_FixedResourceBundle != null) {
            String value = this.m_FixedResourceBundle.getString(key);
            if (value != null) {
                return value;
            }
            return defaultValue;
        }
        String stopPackage = this.m_basePackage;
        if (startPackage == null) {
            startPackage = stopPackage;
        } else if (!startPackage.startsWith(this.m_basePackage)) {
            stopPackage = startPackage;
        }
        ResourceBundle resources = null;
        while (startPackage.length() > 0 && startPackage.length() >= stopPackage.length()) {
            try {
                String value;
                String resFileName = startPackage + "." + this.m_propertyFileName;
                startPackage = startPackage.substring(0, startPackage.lastIndexOf("."));
                resources = ResourceBundle.getBundle(resFileName);
                if (resources == null || (value = resources.getString(key)) == null) continue;
                return value;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (!stopPackage.equals(this.m_basePackage)) {
            return this.getString(null, key, defaultValue);
        }
        return defaultValue;
    }

    public String getString(String key, String defaultValue) {
        return this.getString(null, key, defaultValue);
    }

    public String getString(String startPackage, String key, String defaultFormat, Object[] arguments) {
        MessageFormat f = new MessageFormat(this.getString(startPackage, key, defaultFormat));
        int i = 0;
        while (i < arguments.length) {
            if (arguments[i] == null) {
                arguments[i] = "null";
            } else if (!(arguments[i] instanceof String || arguments[i] instanceof Number || arguments[i] instanceof Date)) {
                arguments[i] = arguments[i].toString();
            }
            ++i;
        }
        return f.format(arguments);
    }

    public String getString(String key, String defaultFormat, Object[] arguments) {
        return this.getString(null, key, defaultFormat, arguments);
    }

    protected void setFixedResourceBundle(String startPackage) {
        if (startPackage == null) {
            this.m_FixedResourceBundle = null;
            return;
        }
        String stopPackage = this.m_basePackage;
        if (startPackage == null) {
            startPackage = stopPackage;
        } else if (!startPackage.startsWith(this.m_basePackage)) {
            stopPackage = startPackage;
        }
        ResourceBundle resources = null;
        while (startPackage.length() > 0 && startPackage.length() >= stopPackage.length()) {
            try {
                String resFileName = startPackage + "." + this.m_propertyFileName;
                startPackage = startPackage.substring(0, startPackage.lastIndexOf("."));
                resources = ResourceBundle.getBundle(resFileName);
                if (resources == null) continue;
                this.m_FixedResourceBundle = resources;
                return;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (!stopPackage.equals(this.m_basePackage)) {
            this.setFixedResourceBundle(this.m_basePackage);
        }
    }
}

