/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel.controllers;

import com.iplanet.ias.admin.common.ObjectNames;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.servermodel.beans.AuthDb;
import com.iplanet.ias.admin.servermodel.beans.VirtualServer;
import com.iplanet.ias.admin.servermodel.context.ContextHolder;
import com.iplanet.ias.admin.servermodel.controllers.Controller;
import com.iplanet.ias.admin.servermodel.controllers.SOMRequestDispatcher;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.ArgChecker;
import com.iplanet.ias.admin.util.Assert;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.admin.util.StringValidator;
import java.util.Vector;
import javax.management.ObjectName;

public class VirtualServerController
implements Controller {
    private static final String CREATE_HTTP_QOS = "createHttpQos";
    private static final String DELETE_HTTP_QOS = "deleteHttpQos";
    private static final String CREATE_AUTH_DB = "createAuthDb";
    private static final String DELETE_AUTH_DB = "deleteAuthDb";
    private static final String LIST_AUTH_DBS = "listAuthDbs";
    private static final String IS_HTTP_QOS_CREATED = "isHttpQosCreated";
    private VirtualServer component;

    public VirtualServerController(VirtualServer virtualServer) {
        this.component = virtualServer;
    }

    public boolean isHttpQosCreated() throws AFException {
        Boolean value = (Boolean)this.invoke(IS_HTTP_QOS_CREATED, null, null);
        Assert.assertit(value != null, "null value returned");
        return value;
    }

    public void createHttpQos() throws AFException {
        String[] signature = new String[]{"java.lang.String", "java.lang.Boolean", "java.lang.String", "java.lang.Boolean"};
        Object[] params = new Object[]{null, null, null, null};
        this.invoke(CREATE_HTTP_QOS, params, signature);
    }

    public void removeHttpQos() throws AFException {
        this.invoke(DELETE_HTTP_QOS, null, null);
    }

    public void createAuthDb(String id, String database) throws AFException {
        ArgChecker.checkValid(id, "id", StringValidator.getInstance());
        ArgChecker.checkValid(database, "database", StringValidator.getInstance());
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"};
        Object[] params = new Object[]{id, database, null, null};
        this.invoke(CREATE_AUTH_DB, params, signature);
    }

    public void removeAuthDb(String id) throws AFException {
        ArgChecker.checkValid(id, "id", StringValidator.getInstance());
        String[] signature = new String[]{"java.lang.String"};
        Object[] params = new Object[]{id};
        this.invoke(DELETE_AUTH_DB, params, signature);
    }

    public ServerModelIterator getAuthDbs() throws AFException {
        String[] authDBs = (String[])this.invoke(LIST_AUTH_DBS, null, null);
        Vector<AuthDb> list = new Vector<AuthDb>();
        if (authDBs != null && authDBs.length > 0) {
            String instanceName = this.component.getInstanceName();
            String virtualServerClassId = this.component.getVirtualServerClassId();
            String virtualServerId = this.component.getVirtualServerId();
            int i = 0;
            while (i < authDBs.length) {
                ObjectName mbeanName = ObjectNames.getVirtualServerAuthDBObjectName(instanceName, virtualServerClassId, virtualServerId, authDBs[i]);
                Assert.assertit(mbeanName != null, "null value returned");
                Debug.println("VirtualServerController.getAuthDbs: mbeanName = " + mbeanName);
                AuthDb authDb = new AuthDb(mbeanName.toString(), authDBs[i]);
                authDb.setContextHolder(this.component.getContextHolder());
                list.add(authDb);
                ++i;
            }
        }
        return new ServerModelIterator(list);
    }

    private Object invoke(String operation, Object[] params, String[] signature) throws AFException {
        try {
            ContextHolder ctxHolder = this.component.getContextHolder();
            ObjectName mbeanName = new ObjectName(this.component.getIdentifier());
            SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
            return dispatcher.invoke(mbeanName, operation, params, signature);
        }
        catch (Exception e) {
            if (e instanceof AFException) {
                throw (AFException)e;
            }
            throw new AFException(e.getLocalizedMessage());
        }
    }
}

