/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.common;

import java.lang.constant.Constable;
import java.util.HashMap;

public class ParamInfo {
    protected String mOperationName = null;
    protected String[] mSignature = null;
    protected Object[] mParams = null;
    protected boolean mForcePrimitives = false;
    private static final HashMap mPrimitives = ParamInfo.createPrimitivesMap();
    private static final HashMap mPrimitiveClasses = ParamInfo.createPrimitiveClassesMap();
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Long;

    private static HashMap createPrimitivesMap() {
        HashMap<Class, String> primitives = new HashMap<Class, String>();
        primitives.put(class$java$lang$Integer == null ? (class$java$lang$Integer = ParamInfo.class$("java.lang.Integer")) : class$java$lang$Integer, "int");
        primitives.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ParamInfo.class$("java.lang.Boolean")) : class$java$lang$Boolean, "boolean");
        primitives.put(class$java$lang$Float == null ? (class$java$lang$Float = ParamInfo.class$("java.lang.Float")) : class$java$lang$Float, "float");
        primitives.put(class$java$lang$Double == null ? (class$java$lang$Double = ParamInfo.class$("java.lang.Double")) : class$java$lang$Double, "double");
        primitives.put(class$java$lang$Byte == null ? (class$java$lang$Byte = ParamInfo.class$("java.lang.Byte")) : class$java$lang$Byte, "byte");
        primitives.put(class$java$lang$Character == null ? (class$java$lang$Character = ParamInfo.class$("java.lang.Character")) : class$java$lang$Character, "char");
        primitives.put(class$java$lang$Short == null ? (class$java$lang$Short = ParamInfo.class$("java.lang.Short")) : class$java$lang$Short, "short");
        primitives.put(class$java$lang$Long == null ? (class$java$lang$Long = ParamInfo.class$("java.lang.Long")) : class$java$lang$Long, "long");
        return primitives;
    }

    private static HashMap createPrimitiveClassesMap() {
        HashMap<String, Class<Constable>> primitiveClassMap = new HashMap<String, Class<Constable>>();
        primitiveClassMap.put("int", Integer.TYPE);
        primitiveClassMap.put("boolean", Boolean.TYPE);
        primitiveClassMap.put("float", Float.TYPE);
        primitiveClassMap.put("double", Double.TYPE);
        primitiveClassMap.put("byte", Byte.TYPE);
        primitiveClassMap.put("char", Character.TYPE);
        primitiveClassMap.put("short", Short.TYPE);
        primitiveClassMap.put("long", Long.TYPE);
        return primitiveClassMap;
    }

    public static Class getPrimitiveClass(String type) {
        return (Class)mPrimitiveClasses.get(type);
    }

    public void initCoercionOptions() {
        this.mForcePrimitives = false;
    }

    public ParamInfo(String operationName, Object[] params) {
        this.mOperationName = operationName;
        this.mParams = params;
        this.initCoercionOptions();
        this.mSignature = this.paramsToClassNames(params);
    }

    public ParamInfo(String operationName) {
        this(operationName, new Object[0]);
    }

    public ParamInfo(String operationName, Object param) {
        this(operationName, new Object[]{param});
    }

    public ParamInfo(String operationName, Object param1, Object param2) {
        this(operationName, new Object[]{param1, param2});
    }

    public ParamInfo(String operationName, Object param1, Object param2, Object param3) {
        this(operationName, new Object[]{param1, param2, param3});
    }

    public ParamInfo(String operationName, Object param1, Object param2, Object param3, Object param4) {
        this(operationName, new Object[]{param1, param2, param3, param4});
    }

    public String getOperationName() {
        return this.mOperationName;
    }

    public Object[] getParams() {
        return this.mParams;
    }

    public String[] getSignature() {
        return this.mSignature;
    }

    public String[] paramsToClassNames(Object[] params) {
        String[] signature = new String[params.length];
        int ctr = 0;
        while (ctr < params.length) {
            Object primitive = null;
            if (this.mForcePrimitives) {
                primitive = mPrimitives.get(params[ctr].getClass());
            }
            signature[ctr] = primitive != null ? (String)primitive : params[ctr].getClass().getName();
            ++ctr;
        }
        return signature;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

